/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.custom.block;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;

public class ShroomStemBlockPackage
extends DataGenBlockPackage {
    private DataGenBlockModels blockModels = null;

    public ShroomStemBlockPackage() {
        super(AoABlocks.SHROOM_STEM);
        this.blockTags(BlockTags.f_144280_);
        this.dropsType(DataGenBlockLootTables.BlockDropType.SILK_TOUCH);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return this::customModel;
        });
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().singleTexture(outputPath.toString(), this.blockModels.mcLoc("block/block"), "texture", outputPath)).texture("particle", outputPath);
        ModelBuilder.ElementBuilder element = model.element();
        element.from(5.0f, 0.0f, 5.0f).to(11.0f, 16.0f, 11.0f);
        element.face(Direction.NORTH).uvs(9.0f, 3.0f, 12.0f, 15.0f).texture("#texture");
        element.face(Direction.EAST).uvs(6.0f, 3.0f, 9.0f, 15.0f).texture("#texture");
        element.face(Direction.SOUTH).uvs(3.0f, 3.0f, 6.0f, 15.0f).texture("#texture");
        element.face(Direction.WEST).uvs(0.0f, 3.0f, 3.0f, 15.0f).texture("#texture");
        element.face(Direction.UP).uvs(3.0f, 0.0f, 6.0f, 3.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(6.0f, 0.0f, 9.0f, 3.0f).texture("#texture");
        this.blockModels.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        DataGenBlockModels.itemModel(this.blockModels.itemModels(), blockPackage, (ModelFile)model);
    }
}

