/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.custom.block;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.misc.LivingGrowth;

public class LivingGrowthBlockPackage
extends DataGenBlockPackage {
    private DataGenBlockModels blockModels = null;

    public LivingGrowthBlockPackage() {
        super(AoABlocks.LIVING_GROWTH);
        this.dropsType(DataGenBlockLootTables.BlockDropType.NONE);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return this::customModel;
        });
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder baseModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().getBuilder(outputPath.toString())).texture("texture", "#")).texture("particle", "#");
        baseModel.ao(false);
        ModelBuilder.ElementBuilder element = baseModel.element();
        element.shade(false);
        element.from(8.0f, 0.0f, 0.0f).to(8.0f, 32.0f, 16.0f);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 8.0f, 16.0f).texture("#texture");
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 8.0f, 16.0f).texture("#texture");
        element = baseModel.element();
        element.shade(false);
        element.from(0.0f, 0.0f, 8.0f).to(16.0f, 32.0f, 8.0f);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 8.0f, 16.0f).texture("#texture");
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 8.0f, 16.0f).texture("#texture");
        VariantBlockStateBuilder stateBuilder = this.blockModels.getVariantBuilder(block);
        for (int i = 0; i <= 5; ++i) {
            String stage = outputPath.toString() + "_stage" + i;
            stateBuilder.partialState().with((Property)LivingGrowth.GROWTH_STAGE, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModels.models().withExistingParent(stage, new ResourceLocation("aoa3", "block/living_growth"))).texture("texture", stage)).texture("particle", stage)).ao(false))});
        }
    }
}

