/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.custom.block;

import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootPoolBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootTableBuilder;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.misc.FertilisedFarmland;

public class FertilisedFarmlandBlockPackage
extends DataGenBlockPackage {
    private DataGenBlockModels blockModels = null;

    public FertilisedFarmlandBlockPackage() {
        super(AoABlocks.FERTILISED_FARMLAND);
        this.blockTags(BlockTags.f_144283_);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return this::customModel;
        });
        this.customDrops(dataGen -> this::customDrops);
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        CompactBlockModelBuilder<Block> modelBuilder = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "", true);
        CompactBlockModelBuilder<Block> wellFertilisedModelBuilder = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_2", true);
        CompactBlockModelBuilder<Block> modelBuilderMoist = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_moist", true);
        CompactBlockModelBuilder<Block> wellFertilisedModelBuilderMoist = new CompactBlockModelBuilder<Block>(this.blockModels, blockPackage.getBlock(), "_2_moist", true);
        VariantBlockStateBuilder stateBuilder = modelBuilder.stateBuilder();
        modelBuilder.parent("farmland");
        wellFertilisedModelBuilder.parent("farmland");
        modelBuilderMoist.parent("farmland");
        wellFertilisedModelBuilderMoist.parent("farmland");
        modelBuilder.setTexture("top", this.blockModels.blockTexture(blockPackage.getBlock()));
        wellFertilisedModelBuilder.setTexture("top", DataGenBlockModels.extend(this.blockModels.blockTexture(blockPackage.getBlock()), "_2"));
        modelBuilderMoist.setTexture("top", DataGenBlockModels.extend(this.blockModels.blockTexture(blockPackage.getBlock()), "_moist"));
        wellFertilisedModelBuilderMoist.setTexture("top", DataGenBlockModels.extend(this.blockModels.blockTexture(blockPackage.getBlock()), "_2_moist"));
        for (int i = 0; i < 8; ++i) {
            if (i <= 6) {
                stateBuilder.partialState().with((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(i)).with((Property)FertilisedFarmland.WELL_FERTILISED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(modelBuilder)});
                stateBuilder.partialState().with((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(i)).with((Property)FertilisedFarmland.WELL_FERTILISED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(wellFertilisedModelBuilder)});
                continue;
            }
            stateBuilder.partialState().with((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(i)).with((Property)FertilisedFarmland.WELL_FERTILISED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(modelBuilderMoist)});
            stateBuilder.partialState().with((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(i)).with((Property)FertilisedFarmland.WELL_FERTILISED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(wellFertilisedModelBuilderMoist)});
        }
        modelBuilder.itemModel();
    }

    private void customDrops(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().item((ItemLike)Blocks.f_50493_, 1, new Consumer[0]).ifSurvivesExplosion()).finalize(lootTables);
    }
}

