/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.custom.block;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.misc.DustopianLamp;

public class DustopianLampBlockPackage
extends DataGenBlockPackage {
    private DataGenBlockModels blockModels = null;

    public DustopianLampBlockPackage() {
        super(AoABlocks.DUSTOPIAN_LAMP);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return this::customModel;
        });
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockModels.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)this.blockModels.models().cubeAll(outputPath.toString(), outputPath);
        BlockModelBuilder offModel = (BlockModelBuilder)this.blockModels.models().cubeAll(outputPath.toString() + "_off", DataGenBlockModels.extend(outputPath, "_off"));
        VariantBlockStateBuilder blockState = this.blockModels.getVariantBuilder(block);
        blockState.partialState().with((Property)DustopianLamp.LIT, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        blockState.partialState().with((Property)DustopianLamp.LIT, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)offModel)});
        DataGenBlockModels.itemModel(this.blockModels.itemModels(), blockPackage, (ModelFile)offModel);
    }
}

