/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages.custom.block;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.advent.datagen.packages.generic.block.GenericStoneStairsBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;

public class ArchaicTileStreamStairsBlockPackage
extends GenericStoneStairsBlockPackage {
    private DataGenBlockModels blockModels = null;

    public ArchaicTileStreamStairsBlockPackage() {
        super(AoABlocks.ARCHAIC_TILE_STREAM_STAIRS);
        this.linkObject("source_block", AoABlocks.ARCHAIC_TILE_STREAM);
        this.customModel((DataGenBlockModels dataGen) -> {
            this.blockModels = dataGen;
            return this::customModel;
        });
    }

    private void customModel(DataGenBlockPackage blockPackage) {
        StairBlock block = (StairBlock)blockPackage.getBlock();
        String outputPath = this.blockModels.blockTexture((Block)block).toString();
        ResourceLocation baseBlockOutputPath = this.blockModels.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("source_block")).get());
        BlockModelBuilder model = (BlockModelBuilder)this.blockModels.models().withExistingParent(outputPath, this.blockModels.mcLoc("block/block"));
        BlockModelBuilder modelInner = (BlockModelBuilder)this.blockModels.models().stairsInner(outputPath + "_inner", baseBlockOutputPath, baseBlockOutputPath, DataGenBlockModels.extend(baseBlockOutputPath, "_top"));
        BlockModelBuilder modelOuter = (BlockModelBuilder)this.blockModels.models().stairsOuter(outputPath + "_outer", baseBlockOutputPath, baseBlockOutputPath, DataGenBlockModels.extend(baseBlockOutputPath, "_top"));
        model.texture("bottom", baseBlockOutputPath);
        model.texture("top", DataGenBlockModels.extend(baseBlockOutputPath, "_top"));
        model.texture("particle", baseBlockOutputPath);
        ModelBuilder.TransformsBuilder transforms = model.transforms();
        transforms.transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f, 0.625f, 0.625f);
        transforms.transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, -90.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(1.0f, 1.0f, 1.0f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(75.0f, -135.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f);
        ModelBuilder.ElementBuilder element = model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 16.0f);
        element.face(Direction.NORTH).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture("#top").cullface(Direction.NORTH);
        element.face(Direction.EAST).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture("#bottom").cullface(Direction.EAST);
        element.face(Direction.SOUTH).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture("#top").cullface(Direction.SOUTH);
        element.face(Direction.WEST).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture("#bottom").cullface(Direction.WEST);
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#bottom");
        element.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#bottom").cullface(Direction.DOWN);
        element = model.element().from(8.0f, 8.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 8.0f, 8.0f).texture("#top").cullface(Direction.NORTH);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture("#bottom").cullface(Direction.EAST);
        element.face(Direction.SOUTH).uvs(8.0f, 0.0f, 16.0f, 8.0f).texture("#top").cullface(Direction.SOUTH);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture("#bottom");
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 8.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#bottom").cullface(Direction.UP);
        this.blockModels.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)(shape == StairsShape.STRAIGHT ? model : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? modelInner : modelOuter))).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).uvLock(false).build();
        }, new Property[]{StairBlock.f_56844_});
        DataGenBlockModels.itemModel(this.blockModels.itemModels(), blockPackage, (ModelFile)model);
    }
}

