/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.registries.RegistryObject;

public class DataGenSoundPackage {
    private final RegistryObject<SoundEvent> sound;
    protected String subtitle = null;
    private final ArrayList<SoundPackageSound> sounds = new ArrayList(1);

    public DataGenSoundPackage(RegistryObject<SoundEvent> sound, String basePath, int variations) {
        this.sound = sound;
        for (int i = 1; i <= variations; ++i) {
            this.sounds.add(new SoundPackageSound(basePath + "-" + (i < 10 ? "0" : "") + i));
        }
    }

    public DataGenSoundPackage(RegistryObject<SoundEvent> sound, String ... paths) {
        this.sound = sound;
        for (String st : paths) {
            this.sounds.add(new SoundPackageSound(st));
        }
    }

    @Nullable
    public String getSubtitle() {
        return this.subtitle;
    }

    public DataGenSoundPackage stream() {
        this.sounds.forEach(SoundPackageSound::stream);
        return this;
    }

    public DataGenSoundPackage subtitle(String langKey) {
        this.subtitle = langKey;
        return this;
    }

    public DataGenSoundPackage sound(SoundPackageSound sound) {
        this.sounds.add(sound);
        return this;
    }

    public String name() {
        return ((SoundEvent)this.sound.get()).m_11660_().m_135815_();
    }

    public JsonObject toJson() {
        if (this.sounds.isEmpty()) {
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonArray soundArray = new JsonArray();
        if (this.subtitle != null) {
            obj.addProperty("subtitle", "subtitles." + this.name());
        }
        for (SoundPackageSound sound : this.sounds) {
            soundArray.add(sound.toJson());
        }
        obj.add("sounds", (JsonElement)soundArray);
        return obj;
    }

    private static class SoundPackageSound {
        private boolean nonDefault = false;
        private final String path;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private int weight = 1;
        private boolean stream = false;
        private int attenuationDistance = 16;
        private boolean preloadSound = false;
        private Sound.Type type = Sound.Type.FILE;

        private SoundPackageSound(String path) {
            this.path = "aoa3:" + path;
        }

        public SoundPackageSound volume(float volume) {
            this.volume = Mth.m_14036_((float)volume, (float)0.0f, (float)1.0f);
            this.nonDefault = true;
            return this;
        }

        public SoundPackageSound pitch(float pitch) {
            this.pitch = pitch;
            this.nonDefault = true;
            return this;
        }

        public SoundPackageSound weight(int weight) {
            this.weight = Math.max(weight, 0);
            this.nonDefault = true;
            return this;
        }

        public SoundPackageSound stream() {
            this.stream = true;
            this.nonDefault = true;
            return this;
        }

        public SoundPackageSound attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            this.nonDefault = true;
            return this;
        }

        public SoundPackageSound preloaded() {
            this.preloadSound = true;
            this.nonDefault = true;
            return this;
        }

        public SoundPackageSound isReference() {
            this.type = Sound.Type.SOUND_EVENT;
            this.nonDefault = true;
            return this;
        }

        private JsonElement toJson() {
            if (!this.nonDefault) {
                return new JsonPrimitive(this.path);
            }
            JsonObject soundObject = new JsonObject();
            soundObject.addProperty("name", this.path);
            if (this.volume != 1.0f) {
                soundObject.addProperty("volume", (Number)Float.valueOf(this.volume));
            }
            if (this.pitch != 1.0f) {
                soundObject.addProperty("pitch", (Number)Float.valueOf(this.pitch));
            }
            if (this.weight != 1) {
                soundObject.addProperty("weight", (Number)this.weight);
            }
            if (this.stream) {
                soundObject.addProperty("stream", Boolean.valueOf(true));
            }
            if (this.attenuationDistance != 16) {
                soundObject.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            if (this.preloadSound) {
                soundObject.addProperty("preload", Boolean.valueOf(true));
            }
            if (this.type != Sound.Type.FILE) {
                soundObject.addProperty("type", "event");
            }
            return soundObject;
        }
    }
}

