/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.DataGenItemModels;
import net.tslat.aoa3.util.StringUtil;

public class DataGenItemPackage {
    private final RegistryObject<? extends Item> item;
    private String englishName;
    private DataGenItemModels.ModelType modelType = DataGenItemModels.ModelType.BASIC;
    private TagKey<Item>[] tags = null;
    private HashMap<String, Object> linkedObjects = null;
    private ArrayList<Tuple<String, String>> relatedLocaleEntries = null;

    public DataGenItemPackage(RegistryObject<? extends Item> item) {
        this.item = item;
        this.englishName = StringUtil.toTitleCase(item.getId().m_135815_());
    }

    public DataGenItemPackage englishName(String name) {
        this.englishName = name;
        return this;
    }

    public DataGenItemPackage model(DataGenItemModels.ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    public DataGenItemPackage customModel(Function<DataGenItemModels, Consumer<DataGenItemPackage>> modelFunction) {
        this.modelType = null;
        this.linkObject("model_function", modelFunction);
        return this;
    }

    public DataGenItemPackage tags(TagKey<Item> ... tags) {
        this.tags = tags;
        return this;
    }

    public DataGenItemPackage linkObject(String ref, Object obj) {
        if (this.linkedObjects == null) {
            this.linkedObjects = new HashMap();
        }
        this.linkedObjects.put(ref, obj);
        return this;
    }

    public DataGenItemPackage addLocale(String langKey, String translation) {
        if (this.relatedLocaleEntries == null) {
            this.relatedLocaleEntries = new ArrayList(1);
        }
        this.relatedLocaleEntries.add((Tuple<String, String>)new Tuple((Object)langKey, (Object)translation));
        return this;
    }

    public DataGenItemPackage addTooltipTranslations(String ... translations) {
        if (this.relatedLocaleEntries == null) {
            this.relatedLocaleEntries = new ArrayList(1);
        }
        for (int i = 1; i <= translations.length; ++i) {
            this.relatedLocaleEntries.add((Tuple<String, String>)new Tuple((Object)("item.aoa3." + this.item.getId().m_135815_() + ".desc." + i), (Object)translations[i - 1]));
        }
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.item.getId();
    }

    public Item getItem() {
        return (Item)this.item.get();
    }

    public String getName() {
        return this.englishName;
    }

    @Nullable
    public DataGenItemModels.ModelType getModelType() {
        return this.modelType;
    }

    public TagKey<Item>[] getItemTags() {
        return this.tags == null ? new TagKey[]{} : this.tags;
    }

    public Object getLinkedObject(String ref) {
        if (this.linkedObjects == null) {
            throw new IllegalStateException("Invalid datagen item package, attempted to retrieve linked object: " + ref + ", but no linked objects present. (" + this.item.getId().toString() + ")");
        }
        if (!this.linkedObjects.containsKey(ref)) {
            throw new IllegalArgumentException("Invalid datagen item package, attempted to retrieve linked object: " + ref + ", but linked object with that reference wasn't provided. (" + this.item.getId().toString() + ")");
        }
        return this.linkedObjects.get(ref);
    }

    public void addLocaleEntries(LanguageProvider langProvider) {
        langProvider.addItem(this.item, this.getName());
        if (this.relatedLocaleEntries != null) {
            for (Tuple<String, String> langEntry : this.relatedLocaleEntries) {
                langProvider.add((String)langEntry.m_14418_(), (String)langEntry.m_14419_());
            }
        }
    }
}

