/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.util.StringUtil;

public class DataGenEntityPackage {
    private final RegistryObject<EntityType<?>> entity;
    private String englishName;
    private TagKey<EntityType<?>>[] tags = null;
    private ArrayList<Tuple<String, String>> relatedLocaleEntries = null;

    public DataGenEntityPackage(RegistryObject<? extends EntityType<?>> entity) {
        this.entity = entity;
        this.englishName = StringUtil.toTitleCase(entity.getId().m_135815_());
    }

    public DataGenEntityPackage englishName(String name) {
        this.englishName = name;
        return this;
    }

    public DataGenEntityPackage tags(TagKey<EntityType<?>> ... tags) {
        this.tags = tags;
        return this;
    }

    public DataGenEntityPackage addLocale(String langKey, String translation) {
        if (this.relatedLocaleEntries == null) {
            this.relatedLocaleEntries = new ArrayList(1);
        }
        this.relatedLocaleEntries.add((Tuple<String, String>)new Tuple((Object)langKey, (Object)translation));
        return this;
    }

    public DataGenEntityPackage addSuffixedLocale(String suffix, String translation) {
        return this.addLocale(((EntityType)this.entity.get()).m_20675_() + "." + suffix, translation);
    }

    public ResourceLocation getRegistryName() {
        return this.entity.getId();
    }

    public EntityType<?> getEntity() {
        return (EntityType)this.entity.get();
    }

    public String getName() {
        return this.englishName;
    }

    public TagKey<EntityType<?>>[] getEntityTags() {
        return this.tags == null ? new TagKey[]{} : this.tags;
    }

    public void addLocaleEntries(LanguageProvider langProvider) {
        langProvider.addEntityType(this.entity, this.getName());
        if (this.relatedLocaleEntries != null) {
            for (Tuple<String, String> langEntry : this.relatedLocaleEntries) {
                langProvider.add((String)langEntry.m_14418_(), (String)langEntry.m_14419_());
            }
        }
    }
}

