/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.util.StringUtil;

public class DataGenBlockPackage {
    private final RegistryObject<? extends Block> block;
    private Item item = null;
    private String englishName;
    private DataGenBlockModels.ModelType modelType = DataGenBlockModels.ModelType.BASIC;
    private DataGenBlockLootTables.BlockDropType lootType = DataGenBlockLootTables.BlockDropType.NORMAL;
    private List<TagKey<Block>> blockTags = null;
    private List<TagKey<Item>> itemTags = null;
    private List<TagKey<Fluid>> fluidTags = null;
    private HashMap<String, Object> linkedObjects = null;
    private ArrayList<Tuple<String, String>> relatedLocaleEntries = null;

    public DataGenBlockPackage(RegistryObject<? extends Block> block) {
        this.block = block;
        this.englishName = StringUtil.toTitleCase(block.getId().m_135815_());
    }

    public DataGenBlockPackage englishName(String name) {
        this.englishName = name;
        return this;
    }

    public DataGenBlockPackage model(DataGenBlockModels.ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    public DataGenBlockPackage customModel(Function<DataGenBlockModels, Consumer<DataGenBlockPackage>> modelFunction) {
        this.modelType = null;
        this.linkObject("model_function", modelFunction);
        return this;
    }

    public DataGenBlockPackage dropsType(DataGenBlockLootTables.BlockDropType dropsType) {
        this.lootType = dropsType;
        return this;
    }

    public DataGenBlockPackage customDrops(Function<DataGenBlockLootTables, BiConsumer<DataGenBlockPackage, HashMap<ResourceLocation, LootTable>>> lootTableFunction) {
        this.lootType = null;
        this.linkObject("loot_table_function", lootTableFunction);
        return this;
    }

    public DataGenBlockPackage itemTags(TagKey<Item> ... tags) {
        if (this.itemTags == null) {
            this.itemTags = new ArrayList<TagKey<Item>>(tags.length);
        }
        this.itemTags.addAll(Arrays.asList(tags));
        return this;
    }

    public DataGenBlockPackage blockTags(TagKey<Block> ... tags) {
        if (this.blockTags == null) {
            this.blockTags = new ArrayList<TagKey<Block>>(tags.length);
        }
        this.blockTags.addAll(Arrays.asList(tags));
        return this;
    }

    public DataGenBlockPackage fluidTags(TagKey<Fluid> ... tags) {
        if (this.fluidTags == null) {
            this.fluidTags = new ArrayList<TagKey<Fluid>>(tags.length);
        }
        this.fluidTags.addAll(Arrays.asList(tags));
        return this;
    }

    public DataGenBlockPackage addLocale(String langKey, String translation) {
        if (this.relatedLocaleEntries == null) {
            this.relatedLocaleEntries = new ArrayList(1);
        }
        this.relatedLocaleEntries.add((Tuple<String, String>)new Tuple((Object)langKey, (Object)translation));
        return this;
    }

    public DataGenBlockPackage addTooltipTranslations(String ... translations) {
        if (this.relatedLocaleEntries == null) {
            this.relatedLocaleEntries = new ArrayList(1);
        }
        for (int i = 1; i <= translations.length; ++i) {
            this.relatedLocaleEntries.add((Tuple<String, String>)new Tuple((Object)("item.aoa3." + this.block.getId().m_135815_() + ".desc." + i), (Object)translations[i - 1]));
        }
        return this;
    }

    public DataGenBlockPackage linkObject(String ref, Object obj) {
        if (this.linkedObjects == null) {
            this.linkedObjects = new HashMap();
        }
        this.linkedObjects.put(ref, obj);
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.block.getId();
    }

    public Block getBlock() {
        return (Block)this.block.get();
    }

    public boolean hasItem() {
        this.item = this.getBlock().m_5456_();
        return this.item != Items.f_41852_;
    }

    public Item getItem() {
        if (this.item == null) {
            this.item = this.getBlock().m_5456_();
        }
        if (this.item == Items.f_41852_) {
            throw new IllegalStateException("Invalid datagen block package, attempted to retrieve item, but no item was registered. (" + this.block.getId().toString() + ")");
        }
        return this.item;
    }

    public String getName() {
        return this.englishName;
    }

    @Nullable
    public DataGenBlockModels.ModelType getModelType() {
        return this.modelType;
    }

    @Nullable
    public DataGenBlockLootTables.BlockDropType getDropsType() {
        return this.lootType;
    }

    public TagKey<Block>[] getBlockTags() {
        return this.blockTags == null ? new TagKey[]{} : this.blockTags.toArray(new TagKey[0]);
    }

    public TagKey<Item>[] getItemTags() {
        if (this.itemTags != null && !this.hasItem()) {
            throw new IllegalStateException("Invalid datagen block package, assigned item tags, but no item was registered. (" + this.block.getId().toString() + ")");
        }
        return this.itemTags == null ? new TagKey[]{} : this.itemTags.toArray(new TagKey[0]);
    }

    public TagKey<Fluid>[] getFluidTags() {
        return this.fluidTags == null ? new TagKey[]{} : this.fluidTags.toArray(new TagKey[0]);
    }

    public boolean hasLinkedObject(String ref) {
        return this.linkedObjects != null && this.linkedObjects.containsKey(ref);
    }

    public Object getLinkedObject(String ref) {
        if (this.linkedObjects == null) {
            throw new IllegalStateException("Invalid datagen block package, attempted to retrieve linked object: " + ref + ", but no linked objects present. (" + this.block.getId().toString() + ")");
        }
        if (!this.linkedObjects.containsKey(ref)) {
            throw new IllegalArgumentException("Invalid datagen block package, attempted to retrieve linked object: " + ref + ", but linked object with that reference wasn't provided. (" + this.block.getId().toString() + ")");
        }
        return this.linkedObjects.get(ref);
    }

    public void addLocaleEntries(LanguageProvider langProvider) {
        langProvider.addBlock(this.block, this.getName());
        if (this.relatedLocaleEntries != null) {
            for (Tuple<String, String> langEntry : this.relatedLocaleEntries) {
                langProvider.add((String)langEntry.m_14418_(), (String)langEntry.m_14419_());
            }
        }
    }
}

