/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.packages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public interface ConfiguredSurfaceBuilderPackage {
    public ResourceLocation getId();

    public JsonObject toJson();

    default public JsonObject stateToJson(BlockState state) {
        JsonObject obj = new JsonObject();
        obj.addProperty("Name", ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString());
        if (!state.m_61147_().isEmpty()) {
            JsonObject propertiesObj = new JsonObject();
            for (Property property : state.m_61147_()) {
                propertiesObj.addProperty(property.m_61708_(), String.valueOf(state.m_61143_(property)));
            }
            obj.add("Properties", (JsonElement)propertiesObj);
        }
        return obj;
    }

    default public void finalize(ArrayList<ConfiguredSurfaceBuilderPackage> configuredSurfaceBuilderList) {
        configuredSurfaceBuilderList.add(this);
    }

    public static final class Oceanless
    implements ConfiguredSurfaceBuilderPackage {
        private static final ResourceLocation type = new ResourceLocation("aoa3", "oceanless");
        private final ResourceLocation id;
        private final BlockState surfaceBlock;
        private final BlockState subsurfaceBlock;

        public Oceanless(String id, BlockState surfaceBlock, BlockState subsurfaceBlock) {
            this.id = new ResourceLocation("aoa3", id);
            this.surfaceBlock = surfaceBlock;
            this.subsurfaceBlock = subsurfaceBlock;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            JsonObject configObj = new JsonObject();
            obj.addProperty("type", type.toString());
            configObj.add("surface_block", (JsonElement)this.stateToJson(this.surfaceBlock));
            configObj.add("subsurface_block", (JsonElement)this.stateToJson(this.subsurfaceBlock));
            obj.add("config", (JsonElement)configObj);
            return obj;
        }
    }

    public static final class Mirrored
    implements ConfiguredSurfaceBuilderPackage {
        private static final ResourceLocation type = new ResourceLocation("aoa3", "mirrored");
        private final ResourceLocation id;
        private final BlockState surfaceBlock;
        private final BlockState subsurfaceBlock;
        private final BlockState invertedSurfaceBlock;
        private final BlockState invertedSubsurfaceBlock;

        public Mirrored(String id, BlockState surfaceBlock, BlockState subsurfaceBlock, BlockState invertedSurfaceBlock, BlockState invertedSubsurfaceBlock) {
            this.id = new ResourceLocation("aoa3", id);
            this.surfaceBlock = surfaceBlock;
            this.subsurfaceBlock = subsurfaceBlock;
            this.invertedSurfaceBlock = invertedSurfaceBlock;
            this.invertedSubsurfaceBlock = invertedSubsurfaceBlock;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            JsonObject configObj = new JsonObject();
            obj.addProperty("type", type.toString());
            configObj.add("surface_block", (JsonElement)this.stateToJson(this.surfaceBlock));
            configObj.add("subsurface_block", (JsonElement)this.stateToJson(this.subsurfaceBlock));
            configObj.add("inverted_surface_block", (JsonElement)this.stateToJson(this.invertedSurfaceBlock));
            configObj.add("inverted_subsurface_block", (JsonElement)this.stateToJson(this.invertedSubsurfaceBlock));
            obj.add("config", (JsonElement)configObj);
            return obj;
        }
    }

    public static final class Tiered
    implements ConfiguredSurfaceBuilderPackage {
        private static final ResourceLocation type = new ResourceLocation("aoa3", "tiered");
        private final ResourceLocation id;
        private final BlockState surfaceBlock;
        private final BlockState subsurfaceBlock;
        private final ArrayList<Tuple<BlockState, Integer>> fillerBlockTiers = new ArrayList();

        public Tiered(String id, BlockState surfaceBlock, BlockState subsurfaceBlock) {
            this.id = new ResourceLocation("aoa3", id);
            this.surfaceBlock = surfaceBlock;
            this.subsurfaceBlock = subsurfaceBlock;
        }

        public Tiered tier(BlockState block, int maxY) {
            this.fillerBlockTiers.add((Tuple<BlockState, Integer>)new Tuple((Object)block, (Object)maxY));
            return this;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            JsonObject configObj = new JsonObject();
            JsonArray tiers = new JsonArray();
            obj.addProperty("type", type.toString());
            configObj.add("surface_block", (JsonElement)this.stateToJson(this.surfaceBlock));
            configObj.add("subsurface_block", (JsonElement)this.stateToJson(this.subsurfaceBlock));
            if (this.fillerBlockTiers.isEmpty()) {
                this.fillerBlockTiers.add((Tuple<BlockState, Integer>)new Tuple((Object)this.subsurfaceBlock, (Object)256));
            }
            this.fillerBlockTiers.sort(Comparator.comparing(Tuple::m_14419_));
            for (Tuple<BlockState, Integer> tier : this.fillerBlockTiers) {
                JsonObject tierObj = new JsonObject();
                tierObj.add("block", (JsonElement)this.stateToJson((BlockState)tier.m_14418_()));
                tierObj.addProperty("max_y", (Number)tier.m_14419_());
                tiers.add((JsonElement)tierObj);
            }
            configObj.add("filler_block_tiers", (JsonElement)tiers);
            obj.add("config", (JsonElement)configObj);
            return obj;
        }
    }

    public static final class Default
    implements ConfiguredSurfaceBuilderPackage {
        private static final ResourceLocation type = new ResourceLocation("default");
        private final ResourceLocation id;
        private final BlockState surfaceBlock;
        private final BlockState subsurfaceBlock;
        private final BlockState waterbedBlock;

        public Default(String id, BlockState surfaceBlock, BlockState subsurfaceBlock, BlockState waterbedBlock) {
            this.id = new ResourceLocation("aoa3", id);
            this.surfaceBlock = surfaceBlock;
            this.subsurfaceBlock = subsurfaceBlock;
            this.waterbedBlock = waterbedBlock;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            JsonObject configObj = new JsonObject();
            obj.addProperty("type", type.toString());
            configObj.add("top_material", (JsonElement)this.stateToJson(this.surfaceBlock));
            configObj.add("under_material", (JsonElement)this.stateToJson(this.subsurfaceBlock));
            configObj.add("underwater_material", (JsonElement)this.stateToJson(this.waterbedBlock));
            obj.add("config", (JsonElement)configObj);
            return obj;
        }
    }

    public static class Void
    implements ConfiguredSurfaceBuilderPackage {
        private static final ResourceLocation type = new ResourceLocation("nope");
        private final ResourceLocation id;

        public Void(String id) {
            this.id = new ResourceLocation("aoa3", id);
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("type", type.toString());
            obj.add("top_material", (JsonElement)this.stateToJson(Blocks.f_50016_.m_49966_()));
            obj.add("under_material", (JsonElement)this.stateToJson(Blocks.f_50016_.m_49966_()));
            obj.add("underwater_material", (JsonElement)this.stateToJson(Blocks.f_50016_.m_49966_()));
            return obj;
        }
    }
}

