/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.loot;

import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import net.tslat.aoa3.advent.datagen.builder.loot.LootPoolBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootTableBuilder;
import net.tslat.aoa3.advent.datagen.loot.DataGenLootTables;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.player.skill.AoASkill;

public class DataGenMiscLootTables
extends DataGenLootTables {
    public DataGenMiscLootTables(DataGenerator generator) {
        super(generator);
    }

    public String m_6055_() {
        return "Loot Tables - Misc";
    }

    private static void createEntityTables(HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder("entities/base_trader_drops").forEntities().pools(new LootPoolBuilder("coins").empty(890, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, new Consumer[0]).item(AoAItems.SILVER_COIN, 10, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("entities/elder_guardian").forEntities().pools(new LootPoolBuilder("biogenic_armour").empty(100, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.helmet, 10, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.chestplate, 10, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.leggings, 10, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.boots, 10, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("entities/guardian").forEntities().pools(new LootPoolBuilder("biogenic_armour").empty(100, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.helmet, 2, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.chestplate, 2, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.leggings, 2, new Consumer[0]).item(AoAArmour.BIOGENIC_ARMOUR.boots, 2, new Consumer[0])).finalize(lootTables);
    }

    private static void createMiscTables(HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder("misc/rune_randomizer").forGift().pools(new LootPoolBuilder("powered_runes").bonusLuckRolls(0, 1).ifHolding((ItemLike)AoAItems.CHARGED_RUNE.get()).item(AoAItems.COMPASS_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.DISTORTION_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.ENERGY_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.FIRE_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.KINETIC_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.LIFE_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.LUNAR_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.POISON_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.POWER_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.STORM_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.STRIKE_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.WATER_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.WIND_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.WITHER_RUNE, 100, 1, 3, new Consumer[0]), new LootPoolBuilder("unpowered_runes").bonusLuckRolls(1).ifHolding((ItemLike)AoAItems.UNPOWERED_RUNE.get()).item(AoAItems.ENERGY_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.FIRE_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.POISON_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.POWER_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.STRIKE_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.WATER_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.WIND_RUNE, 100, 1, 3, new Consumer[0]).item(AoAItems.WITHER_RUNE, 100, 1, 3, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("misc/carved_rune_blocks").forChests().pools(new LootPoolBuilder("carved_rune_blocks").rolls(1).bonusLuckRolls(0, 1).empty(150, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_DIRECTION, 100, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_REALITY, 100, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_SPACE, 100, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_TRAVEL, 100, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("misc/dispenser_loot").forChests().pools(new LootPoolBuilder("aoa_dispenser_loot").rolls(0, 2).item(AoAWeapons.SLICE_STAR, 75, 1, 5, new Consumer[0]).item(AoAWeapons.GRENADE, 40, 1, 3, new Consumer[0]).item(AoAWeapons.CHAKRAM, 40, 1, 3, new Consumer[0]).item(AoAWeapons.GOO_BALL, 60, 1, 5, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("misc/lotto_totem").forGift().pools(new LootPoolBuilder("treasures").item((ItemLike)AoAItems.GOLDEN_UPGRADE_KIT.get(), 20, new Consumer[0]).item((ItemLike)AoAItems.MAGIC_REPAIR_DUST.get(), 60, 1, 5, new Consumer[0]).item((ItemLike)AoAItems.SMALL_SKILL_CRYSTAL.get(), 75, 1, 10, new Consumer[0]).item((ItemLike)AoAItems.MEDIUM_SKILL_CRYSTAL.get(), 50, 1, 9, new Consumer[0]).item((ItemLike)AoAItems.LARGE_SKILL_CRYSTAL.get(), 35, 1, 8, new Consumer[0]).item((ItemLike)AoAItems.GIANT_SKILL_CRYSTAL.get(), 20, 1, 7, new Consumer[0]).item((ItemLike)Items.f_42415_, 90, 5, 25, new Consumer[0]).item((ItemLike)Items.f_42616_, 60, 5, 25, new Consumer[0]).item((ItemLike)Items.f_42686_, 15, new Consumer[0]).item((ItemLike)AoAWeapons.COLOUR_CANNON.get(), 1, new Consumer[0]).item((ItemLike)Items.f_42586_, 19, new Consumer[0]).item((ItemLike)Items.f_42612_, 100, 10, 32, new Consumer[0]).item((ItemLike)Items.f_42437_, 15, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("misc/rare_table").forEntities().pools(new LootPoolBuilder("treasures").empty(250, new Consumer[0]).item((ItemLike)AoAItems.GOLDEN_UPGRADE_KIT.get(), 20, new Consumer[0]).item((ItemLike)AoAItems.MAGIC_REPAIR_DUST.get(), 60, 1, 5, new Consumer[0]).item((ItemLike)AoAItems.SMALL_SKILL_CRYSTAL.get(), 75, 1, 10, new Consumer[0]).item((ItemLike)AoAItems.MEDIUM_SKILL_CRYSTAL.get(), 50, 1, 9, new Consumer[0]).item((ItemLike)AoAItems.LARGE_SKILL_CRYSTAL.get(), 35, 1, 8, new Consumer[0]).item((ItemLike)AoAItems.GIANT_SKILL_CRYSTAL.get(), 20, 1, 7, new Consumer[0]).item((ItemLike)Items.f_42415_, 90, 5, 25, new Consumer[0]).item((ItemLike)Items.f_42616_, 60, 5, 25, new Consumer[0]).item((ItemLike)Items.f_42686_, 15, new Consumer[0]).item((ItemLike)AoAWeapons.COLOUR_CANNON.get(), 1, new Consumer[0]).item((ItemLike)Items.f_42586_, 19, new Consumer[0]).item((ItemLike)Items.f_42612_, 100, 10, 32, new Consumer[0]).item((ItemLike)Items.f_42437_, 15, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("misc/fishing_cage_catches").forFishing().pools(new LootPoolBuilder().item((ItemLike)Items.f_42526_, 100, -1, new Consumer[0]).item((ItemLike)Items.f_42527_, 100, -1, new Consumer[0]).item((ItemLike)Items.f_42528_, 80, -1, new Consumer[0]).item((ItemLike)Items.f_42529_, 60, new Consumer[0]).item((ItemLike)Items.f_42715_, 20, 1, new Consumer[0]).item((ItemLike)Items.f_42415_, 30, new Consumer[0]).item((ItemLike)Items.f_42616_, 10, 2, new Consumer[0]).item(AoAItems.RUNE_BOX, 20, 1, new Consumer[0]).item(AoAItems.SHINY_BOX, 20, 1, new Consumer[0]).item(AoAItems.SAILBACK, 75, entry -> entry.ifHasLevel((AoASkill)AoASkills.HAULING.get(), 10)).item(AoAItems.VIOLET_SKIPPER, 75, entry -> entry.ifHasLevel((AoASkill)AoASkills.HAULING.get(), 10)).item(AoAItems.RAW_RAINBOWFISH, 30, 2, entry -> entry.ifHasLevel((AoASkill)AoASkills.HAULING.get(), 10)).item(AoAItems.ARMOUR_PLATING, 30, 1, new Consumer[0]).item(AoAItems.CHITIN, 45, new Consumer[0]).item(AoAItems.CHUM, 55, new Consumer[0]).item((ItemLike)Items.f_41988_, 40, new Consumer[0]).item((ItemLike)Items.f_42696_, 40, new Consumer[0]).item((ItemLike)AoAWeapons.TIDAL_GREATBLADE.get(), 1, 3, new Consumer[0])).finalize(lootTables);
    }

    private static void createItemTables(HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder("items/crystal_box").forGift().pools(new LootPoolBuilder("crystals").item(AoAItems.GIANT_SKILL_CRYSTAL, 10, new Consumer[0]).item(AoAItems.LARGE_SKILL_CRYSTAL, 40, new Consumer[0]).item(AoAItems.MEDIUM_SKILL_CRYSTAL, 130, new Consumer[0]).item(AoAItems.SMALL_SKILL_CRYSTAL, 280, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("items/gem_bag").forGift().pools(new LootPoolBuilder("gems").rolls(1, 4).item((ItemLike)Items.f_42415_, 50, new Consumer[0]).item((ItemLike)Items.f_42616_, 35, new Consumer[0]).item((ItemLike)Items.f_42534_, 85, new Consumer[0]).item((ItemLike)Items.f_42696_, 70, new Consumer[0]).item((ItemLike)Items.f_42692_, 75, new Consumer[0]).item((ItemLike)Items.f_151049_, 60, new Consumer[0]).item(AoAItems.JADE, 40, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("items/rune_box").forGift().pools(new LootPoolBuilder("runes").item(AoAItems.WIND_RUNE, 100, new Consumer[0]).item(AoAItems.FIRE_RUNE, 100, new Consumer[0]).item(AoAItems.WATER_RUNE, 100, new Consumer[0]).item(AoAItems.WITHER_RUNE, 100, new Consumer[0]).item(AoAItems.ENERGY_RUNE, 100, new Consumer[0]).item(AoAItems.LUNAR_RUNE, 100, new Consumer[0]).item(AoAItems.KINETIC_RUNE, 100, new Consumer[0]).item(AoAItems.DISTORTION_RUNE, 100, new Consumer[0]).item(AoAItems.POISON_RUNE, 100, new Consumer[0]).item(AoAItems.STRIKE_RUNE, 100, new Consumer[0]).item(AoAItems.POWER_RUNE, 100, new Consumer[0]).item(AoAItems.STORM_RUNE, 100, new Consumer[0]).item(AoAItems.LIFE_RUNE, 100, new Consumer[0]).item(AoAItems.COMPASS_RUNE, 100, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("items/shiny_box").forGift().pools(new LootPoolBuilder("minerals").rolls(2, 5).item((ItemLike)Items.f_42416_, 75, new Consumer[0]).item((ItemLike)Items.f_42417_, 60, new Consumer[0]).item((ItemLike)Items.f_42418_, 55, new Consumer[0]).item(AoAItems.LIMONITE_INGOT, 80, new Consumer[0]).item(AoAItems.SHYRESTONE_INGOT, 10, new Consumer[0]).item(AoAItems.VARSIUM_INGOT, 50, new Consumer[0]).item(AoAItems.MYSTITE_INGOT, 35, new Consumer[0]).item(AoAItems.LYON_INGOT, 35, new Consumer[0]).item(AoAItems.GHOULISH_INGOT, 20, new Consumer[0]).item(AoAItems.GHASTLY_INGOT, 20, new Consumer[0]).item(AoAItems.EMBERSTONE_INGOT, 50, new Consumer[0]).item(AoAItems.ELECANIUM_INGOT, 20, new Consumer[0]).item(AoAItems.BLAZIUM_INGOT, 50, new Consumer[0]).item(AoAItems.BARONYTE_INGOT, 50, new Consumer[0]).item(AoAItems.SKELETAL_INGOT, 50, new Consumer[0]).item(AoAItems.LUNAR_INGOT, 20, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("items/treasure_box").forGift().pools(new LootPoolBuilder("main").item(AoAItems.COPPER_COIN, 75, 4, 10, new Consumer[0]).item(AoAItems.SILVER_COIN, 50, new Consumer[0]).item(AoAItems.LIMONITE_INGOT, 50, 3, 7, new Consumer[0]).item((ItemLike)Items.f_42612_, 30, 3, 10, new Consumer[0]).item(AoAItems.MAGIC_MENDING_COMPOUND, 5, 1, 3, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 10, new Consumer[0]).item(AoAItems.GOLD_COIN, 6, new Consumer[0]).item((ItemLike)Items.f_42415_, 10, 2, 8, new Consumer[0]).item(AoAArmour.UTOPIAN_ARMOUR.helmet, 5, new Consumer[0]).item(AoAArmour.UTOPIAN_ARMOUR.chestplate, 5, new Consumer[0]).item(AoAArmour.UTOPIAN_ARMOUR.leggings, 5, new Consumer[0]).item(AoAArmour.UTOPIAN_ARMOUR.boots, 5, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("items/weapons_case").forGift().pools(new LootPoolBuilder("main").item(AoAWeapons.GOO_BALL, 100, 5, 15, new Consumer[0]).item(AoAWeapons.VULKRAM, 100, 5, 15, new Consumer[0]).item(AoAWeapons.HELLFIRE, 100, 5, 15, new Consumer[0]).item(AoAWeapons.CHAKRAM, 100, 5, 15, new Consumer[0]).item(AoAWeapons.SLICE_STAR, 100, 5, 15, new Consumer[0]).item(AoAWeapons.GRENADE, 100, 5, 15, new Consumer[0]).item(AoAItems.CANNONBALL, 100, 8, 40, new Consumer[0]).item(AoAItems.LIMONITE_BULLET, 100, 16, 55, new Consumer[0]).item(AoAItems.METAL_SLUG, 100, 8, 40, new Consumer[0]).item(AoAItems.SPREADSHOT, 100, 5, 15, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("items/crystaneer").forGift().pools(new LootPoolBuilder("main").item((ItemLike)Items.f_42415_, 100, new Consumer[0]).item((ItemLike)Items.f_42616_, 85, new Consumer[0]).item((ItemLike)Items.f_151049_, 120, new Consumer[0]).item(AoAItems.JADE, 110, new Consumer[0]).item(AoAItems.BLUE_GEMSTONES, 25, new Consumer[0]).item(AoAItems.GREEN_GEMSTONES, 25, new Consumer[0]).item(AoAItems.PURPLE_GEMSTONES, 25, new Consumer[0]).item(AoAItems.RED_GEMSTONES, 25, new Consumer[0]).item(AoAItems.WHITE_GEMSTONES, 25, new Consumer[0]).item(AoAItems.YELLOW_GEMSTONES, 25, new Consumer[0]).percentChance(0.2f)).finalize(lootTables);
    }

    private static void createStructureTables(HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder("misc/generic_chest_loot").forChests().pools(new LootPoolBuilder("misc_aoa_loot").rolls(2).bonusLuckRolls(0, 1).empty(100, new Consumer[0]).item((ItemLike)AoAItems.TEA_SEEDS.get(), 20, 1, 2, new Consumer[0]).item((ItemLike)AoAItems.SCRAP_METAL.get(), 19, 1, 2, new Consumer[0]).item((ItemLike)AoAItems.JADE.get(), 15, 1, 3, new Consumer[0]).item((ItemLike)AoAItems.LIMONITE_INGOT.get(), 20, 1, 3, new Consumer[0]).item((ItemLike)AoAItems.LIMONITE_BULLET.get(), 17, 5, 10, new Consumer[0]).item((ItemLike)AoAItems.SPREADSHOT.get(), 10, 3, 7, new Consumer[0]).item((ItemLike)AoAWeapons.SLICE_STAR.get(), 9, 3, 6, new Consumer[0]).item((ItemLike)AoAItems.WIND_RUNE.get(), 17, 1, 4, new Consumer[0]).item((ItemLike)AoAItems.FIRE_RUNE.get(), 17, 1, 4, new Consumer[0]).item((ItemLike)AoAItems.MEDIUM_SKILL_CRYSTAL.get(), 8, new Consumer[0]).item((ItemLike)AoAItems.LARGE_SKILL_CRYSTAL.get(), 1, new Consumer[0]).item((ItemLike)AoAItems.COPPER_COIN.get(), 20, 1, 4, new Consumer[0]).item((ItemLike)AoAItems.SILVER_COIN.get(), 10, 1, 2, new Consumer[0]).item((ItemLike)AoAItems.GOLD_COIN.get(), 3, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/lborean/aquatic_castle/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item((ItemLike)Items.f_42526_, 14, new Consumer[0]).item(AoAItems.SAILBACK, 10, new Consumer[0]).item(AoAItems.SAPPHIRE_STRIDER, 3, new Consumer[0]).item(AoAWeapons.BEAMER, 1, 1, new Consumer[0]).item(AoAWeapons.MK, 1, 1, new Consumer[0]).item(AoAItems.BUBBLE_BERRIES, 15, 1, 3, new Consumer[0]).item((ItemLike)Items.f_42447_, 5, new Consumer[0]).item(AoAItems.BUBBLE_BERRY_SEEDS, 7, 1, 3, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 2, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/barathos/baron_castle/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item(AoAWeapons.FIREFLY_STAFF, 1, 1, new Consumer[0]).item(AoAItems.HIVE_CHUNK, 4, new Consumer[0]).item(AoABlocks.BARON_GLASS, 10, 1, 11, new Consumer[0]).item(AoABlocks.BARON_GROUND, 10, 4, 16, new Consumer[0]).item(AoAItems.BLAZIUM_INGOT, 7, 1, 3, new Consumer[0]).item(AoAItems.BARONYTE_INGOT, 7, 1, 3, new Consumer[0]).item(AoAItems.VARSIUM_INGOT, 7, 1, 3, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 2, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/gardencia/floro_castle/main").forChests().pools(new LootPoolBuilder("main").rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).tag((TagKey<Item>)ItemTags.f_13145_, 30, 1, 6, new Consumer[0]).item((ItemLike)Blocks.f_50360_, 26, 1, 4, new Consumer[0]).item((ItemLike)Items.f_42732_, 24, 8, 29, new Consumer[0]).item((ItemLike)Items.f_42619_, 24, 11, 31, new Consumer[0]).item((ItemLike)Items.f_42677_, 14, 1, 2, new Consumer[0]).item((ItemLike)Blocks.f_50186_, 24, 2, 11, new Consumer[0]).item((ItemLike)Blocks.f_50133_, 24, 2, 11, new Consumer[0]).item((ItemLike)Items.f_42616_, 7, 1, 3, new Consumer[0]).item(AoAWeapons.ROSIDIAN_GREATBLADE, 1, new Consumer[0]).item((ItemLike)Blocks.f_50335_, 20, 2, 10, new Consumer[0]).item((ItemLike)AoAItems.NATURE_MELON_SLICE.get(), 23, 1, 3, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 2, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/gardencia/garden_castle/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item((ItemLike)Blocks.f_50112_, 30, 1, 6, new Consumer[0]).item((ItemLike)Blocks.f_50111_, 30, 1, 6, new Consumer[0]).item((ItemLike)Blocks.f_50360_, 26, 1, 4, new Consumer[0]).item((ItemLike)Items.f_42732_, 24, 8, 29, new Consumer[0]).item((ItemLike)Items.f_42619_, 24, 11, 31, new Consumer[0]).item((ItemLike)Items.f_42677_, 14, 1, 2, new Consumer[0]).item((ItemLike)Blocks.f_50186_, 24, 2, 11, new Consumer[0]).item((ItemLike)Blocks.f_50133_, 24, 2, 11, new Consumer[0]).item((ItemLike)Items.f_42616_, 7, 1, 3, new Consumer[0]).item(AoAWeapons.ROSIDIAN_CROSSBOW, 4, new Consumer[0]).item((ItemLike)Blocks.f_50335_, 20, 2, 10, new Consumer[0]).item(AoAItems.NATURE_MELON_SLICE, 23, 1, 3, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 2, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/candyland/gingerbread_house/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item((ItemLike)Items.f_42415_, 10, 1, 4, new Consumer[0]).item((ItemLike)Items.f_42436_, 6, new Consumer[0]).item(AoAItems.GOLD_COIN, 5, new Consumer[0]).item(AoAItems.COPPER_COIN, 17, 1, 10, new Consumer[0]).item(AoAItems.SILVER_COIN, 10, 1, 3, new Consumer[0]).item(AoAWeapons.CANDY_BLADE, 3, new Consumer[0]).item((ItemLike)Items.f_42572_, 15, 1, 3, new Consumer[0]).item((ItemLike)Items.f_42502_, 6, new Consumer[0]).item((ItemLike)Items.f_42501_, 16, 4, 17, new Consumer[0]).item((ItemLike)Items.f_42455_, 8, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/haven/guardian_tower/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item(AoAItems.CRYSTALLITE, 8, 2, 6, new Consumer[0]).item(AoAItems.HALYCON_MILK, 13, new Consumer[0]).item((ItemLike)Items.f_42525_, 11, 4, 16, new Consumer[0]).item((ItemLike)Items.f_42415_, 10, 1, 4, new Consumer[0]).item((ItemLike)Items.f_42436_, 6, new Consumer[0]).item(AoAItems.GOLD_COIN, 5, new Consumer[0]).item(AoAItems.VOLIANT_HEART, 2, new Consumer[0]).item(AoAItems.COPPER_COIN, 17, 1, 10, new Consumer[0]).item(AoAItems.SILVER_COIN, 12, 1, 3, new Consumer[0]).item(AoAItems.FLOATING_STONE, 10, 1, 2, new Consumer[0]).item((ItemLike)Items.f_42451_, 15, 3, 8, new Consumer[0]).item(AoABlocks.HAVEN_GRASS_PLANT, 18, 1, 3, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 2, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/iromine/iro_passage/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item(AoABlocks.IRO_GRASS, 35, new Consumer[0]).item(AoAItems.COPPER_COIN, 25, 1, 8, new Consumer[0]).item(AoAItems.SILVER_COIN, 20, 1, 4, new Consumer[0]).item(AoAItems.GOLD_COIN, 10, new Consumer[0]).item(AoAItems.MAGNET_SHARD, 9, new Consumer[0]).item(AoABlocks.IRO_CRATE, 8, new Consumer[0]).item(AoAItems.GOLD_SPRING, 8, new Consumer[0]).item(AoAWeapons.LYONIC_GREATBLADE, 2, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/lelyetia/lelyetian_tower/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item(AoAWeapons.MINIGUN, 1, new Consumer[0]).item(AoAItems.YELLOW_SPORES, 5, new Consumer[0]).item(AoAItems.ORANGE_SPORES, 5, new Consumer[0]).item(AoABlocks.ACHONY_LOG, 7, 2, 7, new Consumer[0]).item(AoABlocks.CHURRY_LOG, 7, 2, 7, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 2, 1, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/shyrelands/ruined_house/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoAItems.SHYREGEM, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_INGOT, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_NUGGET, 20, 2, 6, new Consumer[0]).item(AoABlocks.WHITE_SHYRE_BRICKS, 50, 1, 45, new Consumer[0]).item(AoABlocks.YELLOW_SHYRE_BRICKS, 50, 1, 45, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 5, 1, 2, new Consumer[0]).item((ItemLike)Blocks.f_50323_, 27, new Consumer[0]).item(AoABlocks.SHYRE_LOG, 35, 2, 35, new Consumer[0]).item(AoAItems.ANCIENT_UPGRADE_KIT, 1, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/shyrelands/shyre_shelter/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoAItems.SHYREGEM, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_INGOT, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_NUGGET, 20, 2, 6, new Consumer[0]).item(AoABlocks.WHITE_SHYRE_BRICKS, 50, 1, 45, new Consumer[0]).item(AoABlocks.YELLOW_SHYRE_BRICKS, 50, 1, 45, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 5, 1, 2, new Consumer[0]).item((ItemLike)Items.f_42390_, 27, entry -> entry.withRandomEnchants(Enchantments.f_44987_, Enchantments.f_44985_, Enchantments.f_44984_, Enchantments.f_44986_)).item(AoABlocks.SHYRE_LOG, 35, 2, 35, new Consumer[0]).item(AoAItems.ANCIENT_UPGRADE_KIT, 1, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/shyrelands/luxocron_dungeon/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoAItems.SHYREGEM, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_INGOT, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_NUGGET, 20, 2, 6, new Consumer[0]).item((ItemLike)Items.f_42616_, 15, 1, 3, new Consumer[0]).item((ItemLike)Items.f_42415_, 20, 1, 5, new Consumer[0]).item((ItemLike)Items.f_42436_, 8, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 5, 1, 2, new Consumer[0]).item(AoABlocks.SHYRE_LOG, 35, 2, 35, new Consumer[0]).item(AoAItems.ANCIENT_UPGRADE_KIT, 1, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/shyrelands/shyre_mausoleum/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoAItems.SHYREGEM, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_INGOT, 10, 1, 2, new Consumer[0]).item(AoAItems.SHYRESTONE_NUGGET, 20, 2, 6, new Consumer[0]).item(AoABlocks.WHITE_SHYRE_BRICKS, 50, 1, 45, new Consumer[0]).item(AoABlocks.YELLOW_SHYRE_BRICKS, 50, 1, 45, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 5, 1, 2, new Consumer[0]).item((ItemLike)Items.f_42500_, 27, 3, 15, new Consumer[0]).item((ItemLike)Items.f_42616_, 13, 1, 3, new Consumer[0]).item(AoAItems.SCRAP_METAL, 36, 1, 5, new Consumer[0]).item(AoABlocks.SHYRE_LOG, 35, 2, 35, new Consumer[0]).item(AoAItems.ANCIENT_UPGRADE_KIT, 1, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/lunalus/zal_prison_camp/main").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(100, -1, new Consumer[0]).item(AoAItems.LUNAR_INGOT, 5, 1, 2, new Consumer[0]).item((ItemLike)Blocks.f_50081_, 30, 3, 24, new Consumer[0]).item((ItemLike)Blocks.f_49997_, 20, 2, 16, new Consumer[0]).item((ItemLike)Blocks.f_49995_, 12, 1, 8, new Consumer[0]).item(AoAWeapons.SLINGSHOT, 1, new Consumer[0]).item(AoAItems.POP_SHOT, 3, 6, 20, new Consumer[0]).item(AoAItems.LUNALONS, 14, 2, 10, new Consumer[0]).item((ItemLike)Items.f_42385_, 17, new Consumer[0]).item((ItemLike)Items.f_42390_, 2, new Consumer[0]).item((ItemLike)Items.f_42395_, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/lunalus/zal_ship/fridge").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item((ItemLike)Items.f_42502_, 5, new Consumer[0]).item((ItemLike)Items.f_42455_, 10, new Consumer[0]).item((ItemLike)Items.f_42580_, 12, 2, 8, new Consumer[0]).item((ItemLike)Items.f_42486_, 12, 2, 8, new Consumer[0]).item((ItemLike)Items.f_42528_, 30, 1, 3, new Consumer[0]).item((ItemLike)Items.f_42572_, 20, 1, 14, new Consumer[0]).item(AoAItems.CANDLEFISH, 15, 1, 3, new Consumer[0]).item(AoAItems.IRONBACK, 8, 1, 3, new Consumer[0]).item(AoAItems.RAW_CHARGER_SHANK, 5, 1, 4, new Consumer[0]).item((ItemLike)Items.f_42436_, 2, new Consumer[0]).item((ItemLike)Items.f_42437_, 1, new Consumer[0]).item(AoAItems.LUNAR_INGOT, 1, 1, 3, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/lunalus/zal_ship/ore_processing").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(300, -3, new Consumer[0]).item((ItemLike)Items.f_42413_, 75, 3, 20, new Consumer[0]).item((ItemLike)Items.f_41835_, 70, 1, 10, new Consumer[0]).item((ItemLike)Items.f_41834_, 35, 1, 10, new Consumer[0]).item((ItemLike)Items.f_42749_, 45, 8, 40, new Consumer[0]).item((ItemLike)Items.f_42534_, 25, 6, 35, new Consumer[0]).item((ItemLike)Items.f_41853_, 20, 1, 10, new Consumer[0]).item((ItemLike)Items.f_42415_, 10, 1, 2, 12, new Consumer[0]).item((ItemLike)Items.f_42010_, 5, 1, 1, 10, new Consumer[0]).item((ItemLike)Items.f_42616_, 5, 2, 1, 8, new Consumer[0]).item((ItemLike)Items.f_42107_, 3, 2, 1, 5, new Consumer[0]).item((ItemLike)Items.f_151049_, 18, 2, 8, new Consumer[0]).item((ItemLike)Items.f_42587_, 30, 7, 35, new Consumer[0]).item((ItemLike)Items.f_42417_, 20, 5, 20, new Consumer[0]).item((ItemLike)Items.f_41833_, 15, 1, 10, new Consumer[0]).item(AoAItems.SCRAP_METAL, 60, -2, 4, 10, new Consumer[0]).item(AoAItems.LUNAR_INGOT, 70, 1, 5, 30, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/lunalus/zal_ship/storage").forChests().pools(new LootPoolBuilder().rolls(10).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoABlocks.LUNIDE_LOG, 50, 6, 20, new Consumer[0]).item(AoABlocks.STRIPPED_LUNIDE_LOG, 30, 3, 15, new Consumer[0]).item(AoABlocks.LUNIDE_WOOD, 50, 6, 20, new Consumer[0]).item(AoABlocks.STRIPPED_LUNIDE_WOOD, 30, 3, 15, new Consumer[0]).item(AoAItems.LUNAR_INGOT, 45, 1, 5, 10, new Consumer[0]).item((ItemLike)Items.f_42499_, 45, 10, 40, new Consumer[0]).item(AoAItems.LUNA_GLOBE_SEEDS, 30, 3, 9, new Consumer[0]).item(AoAItems.LUNALON_SEEDS, 30, 3, 9, new Consumer[0]).item(AoAItems.LUNACRIKE_SEEDS, 30, 3, 9, new Consumer[0]).item(AoAItems.IVORY, 36, 5, 10, new Consumer[0]).item(AoAItems.ARMOUR_PLATING, 20, 1, 5, new Consumer[0]).item(AoAItems.OBSERVING_EYE, 5, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 10, 2, 4, new Consumer[0]).item(AoAItems.CUP, 30, new Consumer[0]).item(AoAItems.GOLD_COIN, 3, new Consumer[0]).item(AoAItems.SILVER_COIN, 15, 1, 4, new Consumer[0]).item((ItemLike)Items.f_41826_, 35, 1, 6, new Consumer[0]).item((ItemLike)Items.f_42799_, 35, 1, 6, new Consumer[0]).item((ItemLike)Items.f_42800_, 35, 1, 6, new Consumer[0]).item(AoAWeapons.LUNAR_GREATBLADE, 1, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/greckon/haunted_dungeon/study").forChests().pools(new LootPoolBuilder().rolls(7, 12).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item((ItemLike)Items.f_42517_, 30, 1, 5, new Consumer[0]).item((ItemLike)Items.f_42532_, 25, 1, 4, new Consumer[0]).item((ItemLike)Items.f_42614_, 20, 1, 1, new Consumer[0]).item((ItemLike)Items.f_42406_, 40, 2, 8, new Consumer[0]).item((ItemLike)Items.f_42402_, 45, -1, 3, 9, new Consumer[0]).item((ItemLike)Items.f_42572_, 23, 6, 13, new Consumer[0]).item((ItemLike)Items.f_41863_, 17, 1, 6, new Consumer[0]).item((ItemLike)Items.f_42752_, 2, 1, 1, 1, new Consumer[0]).item((ItemLike)Items.f_42587_, 10, 1, 1, 7, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/greckon/haunted_dungeon/ritual").forChests().pools(new LootPoolBuilder().rolls(7, 12).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoAItems.HAUNTED_IDOL, 1, 1, 1, 1, new Consumer[0]).item(AoABlocks.HAUNTED_EYE_LOG, 30, 1, 3, new Consumer[0]).item(AoABlocks.HAUNTED_FLOWER, 40, -1, 2, 6, new Consumer[0]).item(AoABlocks.HAUNTED_PURPLING_LOG, 30, 1, 3, new Consumer[0]).item(AoAItems.GHASTLY_NUGGET, 20, 1, 1, 7, new Consumer[0]).item(AoAItems.GHOULISH_NUGGET, 20, 1, 1, 7, new Consumer[0]).item((ItemLike)Items.f_41863_, 25, 1, 3, new Consumer[0]).item((ItemLike)Items.f_42448_, 25, 1, 1, new Consumer[0]).item((ItemLike)Items.f_42419_, 15, 1, 1, 5, new Consumer[0]).item((ItemLike)Items.f_42718_, 10, 1, 1, new Consumer[0]).item((ItemLike)Items.f_42648_, 20, 1, 2, new Consumer[0]).item((ItemLike)Items.f_42656_, 20, 1, 2, new Consumer[0]).item((ItemLike)Items.f_42692_, 20, 2, 6, new Consumer[0]).item((ItemLike)Items.f_42681_, 10, 1, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/greckon/haunted_dungeon/craft").forChests().pools(new LootPoolBuilder().rolls(7, 12).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoAItems.SCRAP_METAL, 48, -1, 3, 10, new Consumer[0]).item(AoABlocks.HAUNTEDWOOD_PLANKS, 49, -1, 4, 14, new Consumer[0]).item((ItemLike)Items.f_42398_, 50, -1, 5, 15, new Consumer[0]).item((ItemLike)Items.f_42454_, 40, 2, 7, new Consumer[0]).item((ItemLike)Items.f_42416_, 30, 3, 8, new Consumer[0]).item((ItemLike)Items.f_42417_, 25, 2, 6, new Consumer[0]).item(AoAItems.JADE, 19, 1, 4, new Consumer[0]).item((ItemLike)Items.f_151049_, 23, 3, 6, new Consumer[0]).item((ItemLike)Items.f_42415_, 15, 1, 6, new Consumer[0]).item(AoAItems.GHOULISH_INGOT, 13, 1, 1, 5, new Consumer[0]).item(AoAItems.GHASTLY_INGOT, 13, 1, 1, 5, new Consumer[0]).item((ItemLike)Items.f_42714_, 8, 1, 1, new Consumer[0]).item((ItemLike)Items.f_42451_, 30, 5, 10, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("structures/greckon/haunted_dungeon/main").forChests().pools(new LootPoolBuilder().rolls(7, 12).bonusLuckRolls(-1, 1).empty(300, -2, new Consumer[0]).item(AoAWeapons.HAUNTED_GREATBLADE, 1, 1, new Consumer[0]).item(AoAItems.GHOULISH_INGOT, 20, 1, 5, new Consumer[0]).item(AoAItems.GHASTLY_INGOT, 20, 1, 5, new Consumer[0]).item(AoAItems.COPPER_COIN, 50, 5, 12, new Consumer[0]).item(AoAItems.SILVER_COIN, 35, 2, 6, new Consumer[0]).item(AoAItems.GOLD_COIN, 10, 1, new Consumer[0]).item(AoAItems.MAGIC_REPAIR_DUST, 3, 1, 1, 2, new Consumer[0]).item((ItemLike)Items.f_42583_, 50, 4, 10, new Consumer[0]).item((ItemLike)Items.f_42591_, 50, 2, 7, new Consumer[0]).item((ItemLike)Items.f_42675_, 40, 1, 3, new Consumer[0]).item((ItemLike)Items.f_41863_, 50, 2, 4, new Consumer[0])).finalize(lootTables);
    }

    private static void createWorldTables(HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder("worlds/abyss").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.NIGHTMARE_FLAKES, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.ABYSSAL_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/barathos").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(200, new Consumer[0]).item(AoAItems.PREDATOR_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/candyland").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(181, new Consumer[0]).item(AoAItems.SOUR_GUMMY, 20, entry -> entry.lootingBonus(0, 1))).finalize(lootTables);
        new LootTableBuilder("worlds/celeve").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(230, new Consumer[0]).item(AoAItems.CIRCUS_COIN, 70, 2, 5, entry -> entry.lootingBonus(-1, 2)).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.CONFETTI_PILE, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.CLOWN_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/creeponia").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(181, new Consumer[0]).item(AoAItems.UNSTABLE_GUNPOWDER, 20, entry -> entry.lootingBonus(0, 1))).finalize(lootTables);
        new LootTableBuilder("worlds/crystevia").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2))).finalize(lootTables);
        new LootTableBuilder("worlds/deeplands").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.DENSE_ROCK, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.ROCKY_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/dustopia").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.DARKLY_POWDER, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.DARKLY_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/gardencia").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(265, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)).item(AoAItems.CHILLI_SEEDS, 20, 1, 3, new Consumer[0]).item(AoAItems.NATURE_MELON_SLICE, 15, 1, 2, new Consumer[0]), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.ROSID_ROOT, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.FLORO_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/greckon").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.GHOULASM, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.HAUNTED_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/haven").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(270, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)).item(AoAItems.VOLIANT_HEART, 30, new Consumer[0]), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.FLOATING_STONE, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.LIGHT_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/haven_passive").forGift().pools(new LootPoolBuilder("suppies").empty(285, -1, new Consumer[0]).item(AoAItems.COPPER_COIN, 20, 2, 5, new Consumer[0]).item(AoAItems.FLOATING_STONE, 10, 5, 1, 3, new Consumer[0]).item(AoAItems.VOLIANT_HEART, 2, 3, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/iromine").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(181, new Consumer[0]).item(AoAItems.MAGNET_SHARD, 20, entry -> entry.lootingBonus(0, 1))).finalize(lootTables);
        new LootTableBuilder("worlds/lborean").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(285, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)).item(AoAItems.BUBBLE_BERRY_SEEDS, 10, new Consumer[0]), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.CORAL_STONE, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.SEASIDE_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/lelyetia").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.YELLOW_SPORES, 10, entry -> entry.lootingBonus(0, 1)).item(AoAItems.ORANGE_SPORES, 10, entry -> entry.lootingBonus(0, 1)).item(AoAItems.LELYETIAN_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/lunalus").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.ORBULON, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.LUNAR_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/mysterium").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(298, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)).item(AoAItems.MYSTIC_SHROOMS, 2, new Consumer[0]), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.MUSHROOM_SPORES, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.FUNGAL_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/nether").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.FLAMMABLE_DUST, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.NETHER_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/overworld").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(250, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)).item(AoAItems.SCRAP_METAL, 15, entry -> entry.lootingBonus(0, 1)).item(AoAItems.TEA_SEEDS, 5, new Consumer[0]).item((ItemLike)Items.f_42749_, 11, new Consumer[0]).item((ItemLike)Items.f_42500_, 12, new Consumer[0]).item((ItemLike)Items.f_42413_, 9, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_DIRECTION, 2, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_REALITY, 2, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_SPACE, 2, new Consumer[0]).item(AoABlocks.CARVED_RUNE_OF_TRAVEL, 2, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/precasia").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.JUNGLE_THORNS, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.PRECASIAN_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
        new LootTableBuilder("worlds/runandor").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(181, new Consumer[0]).item(AoAItems.RUNIC_ENERGY, 20, entry -> entry.lootingBonus(0, 1))).finalize(lootTables);
        new LootTableBuilder("worlds/shyrelands").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(181, new Consumer[0]).item(AoAItems.WHITEWASHING_SOLUTION, 20, entry -> entry.lootingBonus(0, 1))).finalize(lootTables);
        new LootTableBuilder("worlds/vox_ponds").forEntities().pools(new LootPoolBuilder("rare_table").empty(200, new Consumer[0]).table("misc/rare_table", 1, new Consumer[0]), new LootPoolBuilder("supplies").rolls(1, 3).empty(300, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 1, 3, entry -> entry.lootingBonus(-1, 2)), new LootPoolBuilder("dimension_specific_loot").empty(180, new Consumer[0]).item(AoAItems.TOXIC_LUMP, 20, entry -> entry.lootingBonus(0, 1)).item(AoAItems.APOCO_UPGRADE_KIT, 1, new Consumer[0])).finalize(lootTables);
    }

    @Override
    protected void addLootTables(HashMap<ResourceLocation, LootTable> lootTables) {
        DataGenMiscLootTables.createEntityTables(lootTables);
        DataGenMiscLootTables.createMiscTables(lootTables);
        DataGenMiscLootTables.createItemTables(lootTables);
        DataGenMiscLootTables.createStructureTables(lootTables);
        DataGenMiscLootTables.createWorldTables(lootTables);
    }
}

