/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.loot;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.content.block.functional.misc.TrophyBlock;
import net.tslat.aoa3.content.loottable.condition.HoldingItem;
import net.tslat.aoa3.content.loottable.condition.PlayerHasLevel;
import net.tslat.aoa3.content.loottable.condition.PlayerHasResource;
import net.tslat.aoa3.content.loottable.function.GrantSkillXp;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import org.apache.logging.log4j.Level;

public abstract class DataGenLootTables
implements DataProvider {
    private final DataGenerator generator;
    private final HashMap<ResourceLocation, LootTable> lootTables = new HashMap();

    public DataGenLootTables(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) {
        this.addLootTables(this.lootTables);
        Path outputFolder = this.generator.m_123916_();
        for (Map.Entry<ResourceLocation, LootTable> table : this.lootTables.entrySet()) {
            Path tablePath = outputFolder.resolve("data/" + table.getKey().m_135827_() + "/loot_tables/" + table.getKey().m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)table.getValue()), (Path)tablePath);
            }
            catch (IOException ex) {
                Logging.logMessage(Level.ERROR, "Unable to write loot table: " + table.getKey().toString(), ex);
            }
        }
    }

    protected abstract void addLootTables(HashMap<ResourceLocation, LootTable> var1);

    public static class CompactLootTableBuilder {
        private final ResourceLocation id;
        private final LootTable.Builder builder;
        private final HashMap<String, LootPool.Builder> poolMap = new HashMap();

        protected CompactLootTableBuilder(String path) {
            this.id = new ResourceLocation("aoa3", path);
            this.builder = new LootTable.Builder();
        }

        protected CompactLootTableBuilder(String subPath, ResourceLocation objectId) {
            this.id = new ResourceLocation(objectId.m_135827_(), subPath + "/" + objectId.m_135815_());
            this.builder = new LootTable.Builder();
        }

        protected CompactLootTableBuilder(String subPath, ResourceLocation objectId, String parent) {
            this.id = new ResourceLocation(objectId.m_135827_(), subPath + "/" + objectId.m_135815_());
            this.builder = new LootTable.Builder();
            this.poolMap.put("parent_table", new LootPool.Builder().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("aoa3", parent))));
        }

        protected CompactLootTableBuilder addLoot(String pool, LootPoolEntryContainer.Builder<?> entry) {
            return this.addLoot(pool, new LootPoolEntryContainer.Builder[]{entry});
        }

        protected CompactLootTableBuilder rolls(String pool, int rolls) {
            LootPool.Builder poolEntry = this.getPool(pool);
            poolEntry.m_165133_((NumberProvider)ConstantValue.m_165692_((float)rolls));
            return this;
        }

        protected CompactLootTableBuilder rolls(String pool, int minRolls, int maxRolls) {
            LootPool.Builder poolEntry = this.getPool(pool);
            poolEntry.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)minRolls, (float)maxRolls));
            return this;
        }

        protected CompactLootTableBuilder bonusRolls(String pool, int bonusRolls) {
            return this.bonusRolls(pool, bonusRolls, bonusRolls);
        }

        protected CompactLootTableBuilder bonusRolls(String pool, int minRolls, int maxRolls) {
            LootPool.Builder poolEntry = this.getPool(pool);
            poolEntry.m_165135_((NumberProvider)UniformGenerator.m_165780_((float)minRolls, (float)maxRolls));
            return this;
        }

        protected CompactLootTableBuilder addLoot(String pool, LootPoolEntryContainer.Builder<?> ... entries) {
            LootPool.Builder poolEntry = this.getPool(pool);
            for (LootPoolEntryContainer.Builder<?> entry : entries) {
                poolEntry.m_79076_(entry);
            }
            return this;
        }

        protected CompactLootTableBuilder conditions(String string, LootItemCondition.Builder ... conditions) {
            LootPool.Builder pool = this.getPool(string);
            for (LootItemCondition.Builder condition : conditions) {
                pool.m_79080_(condition);
            }
            return this;
        }

        protected static LootPoolSingletonContainer.Builder<?> lootTable(ResourceLocation table, int weight) {
            return LootTableReference.m_79776_((ResourceLocation)table).m_79707_(weight);
        }

        protected static LootPoolSingletonContainer.Builder<?> item(ItemLike item, int weight, int quality, LootItemConditionalFunction.Builder<?> ... functions) {
            LootPoolSingletonContainer.Builder builder = LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79711_(quality);
            for (LootItemConditionalFunction.Builder<?> function : functions) {
                builder.m_79078_(function);
            }
            return builder;
        }

        protected static LootPoolSingletonContainer.Builder<?> item(ItemLike item, int weight, LootItemConditionalFunction.Builder<?> ... functions) {
            return CompactLootTableBuilder.item(item, weight, 0, functions);
        }

        protected static LootPoolSingletonContainer.Builder<?> item(ItemLike item) {
            return CompactLootTableBuilder.item(item, 1, 0);
        }

        protected static LootPoolSingletonContainer.Builder<?> item(ItemLike item, int weight) {
            return CompactLootTableBuilder.item(item, weight, 0);
        }

        protected static LootPoolSingletonContainer.Builder<?> item(ItemLike item, int weight, int quality) {
            return CompactLootTableBuilder.item(item, weight, quality, new LootItemConditionalFunction.Builder[0]);
        }

        protected static LootPoolSingletonContainer.Builder<?> empty(int weight) {
            return EmptyLootItem.m_79533_().m_79707_(weight);
        }

        protected static LootPoolSingletonContainer.Builder<?> trophy(EntityType<?> entity, Block trophyBlock, int weight) {
            return LootItem.m_79579_((ItemLike)trophyBlock).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)TrophyBlock.getOriginalTrophyTag(entity, trophyBlock))).m_79707_(weight);
        }

        private LootPool.Builder getPool(String pool) {
            if (this.poolMap.containsKey(pool)) {
                return this.poolMap.get(pool);
            }
            LootPool.Builder newPool = new LootPool.Builder().name(pool);
            newPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            this.poolMap.put(pool, newPool);
            return newPool;
        }

        protected static LootItemConditionalFunction.Builder<?> enchant(EnchantmentInstance ... enchantments) {
            SetEnchantmentsFunction.Builder builder = new SetEnchantmentsFunction.Builder();
            for (EnchantmentInstance enchant : enchantments) {
                builder.m_165374_(enchant.f_44947_, (NumberProvider)ConstantValue.m_165692_((float)enchant.f_44948_));
            }
            return builder;
        }

        protected static LootItemConditionalFunction.Builder<?> nbt(CompoundTag nbt) {
            return SetNbtFunction.m_81187_((CompoundTag)nbt);
        }

        protected static LootItemConditionalFunction.Builder<?> grantSkillXp(AoASkill skill, float amount) {
            return GrantSkillXp.builder(skill, amount);
        }

        protected static LootItemCondition.Builder levelReq(AoASkill skill, int level) {
            return () -> new PlayerHasLevel(skill, level);
        }

        protected static LootItemCondition.Builder resourceReq(AoAResource resource, float amount) {
            return CompactLootTableBuilder.resourceReq(resource, amount, false);
        }

        protected static LootItemCondition.Builder resourceReq(AoAResource resource, float amount, boolean consume) {
            return () -> new PlayerHasResource(resource, amount, consume);
        }

        protected static LootItemCondition.Builder holdingItem(Item item, LootContext.EntityTarget holder) {
            return CompactLootTableBuilder.holdingItem(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), holder, null);
        }

        protected static LootItemCondition.Builder holdingItem(ItemPredicate itemPredicate, LootContext.EntityTarget relevantEntity, @Nullable InteractionHand hand) {
            return () -> new HoldingItem(relevantEntity, itemPredicate, hand);
        }

        protected static LootItemCondition.Builder killedByPlayer() {
            return LootItemKilledByPlayerCondition.m_81901_();
        }

        protected static LootItemConditionalFunction.Builder<LootingEnchantFunction.Builder> looting(int min, int max) {
            return new LootingEnchantFunction.Builder((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
        }

        protected static LootItemConditionalFunction.Builder<?> count(int min, int max) {
            return SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
        }

        protected static LootItemConditionalFunction.Builder<?> count(int count) {
            return SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count));
        }

        protected LootContextParamSet getParameters() {
            return LootContextParamSets.f_81420_;
        }

        protected void finalise(HashMap<ResourceLocation, LootTable> lootTables) {
            for (LootPool.Builder pool : this.poolMap.values()) {
                this.builder.m_79161_(pool);
            }
            lootTables.put(this.id, this.builder.m_79165_(this.poolMap.isEmpty() ? LootContextParamSets.f_81410_ : this.getParameters()).m_79167_());
        }
    }
}

