/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.loot;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.DataGenBlocks;
import net.tslat.aoa3.advent.datagen.builder.loot.LootEntryBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootPoolBuilder;
import net.tslat.aoa3.advent.datagen.builder.loot.LootTableBuilder;
import net.tslat.aoa3.advent.datagen.loot.DataGenLootTables;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.block.generation.grass.GrassBlock;
import net.tslat.aoa3.content.block.generation.leaves.LeavesBlock;

public final class DataGenBlockLootTables
extends DataGenLootTables {
    public DataGenBlockLootTables(DataGenerator generator) {
        super(generator);
    }

    public String m_6055_() {
        return "Loot Tables - Blocks";
    }

    @Override
    protected void addLootTables(HashMap<ResourceLocation, LootTable> lootTables) {
        for (DataGenBlockPackage blockPackage : DataGenBlocks.BLOCKS) {
            if (blockPackage.getDropsType() == null) {
                ((BiConsumer)((Function)blockPackage.getLinkedObject("loot_table_function")).apply(this)).accept(blockPackage, lootTables);
                continue;
            }
            switch (blockPackage.getDropsType()) {
                case NORMAL: {
                    this.generateNormalBlockLootTable(blockPackage, lootTables);
                    break;
                }
                case SILK_TOUCH: {
                    this.generateSilkTouchBlockLootTable(blockPackage, lootTables);
                    break;
                }
                case GRASS: {
                    this.generateGrassBlockLootTable(blockPackage, lootTables);
                    break;
                }
                case LEAVES: {
                    this.generateLeafBlockLootTable(blockPackage, lootTables);
                    break;
                }
                case SHEARS: {
                    this.generateShearedBlockLootTable(blockPackage, lootTables);
                    break;
                }
                case ORE: {
                    this.generateOreBlockLootTable(blockPackage, lootTables);
                    break;
                }
                case SLAB: {
                    this.generateSlabBlockLootTable(blockPackage, lootTables);
                    break;
                }
                case POTTED_PLANT: {
                    this.generatePottedPlantBlockLootTable(blockPackage, lootTables);
                    break;
                }
            }
        }
    }

    private void generateNormalBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().item((ItemLike)blockPackage.getItem(), 1, LootEntryBuilder::ifSurvivesExplosion)).finalize(lootTables);
    }

    private void generateSilkTouchBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().ifHasSilkTouch().item((ItemLike)blockPackage.getItem(), 1, new Consumer[0])).finalize(lootTables);
    }

    private void generateGrassBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)blockPackage.getItem(), 1).ifHasSilkTouch(), new LootEntryBuilder((ItemLike)((GrassBlock)blockPackage.getBlock()).getSoilBlock().get(), 1).ifSurvivesExplosion())).finalize(lootTables);
    }

    private void generateShearedBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().onlyWhenAny(LootEntryBuilder.matchItem((TagKey<Item>)Tags.Items.SHEARS), LootEntryBuilder.hasEnchant(Enchantments.f_44985_)).item((ItemLike)blockPackage.getItem(), 1, new Consumer[0])).finalize(lootTables);
    }

    private void generateOreBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        LootTableBuilder builder = new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks();
        if (blockPackage.hasLinkedObject("mineral")) {
            builder.pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)blockPackage.getItem(), 1).ifHasSilkTouch(), new LootEntryBuilder((ItemLike)((Supplier)blockPackage.getLinkedObject("mineral")).get(), 1).fortuneOreBonuses().checkExplosionDecay())).finalize(lootTables);
        } else {
            builder.pools(new LootPoolBuilder().ifSurvivesExplosion().item((ItemLike)blockPackage.getItem(), 1, new Consumer[0])).finalize(lootTables);
        }
    }

    private void generatePottedPlantBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().item((ItemLike)Items.f_42618_, 1, new Consumer[0]), new LootPoolBuilder().ifSurvivesExplosion().item((ItemLike)((FlowerPotBlock)blockPackage.getBlock()).m_53560_(), 1, new Consumer[0])).finalize(lootTables);
    }

    private void generateSlabBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().checkExplosionDecay().andDo(new LootItemFunction.Builder[]{SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)blockPackage.getBlock()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))}).item((ItemLike)blockPackage.getItem(), 1, new Consumer[0])).finalize(lootTables);
    }

    private void generateLeafBlockLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        float fortuneMod;
        LootTableBuilder builder = new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks();
        LeavesBlock leafBlock = (LeavesBlock)blockPackage.getBlock();
        if (blockPackage.hasLinkedObject("sapling")) {
            float saplingChance = leafBlock.getSaplingDropChance();
            fortuneMod = saplingChance * 0.25f;
            builder.pools(new LootPoolBuilder().firstSuccessfulEntry(new LootPoolEntryContainer.Builder[]{new LootEntryBuilder((ItemLike)blockPackage.getItem(), 1).onlyWhenAny(LootEntryBuilder.matchItem((TagKey<Item>)Tags.Items.SHEARS), LootEntryBuilder.hasEnchant(Enchantments.f_44985_)).build(), new LootEntryBuilder((ItemLike)((RegistryObject)blockPackage.getLinkedObject("sapling")).get(), 1).ifSurvivesExplosion().ifMeetsEnchantmentBasedChance(Enchantments.f_44987_, saplingChance, saplingChance + fortuneMod, saplingChance + fortuneMod * 2.0f, saplingChance + fortuneMod * 3.0f).build()}));
        } else {
            builder.pools(new LootPoolBuilder().item((ItemLike)blockPackage.getItem(), 1, entry -> entry.onlyWhenAny(LootEntryBuilder.matchItem((TagKey<Item>)Tags.Items.SHEARS), LootEntryBuilder.hasEnchant(Enchantments.f_44985_))));
        }
        float stickChance = leafBlock.getSaplingDropChance() * 0.4f;
        fortuneMod = stickChance * 0.15f;
        builder.pools(new LootPoolBuilder().onlyWhenNot(LootEntryBuilder.anyCondition(LootEntryBuilder.matchItem((TagKey<Item>)Tags.Items.SHEARS), LootEntryBuilder.hasEnchant(Enchantments.f_44985_))).item((ItemLike)Items.f_42398_, 1, entry -> entry.ifMeetsEnchantmentBasedChance(Enchantments.f_44987_, stickChance, stickChance + fortuneMod, stickChance + fortuneMod * 2.0f, stickChance + fortuneMod * 3.0f).setCount(1, 2).checkExplosionDecay().build())).finalize(lootTables);
    }

    public static ResourceLocation tablePath(DataGenBlockPackage blockPackage) {
        return new ResourceLocation("aoa3", "blocks/" + blockPackage.getRegistryName().m_135815_());
    }

    public void bubbleBerryCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.BUBBLE_BERRIES.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.BUBBLE_BERRY_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.BUBBLE_BERRY_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.BUBBLE_BERRY_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.BUBBLE_BERRY_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void chilliCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.CHILLI.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.CHILLI_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.CHILLI_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.CHILLI_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.CHILLI_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void eyeBulbCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().item((ItemLike)AoAItems.EYE_BULB.get(), 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.EYE_BULB_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.EYE_BULB.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void floraclesCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.FLORACLE_STICKS.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.FLORACLES_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.FLORACLE_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.FLORACLES_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.FLORACLE_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void goldicapsCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.GOLDICAP_PETALS.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.GOLDICAPS_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.GOLDICAP_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.GOLDICAPS_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.GOLDICAP_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void heartFruitCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhenNot((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.HEART_FRUIT_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))).item((ItemLike)AoAItems.HEART_FRUIT_SEEDS.get(), 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.HEART_FRUIT_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.HEART_FRUIT.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)2)))).finalize(lootTables);
    }

    public void lunacrikeCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.LUNACRIKE.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.LUNACRIKE_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.LUNACRIKE_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.LUNACRIKE_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.LUNACRIKE_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void lunaGlobeCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.LUNA_GLOBE.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.LUNA_GLOBE_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.LUNA_GLOBE_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.LUNA_GLOBE_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.LUNA_GLOBE_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void lunalonCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.LUNALONS.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.LUNALON_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.LUNALON_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.LUNALON_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.LUNALON_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void magicMarangCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.MAGIC_MARANG_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.MAGIC_MARANG.get(), 1, new Consumer[0])).finalize(lootTables);
    }

    public void mysticShroomCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().item((ItemLike)AoAItems.MYSTIC_SHROOMS.get(), 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.MYSTIC_SHROOM_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.MYSTIC_SHROOMS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void rosidonCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.ROSIDONS.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.ROSIDON_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.ROSIDON_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.ROSIDON_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.ROSIDON_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void teaCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.TEA_SHREDDINGS.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.TEA_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.TEA_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.TEA_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.TEA_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void trilliadCropLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().firstSuccessfulEntry(new LootEntryBuilder((ItemLike)AoAItems.TRILLIAD_LEAVES.get(), 1).onlyWhen((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.TRILLIAD_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))), new LootEntryBuilder((ItemLike)AoAItems.TRILLIAD_SEEDS.get(), 1)), new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.TRILLIAD_CROP.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.TRILLIAD_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))).finalize(lootTables);
    }

    public void greenManureLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhen(new LootItemCondition.Builder[]{new LootItemBlockStatePropertyCondition.Builder((Block)AoABlocks.GREEN_MANURE.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))}).item((ItemLike)AoAItems.GREEN_MANURE_SEEDS.get(), 1, entry -> entry.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)4)))).finalize(lootTables);
    }

    public void tangleThornsLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).empty(19, new Consumer[0]).item(AoAItems.HEART_FRUIT_SEEDS, 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoABlocks.TANGLE_THORNS, 1, new Consumer[0])).finalize(lootTables);
    }

    public void trilliadBloomLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoAItems.TRILLIAD_SEEDS, 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoABlocks.TRILLIAD_BLOOM, 1, new Consumer[0])).finalize(lootTables);
    }

    public void redWaterweedsLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoAItems.FLORACLE_SEEDS, 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoABlocks.RED_WATERWEEDS, 1, new Consumer[0])).finalize(lootTables);
    }

    public void bulbStockCapLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoAItems.EYE_BULB, 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoABlocks.BULB_STOCK_CAP, 1, new Consumer[0])).finalize(lootTables);
    }

    public void crystalPlantLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).empty(49, new Consumer[0]).item((RegistryObject<? extends ItemLike>)((RegistryObject)blockPackage.getLinkedObject("druse")), 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item((ItemLike)blockPackage.getBlock(), 1, new Consumer[0])).finalize(lootTables);
    }

    public void redEyeTentacleLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().withExplosionDecay().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item((ItemLike)blockPackage.getItem(), 19, new Consumer[0]).item(AoAItems.STARING_EYE, 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoABlocks.TENTACLE_EYE_RED, 1, new Consumer[0])).finalize(lootTables);
    }

    public void iroCrateLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoAItems.INCOMPLETE_MECHANICAL_ASSAULT_RIFLE, 1, new Consumer[0]).item(AoAItems.INCOMPLETE_MECHA_BOW, 1, new Consumer[0]).item(AoAItems.INCOMPLETE_MECHYRO, 1, new Consumer[0]).item(AoAItems.INCOMPLETE_MECHA_CROSSBOW, 1, new Consumer[0]).item(AoAItems.INCOMPLETE_MECHA_CANNON, 1, new Consumer[0]).item(AoAItems.INCOMPLETE_MECHA_STAFF, 1, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item((ItemLike)blockPackage.getItem(), 1, new Consumer[0])).finalize(lootTables);
    }

    public void deepCaseLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().onlyWhenNot(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item(AoAItems.RUNIUM_CHUNK, 90, 5, 20, new Consumer[0]).item(AoAItems.CHARGED_RUNIUM_CHUNK, 80, 4, 16, new Consumer[0]).item(AoAItems.DENSE_ROCK, 50, 1, 2, new Consumer[0]).item(AoAItems.COPPER_COIN, 100, 8, 13, new Consumer[0]).item(AoAItems.SILVER_COIN, 70, 2, 4, new Consumer[0]).item(AoAItems.GOLD_COIN, 30, new Consumer[0]).item((ItemLike)Items.f_42413_, 65, 12, 25, new Consumer[0]).item(AoAItems.SMALL_SKILL_CRYSTAL, 40, 1, 5, new Consumer[0]).item(AoAItems.MEDIUM_SKILL_CRYSTAL, 25, 1, 3, new Consumer[0]).item(AoAWeapons.DEEP_BOW, 25, new Consumer[0]).item(AoAWeapons.ROCKER_RIFLE, 25, new Consumer[0]), new LootPoolBuilder().onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))).item((ItemLike)blockPackage.getItem(), 1, new Consumer[0])).finalize(lootTables);
    }

    public void kaiyuTempleTrapLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks().pools(new LootPoolBuilder().ifSurvivesExplosion().item((ItemLike)((RegistryObject)blockPackage.getLinkedObject("source_block")).get(), 1, new Consumer[0])).finalize(lootTables);
    }

    public void hauntedLeavesLootTable(DataGenBlockPackage blockPackage, HashMap<ResourceLocation, LootTable> lootTables) {
        float fortuneMod;
        LeavesBlock leafBlock = (LeavesBlock)blockPackage.getBlock();
        LootTableBuilder builder = new LootTableBuilder(DataGenBlockLootTables.tablePath(blockPackage)).forBlocks();
        if (blockPackage.hasLinkedObject("sapling")) {
            float saplingChance = leafBlock.getSaplingDropChance();
            fortuneMod = saplingChance * 0.25f;
            builder.pools(new LootPoolBuilder().firstSuccessfulEntry(new LootPoolEntryContainer.Builder[]{new LootEntryBuilder((ItemLike)blockPackage.getItem(), 1).onlyWhenAny(LootEntryBuilder.matchItem((TagKey<Item>)Tags.Items.SHEARS), LootEntryBuilder.hasEnchant(Enchantments.f_44985_)).build(), new LootEntryBuilder((ItemLike)((RegistryObject)blockPackage.getLinkedObject("sapling")).get(), 1).ifSurvivesExplosion().ifMeetsEnchantmentBasedChance(Enchantments.f_44987_, saplingChance, saplingChance + fortuneMod, saplingChance + fortuneMod * 2.0f, saplingChance + fortuneMod * 3.0f).build()}));
        }
        float stickChance = leafBlock.getSaplingDropChance() * 0.4f;
        fortuneMod = stickChance * 0.15f;
        builder.pools(new LootPoolBuilder().onlyWhen(InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)LootEntryBuilder.anyCondition(LootEntryBuilder.matchItem((TagKey<Item>)Tags.Items.SHEARS), LootEntryBuilder.hasEnchant(Enchantments.f_44985_))), BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{stickChance, stickChance + fortuneMod, stickChance + fortuneMod * 2.0f, stickChance + fortuneMod * 3.0f})).checkExplosionDecay().item((ItemLike)Items.f_42398_, 50, 1, 2, LootEntryBuilder::checkExplosionDecay)).finalize(lootTables);
    }

    public static enum BlockDropType {
        NORMAL,
        SILK_TOUCH,
        GRASS,
        LEAVES,
        SHEARS,
        NONE,
        ORE,
        SLAB,
        POTTED_PLANT;

    }
}

