/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.worldgen.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.tslat.aoa3.advent.datagen.builder.DataGenBuilder;
import net.tslat.aoa3.util.ObjectUtil;

public class TemplatePoolBuilder
implements DataGenBuilder {
    private final ResourceLocation poolPath;
    private ResourceLocation fallbackPool = new ResourceLocation("empty");
    private final ArrayList<Tuple<Integer, JsonObject>> elements = new ArrayList();

    public TemplatePoolBuilder(String path) {
        this.poolPath = new ResourceLocation("aoa3", path);
    }

    @Override
    public ResourceLocation getId() {
        return this.poolPath;
    }

    public TemplatePoolBuilder withFallback(ResourceLocation fallbackPath) {
        this.fallbackPool = fallbackPath;
        return this;
    }

    public TemplatePoolBuilder withEmptyElement(int weight) {
        this.elements.add((Tuple<Integer, JsonObject>)new Tuple((Object)weight, (Object)this.serializeJigsawPiece((StructurePoolElement)StructurePoolElement.m_210541_().apply(StructureTemplatePool.Projection.RIGID))));
        return this;
    }

    public TemplatePoolBuilder withStructureElement(int weight, String aoaElementPath) {
        return this.withStructureElement(weight, new ResourceLocation("aoa3", aoaElementPath), StructureTemplatePool.Projection.RIGID, (StructureProcessorList)ProcessorLists.f_127198_.m_203334_());
    }

    public TemplatePoolBuilder withStructureElement(int weight, ResourceLocation elementPath, StructureTemplatePool.Projection projection, StructureProcessorList processors) {
        this.elements.add((Tuple<Integer, JsonObject>)new Tuple((Object)weight, (Object)this.serializeJigsawPiece((StructurePoolElement)StructurePoolElement.m_210531_((String)elementPath.toString(), (Holder)Holder.m_205709_((Object)processors)).apply(projection))));
        return this;
    }

    public TemplatePoolBuilder withFeatureElement(int weight, PlacedFeature placedFeature, StructureTemplatePool.Projection projection) {
        this.elements.add((Tuple<Integer, JsonObject>)new Tuple((Object)weight, (Object)this.serializeJigsawPiece((StructurePoolElement)StructurePoolElement.m_210502_((Holder)Holder.m_205709_((Object)placedFeature)).apply(projection))));
        return this;
    }

    public TemplatePoolBuilder withFeaturePoolElement(int weight, ResourceLocation configuredFeature, StructureTemplatePool.Projection projection) {
        JsonObject featureElementObject = new JsonObject();
        featureElementObject.addProperty("feature", configuredFeature.toString());
        featureElementObject.addProperty("projection", projection.m_210604_());
        featureElementObject.addProperty("element_type", "minecraft:feature_pool_element");
        this.elements.add((Tuple<Integer, JsonObject>)new Tuple((Object)weight, (Object)featureElementObject));
        return this;
    }

    public TemplatePoolBuilder withPoolListElement(int weight, StructureTemplatePool.Projection projection, Function<StructureTemplatePool.Projection, ? extends StructurePoolElement> ... pieceFunctions) {
        this.elements.add((Tuple<Integer, JsonObject>)new Tuple((Object)weight, (Object)this.serializeJigsawPiece((StructurePoolElement)StructurePoolElement.m_210519_(Arrays.asList(pieceFunctions)).apply(projection))));
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObj = new JsonObject();
        JsonArray elementsArray = new JsonArray();
        jsonObj.addProperty("name", this.poolPath.toString());
        jsonObj.addProperty("fallback", this.fallbackPool.toString());
        for (Tuple<Integer, JsonObject> element : this.elements) {
            JsonObject elementObj = new JsonObject();
            elementObj.addProperty("weight", (Number)element.m_14418_());
            elementObj.add("element", (JsonElement)element.m_14419_());
            elementsArray.add((JsonElement)elementObj);
        }
        jsonObj.add("elements", (JsonElement)elementsArray);
        return jsonObj;
    }

    private JsonObject serializeJigsawPiece(StructurePoolElement piece) {
        return ObjectUtil.codecToJson(StructurePoolElement.f_210468_, piece, error -> "Unable to serialize template pool element for: " + this.getId() + ". " + error);
    }
}

