/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.worldgen.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.datagen.builder.DataGenBuilder;
import net.tslat.aoa3.util.ObjectUtil;

public class StructureSetBuilder
implements DataGenBuilder {
    private final ResourceLocation id;
    private final ArrayList<Pair<ResourceLocation, Integer>> structures = new ArrayList();
    private StructurePlacement placement = null;

    public StructureSetBuilder(String name) {
        this.id = AdventOfAscension.id(name);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public StructureSetBuilder withStructure(ResourceLocation id) {
        return this.withStructure(id, 1);
    }

    public StructureSetBuilder withStructure(ResourceLocation id, int weight) {
        this.structures.add((Pair<ResourceLocation, Integer>)Pair.of((Object)id, (Object)weight));
        return this;
    }

    public StructureSetBuilder placed(StructurePlacement placement) {
        this.placement = placement;
        return this;
    }

    public StructureSetBuilder placed(RandomSpreadBuilder builder) {
        if (builder.spacing < builder.separation) {
            throw new IllegalArgumentException("Invalid spacing for structure set placement. Minimum gap (spacing) must be greater than or equal to Avg Spread (Separation)");
        }
        this.placement = new RandomSpreadStructurePlacement(builder.spacing, builder.separation, builder.type, new Random(this.id.hashCode()).nextInt(Integer.MAX_VALUE));
        return this;
    }

    @Override
    public JsonObject toJson() {
        if (this.structures.isEmpty()) {
            throw new IllegalArgumentException("No structures provided for structure set: " + this.id);
        }
        if (this.placement == null) {
            throw new IllegalArgumentException("No placement configuration provided for structure set: " + this.id);
        }
        JsonObject json = new JsonObject();
        JsonObject placementJson = ObjectUtil.codecToJson(this.placement.m_203443_().m_205049_(), this.placement, error -> "Unable to serialize structure set placement for: " + this.id);
        JsonArray structuresList = new JsonArray(this.structures.size());
        for (Pair<ResourceLocation, Integer> structure : this.structures) {
            JsonObject structureJson = new JsonObject();
            structureJson.addProperty("structure", ((ResourceLocation)structure.getFirst()).toString());
            structureJson.addProperty("weight", (Number)structure.getSecond());
            structuresList.add((JsonElement)structureJson);
        }
        json.add("structures", (JsonElement)structuresList);
        placementJson.addProperty("type", Registry.f_205930_.m_7981_((Object)this.placement.m_203443_()).toString());
        json.add("placement", (JsonElement)placementJson);
        return json;
    }

    public static class RandomSpreadBuilder {
        private int spacing = 32;
        private int separation = 8;
        private RandomSpreadType type = RandomSpreadType.LINEAR;
        private Vec3i locateOffset = Vec3i.f_123288_;

        public RandomSpreadBuilder minGap(int chunks) {
            this.separation = chunks;
            return this;
        }

        public RandomSpreadBuilder avgGap(int chunks) {
            this.spacing = chunks;
            return this;
        }

        public RandomSpreadBuilder triangularSpread() {
            this.type = RandomSpreadType.TRIANGULAR;
            return this;
        }

        public RandomSpreadBuilder offsetLocateCommandBy(int x, int y, int z) {
            this.locateOffset = new Vec3i(x, y, z);
            return this;
        }
    }
}

