/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.worldgen.gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.datagen.builder.DataGenBuilder;

public class DimensionBuilder
implements DataGenBuilder {
    private final ResourceLocation id;
    private ResourceLocation dimType = null;
    private ResourceLocation generatorType;
    private boolean useServerSeed = true;
    private long seed = 0L;
    private ResourceLocation noiseSettings = null;
    private BiomeSourceBuilder biomeSource = null;

    public DimensionBuilder(String id) {
        this(AdventOfAscension.id(id));
    }

    public DimensionBuilder(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public DimensionBuilder dimType(String dimType) {
        return this.dimType(AdventOfAscension.id(dimType));
    }

    public DimensionBuilder dimType(ResourceLocation dimType) {
        this.dimType = dimType;
        return this;
    }

    public DimensionBuilder seed(long seed) {
        this.seed = seed;
        this.useServerSeed = false;
        return this;
    }

    public DimensionBuilder generator(String generator) {
        return this.generator(AdventOfAscension.id(generator));
    }

    public DimensionBuilder generator(ResourceLocation generator) {
        this.generatorType = generator;
        return this;
    }

    public DimensionBuilder noiseSettings(String noiseSettings) {
        return this.noiseSettings(AdventOfAscension.id(noiseSettings));
    }

    public DimensionBuilder noiseSettings(ResourceLocation noiseSettings) {
        this.noiseSettings = noiseSettings;
        return this;
    }

    public DimensionBuilder biomeSource(BiomeSourceBuilder biomeSource) {
        this.biomeSource = biomeSource;
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonObject generator = new JsonObject();
        JsonObject biomeSource = this.biomeSource.toJson();
        json.addProperty("type", this.dimType.toString());
        if (this.useServerSeed) {
            json.addProperty("forge:use_server_seed", Boolean.valueOf(true));
        }
        generator.addProperty("type", this.generatorType.toString());
        generator.addProperty("seed", (Number)this.seed);
        generator.addProperty("settings", this.noiseSettings.toString());
        biomeSource.addProperty("type", this.biomeSource.type().toString());
        generator.add("biome_source", (JsonElement)biomeSource);
        json.add("generator", (JsonElement)generator);
        return json;
    }

    public static interface BiomeSourceBuilder {
        public ResourceLocation type();

        public JsonObject toJson();
    }
}

