/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.worldgen.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CarvingMaskPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.datagen.builder.DataGenBuilder;
import net.tslat.aoa3.content.world.gen.placementmodifier.PercentChance;
import net.tslat.aoa3.util.ObjectUtil;

public class WorldgenFeatureBuilder<T extends FeatureConfiguration>
implements DataGenBuilder {
    private final ResourceLocation configuredFeatureId;
    private final ResourceLocation placedFeatureId;
    private ConfiguredFeature<T, Feature<T>> configuredFeature;
    private final List<PlacementModifier> placements = new ArrayList<PlacementModifier>();

    public WorldgenFeatureBuilder(Feature<T> feature, T featureConfig) {
        this("", feature, featureConfig);
    }

    public WorldgenFeatureBuilder(String name, Feature<T> feature, T featureConfig) {
        this(name, AdventOfAscension.id(name), feature, featureConfig);
    }

    public WorldgenFeatureBuilder(String name, ResourceLocation configuredFeatureId, Feature<T> feature, T featureConfig) {
        this.placedFeatureId = AdventOfAscension.id(name);
        this.configuredFeatureId = configuredFeatureId;
        this.configuredFeature = new ConfiguredFeature(feature, featureConfig);
    }

    public static <R extends FeatureConfiguration> WorldgenFeatureBuilder<R> fromConfigured(String name, WorldgenFeatureBuilder<R> builder) {
        return new WorldgenFeatureBuilder<FeatureConfiguration>(name, builder.configuredFeatureId, builder.configuredFeature.f_65377_(), builder.configuredFeature.f_65378_());
    }

    @Override
    public ResourceLocation getId() {
        return this.configuredFeatureId;
    }

    public ResourceLocation getPlacedFeatureId() {
        return this.placedFeatureId;
    }

    public ConfiguredFeature<T, Feature<T>> get() {
        return this.configuredFeature;
    }

    public WorldgenFeatureBuilder<T> placeNTimes(int count) {
        return this.placeNTimes((IntProvider)ConstantInt.m_146483_((int)count));
    }

    public WorldgenFeatureBuilder<T> placeNTimes(int min, int max) {
        return this.placeNTimes((IntProvider)UniformInt.m_146622_((int)min, (int)max));
    }

    public WorldgenFeatureBuilder<T> placeNTimes(IntProvider intProvider) {
        return this.placement((PlacementModifier)CountPlacement.m_191630_((IntProvider)intProvider));
    }

    public WorldgenFeatureBuilder<T> oneInXChance(int x) {
        return this.placement((PlacementModifier)RarityFilter.m_191900_((int)x));
    }

    public WorldgenFeatureBuilder<T> percentChance(float chance) {
        assert (chance > 0.0f && chance <= 1.0f);
        return this.placement((PlacementModifier)PercentChance.of(chance));
    }

    public WorldgenFeatureBuilder<T> randomXAndZPos() {
        return this.placement((PlacementModifier)InSquarePlacement.m_191715_());
    }

    public WorldgenFeatureBuilder<T> atYPos(int yPos) {
        return this.placement((PlacementModifier)HeightRangePlacement.m_191683_((HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)new VerticalAnchor.Absolute(yPos))));
    }

    public WorldgenFeatureBuilder<T> yRangeUniformDistribution(VerticalAnchor min, VerticalAnchor max) {
        return this.placement((PlacementModifier)HeightRangePlacement.m_191683_((HeightProvider)UniformHeight.m_162034_((VerticalAnchor)min, (VerticalAnchor)max)));
    }

    public WorldgenFeatureBuilder<T> yRangeNormalDistribution(VerticalAnchor min, VerticalAnchor max) {
        return this.yRangeNormalDistribution(min, max, 0);
    }

    public WorldgenFeatureBuilder<T> yRangeNormalDistribution(VerticalAnchor min, VerticalAnchor max, int plateauSize) {
        return this.placement((PlacementModifier)HeightRangePlacement.m_191683_((HeightProvider)TrapezoidHeight.m_162009_((VerticalAnchor)min, (VerticalAnchor)max, (int)plateauSize)));
    }

    public WorldgenFeatureBuilder<T> onCaveEdge(GenerationStep.Carving caveType) {
        return this.placement((PlacementModifier)CarvingMaskPlacement.m_191590_((GenerationStep.Carving)caveType));
    }

    public WorldgenFeatureBuilder<T> offsetPos(IntProvider verticalOffset, IntProvider lateralOffset) {
        return this.placement((PlacementModifier)RandomOffsetPlacement.m_191879_((IntProvider)lateralOffset, (IntProvider)verticalOffset));
    }

    public WorldgenFeatureBuilder<T> offsetPos(IntProvider verticalOffset) {
        return this.offsetPos(verticalOffset, (IntProvider)ConstantInt.m_146483_((int)0));
    }

    public WorldgenFeatureBuilder<T> ifBlockMatches(BlockPredicate predicate) {
        return this.placement((PlacementModifier)BlockPredicateFilter.m_191576_((BlockPredicate)predicate));
    }

    public WorldgenFeatureBuilder<T> placement(PlacementModifier placement) {
        this.placements.add(placement);
        return this;
    }

    @Override
    public JsonObject toJson() {
        DataResult result = this.configuredFeature.f_65377_().m_65787_().encodeStart((DynamicOps)JsonOps.INSTANCE, this.configuredFeature);
        Optional output = result.resultOrPartial(error -> {
            throw new IllegalArgumentException("Unable to serialize feature: " + this.placedFeatureId.toString() + ". " + error);
        });
        JsonObject object = ((JsonElement)output.get()).getAsJsonObject();
        object.addProperty("type", BuiltinRegistries.f_123861_.m_7981_(this.configuredFeature).toString());
        return object;
    }

    public DataGenBuilder placedFeatureBuilder() {
        JsonObject json = ObjectUtil.codecToJson(PlacedFeature.f_191772_, new PlacedFeature(Holder.m_205709_(this.configuredFeature), this.placements), error -> "Unable to serialize feature placements: " + this.placedFeatureId.toString() + ". " + error);
        json.addProperty("feature", this.placedFeatureId.toString());
        return DataGenBuilder.of(this.placedFeatureId, json);
    }

    public void finalize(Map<String, WorldgenFeatureBuilder<?>> featureMap) {
        if (featureMap.put(this.getPlacedFeatureId().m_135815_(), this) != null) {
            throw new IllegalArgumentException("Duplicate configured feature with name: " + this.getPlacedFeatureId().toString());
        }
    }
}

