/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.datagen.builder.recipe.RecipeBuilder;
import net.tslat.aoa3.advent.datagen.builder.recipe.RecipeResult;
import net.tslat.aoa3.common.registration.AoARecipes;
import org.apache.logging.log4j.Level;

public class ToolInteractionRecipeBuilder
extends RecipeBuilder {
    private Ingredient toolItem;

    public ToolInteractionRecipeBuilder() {
        super(RecipeBuilder.Type.TOOL_INTERACTION);
    }

    public ToolInteractionRecipeBuilder(String recipePath) {
        super(recipePath, RecipeBuilder.Type.TOOL_INTERACTION);
    }

    public ToolInteractionRecipeBuilder toolItem(ItemLike item) {
        this.toolItem = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public ToolInteractionRecipeBuilder toolItem(TagKey<Item> itemTag) {
        this.toolItem = Ingredient.m_204132_(itemTag);
        return this;
    }

    @Override
    public void finalise(Consumer<FinishedRecipe> registryConsumer) {
        try {
            this.finaliseRecipeId();
            registryConsumer.accept(new Result(this.id, this.toolItem, this.outputStack, this.ingredients));
        }
        catch (Exception ex) {
            if (this.id != null) {
                Logging.logMessage(Level.FATAL, "Error building recipe: " + this.id.m_135815_());
            } else {
                Logging.logMessage(Level.FATAL, "Error building recipe");
            }
            throw ex;
        }
    }

    @Override
    protected void finaliseRecipeId() {
        String outputId = "tool_interaction_" + (this.dynamicId ? ForgeRegistries.ITEMS.getKey((Object)this.outputStack.m_41720_()).m_135815_() : this.id.m_135815_());
        this.id = new ResourceLocation("aoa3", outputId);
    }

    public static class Result
    extends RecipeResult {
        private final Ingredient tool;
        private final ItemStack result;
        private final List<Ingredient> ingredients;

        private Result(ResourceLocation id, Ingredient tool, ItemStack result, List<Ingredient> ingredients) {
            super(id, (RecipeSerializer)AoARecipes.TOOL_INTERACTION.serializer().get(), result.m_41720_().m_41471_());
            this.tool = tool;
            this.result = result;
            this.ingredients = ingredients;
        }

        public void m_7917_(JsonObject json) {
            json.add("tool", this.tool.m_43942_());
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsArray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientsArray);
            JsonObject result = new JsonObject();
            result.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                result.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)result);
        }
    }
}

