/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.datagen.recipes.DataGenRecipes;
import net.tslat.aoa3.advent.datagen.recipes.ImbuingRecipeBuilder;
import net.tslat.aoa3.advent.datagen.recipes.InfusionRecipeBuilder;
import net.tslat.aoa3.advent.datagen.recipes.TrophyRecipeBuilder;
import net.tslat.aoa3.advent.datagen.recipes.UpgradeKitRecipeBuilder;
import net.tslat.aoa3.util.LocaleUtil;
import org.apache.logging.log4j.Level;

public class RecipeBuilder {
    protected ResourceLocation id;
    protected final boolean dynamicId;
    protected final ArrayList<Ingredient> ingredients = new ArrayList();
    protected final HashMap<String, ItemPredicate> recipeUnlockPredicates = new HashMap();
    protected ItemStack outputStack;
    protected final Type recipeType;
    protected String group;
    protected ArrayList<Character> ingredientKeys;
    protected String[] recipeShape;
    protected int recipeTime = -1;
    protected float recipeXp = 0.0f;
    protected int infusionReq = 1;
    protected Enchantment infusionEnchant;
    protected int infusionEnchantLevel = 1;

    public RecipeBuilder(Type recipeType) {
        this.recipeType = recipeType;
        this.dynamicId = true;
        DataGenRecipes.RECIPES.add(this);
    }

    public RecipeBuilder(String recipePath, Type recipeType) {
        this.id = new ResourceLocation("aoa3", recipePath);
        this.recipeType = recipeType;
        this.dynamicId = false;
        DataGenRecipes.RECIPES.add(this);
    }

    public RecipeBuilder ingredients(ItemLike ... itemProviders) {
        for (ItemLike provider : itemProviders) {
            this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{provider}));
            this.recipeUnlockPredicates.put(ForgeRegistries.ITEMS.getKey((Object)provider.m_5456_()).m_135815_(), ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{provider}).m_45077_());
        }
        return this;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public Type getType() {
        return this.recipeType;
    }

    public ArrayList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public RecipeBuilder ingredients(ItemStack ... ingredients) {
        for (ItemStack stack : ingredients) {
            ItemStack stackCopy = stack.m_41777_();
            stackCopy.m_41764_(1);
            for (int i = 0; i < stack.m_41613_(); ++i) {
                this.ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stackCopy}));
                this.recipeUnlockPredicates.put(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_(), ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{stack.m_41720_()}).m_45077_());
            }
        }
        return this;
    }

    public RecipeBuilder ingredients(ResourceLocation ... ids) {
        for (ResourceLocation id : ids) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item == null) {
                throw new IllegalArgumentException("Invalid item id for recipe: " + id);
            }
            this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
            this.recipeUnlockPredicates.put(id.m_135815_(), ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
        }
        return this;
    }

    public RecipeBuilder ingredients(TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            this.ingredients.add(Ingredient.m_204132_(tag));
            this.recipeUnlockPredicates.put(tag.f_203868_().m_135815_(), ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
        }
        return this;
    }

    public RecipeBuilder ingredient(char symbol, ItemLike item) {
        if (this.ingredientKeys == null) {
            this.ingredientKeys = new ArrayList();
        }
        this.ingredientKeys.add(Character.valueOf(symbol));
        this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        this.recipeUnlockPredicates.put(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
        return this;
    }

    public RecipeBuilder ingredient(char symbol, TagKey<Item> tag) {
        if (this.ingredientKeys == null) {
            this.ingredientKeys = new ArrayList();
        }
        this.ingredientKeys.add(Character.valueOf(symbol));
        this.ingredients.add(Ingredient.m_204132_(tag));
        this.recipeUnlockPredicates.put(tag.f_203868_().m_135815_(), ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
        return this;
    }

    public RecipeBuilder shape(String ... shapeLines) {
        this.recipeShape = shapeLines;
        return this;
    }

    public RecipeBuilder output(ItemStack outputStack) {
        this.outputStack = outputStack;
        return this;
    }

    public RecipeBuilder timeToCraft(int ticks) {
        this.recipeTime = ticks;
        return this;
    }

    public RecipeBuilder xp(float xp) {
        this.recipeXp = xp;
        return this;
    }

    public RecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public RecipeBuilder infusionRequirement(int level) {
        this.infusionReq = level;
        return this;
    }

    public RecipeBuilder infusionEnchant(Enchantment enchantment) {
        this.infusionEnchant = enchantment;
        this.infusionEnchantLevel = 1;
        return this;
    }

    public RecipeBuilder infusionEnchant(Enchantment enchantment, int level) {
        this.infusionEnchant = enchantment;
        this.infusionEnchantLevel = level;
        return this;
    }

    public void finalise(Consumer<FinishedRecipe> registryConsumer) {
        try {
            this.finaliseRecipeId();
            switch (this.recipeType) {
                case STONECUTTING: {
                    SingleItemRecipeBuilder stonecuttingRecipeBuilder = new SingleItemRecipeBuilder(RecipeSerializer.f_44095_, this.ingredients.get(0), (ItemLike)this.outputStack.m_41720_(), this.outputStack.m_41613_()){

                        public void m_126329_(ResourceLocation id) {
                        }
                    };
                    this.unlockCriteria(stonecuttingRecipeBuilder).m_126140_(registryConsumer, this.id);
                    break;
                }
                case SMOKING: {
                    if (this.outputStack.m_41720_().m_41473_() == null) {
                        Logging.logMessage(Level.WARN, "Registered cooking recipe for non-food item. May need to double check: " + this.id.m_135815_());
                    }
                    SimpleCookingRecipeBuilder smokingRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, this.recipeTime == -1 ? 100 : this.recipeTime, RecipeSerializer.f_44093_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    this.unlockCriteria(smokingRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", "smoking_" + this.id.m_135815_()));
                    break;
                }
                case CAMPFIRE_COOKING: {
                    if (this.outputStack.m_41720_().m_41473_() == null) {
                        Logging.logMessage(Level.WARN, "Registered cooking recipe for non-food item. May need to double check: " + this.id.m_135815_());
                    }
                    SimpleCookingRecipeBuilder campfireRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, this.recipeTime == -1 ? 600 : this.recipeTime, RecipeSerializer.f_44094_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    this.unlockCriteria(campfireRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", "campfire_" + this.id.m_135815_()));
                    break;
                }
                case ALL_COOKING: {
                    if (this.outputStack.m_41720_().m_41473_() == null) {
                        Logging.logMessage(Level.WARN, "Registered cooking recipe for non-food item. May need to double check: " + this.id.m_135815_());
                    }
                    if (this.recipeTime == -1) {
                        this.recipeTime = 200;
                    }
                    SimpleCookingRecipeBuilder smeltingRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, this.recipeTime, RecipeSerializer.f_44091_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    SimpleCookingRecipeBuilder campfireRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, this.recipeTime * 3, RecipeSerializer.f_44094_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    SimpleCookingRecipeBuilder smokingRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, (int)((float)this.recipeTime * 0.5f), RecipeSerializer.f_44093_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    this.unlockCriteria(smeltingRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", "cooking_" + this.id.m_135815_()));
                    this.unlockCriteria(campfireRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", "campfire_" + this.id.m_135815_()));
                    this.unlockCriteria(smokingRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", "smoking_" + this.id.m_135815_()));
                    break;
                }
                case BLASTING: {
                    SimpleCookingRecipeBuilder blastingRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, this.recipeTime == -1 ? 100 : this.recipeTime, RecipeSerializer.f_44092_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    this.unlockCriteria(blastingRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", this.id.m_135815_()));
                    break;
                }
                case SMELTING: {
                    SimpleCookingRecipeBuilder smeltingRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, this.recipeTime == -1 ? 200 : this.recipeTime, RecipeSerializer.f_44091_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    this.unlockCriteria(smeltingRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", this.id.m_135815_()));
                    break;
                }
                case ALL_MINERAL_PROCESSING: {
                    if (this.recipeTime == -1) {
                        this.recipeTime = 200;
                    }
                    SimpleCookingRecipeBuilder smeltingRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, this.recipeTime, RecipeSerializer.f_44091_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    SimpleCookingRecipeBuilder blastingRecipeBuilder = new SimpleCookingRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.ingredients.get(0), this.recipeXp, (int)((float)this.recipeTime * 0.5f), RecipeSerializer.f_44092_){

                        public void m_126265_(ResourceLocation id) {
                        }
                    };
                    this.unlockCriteria(smeltingRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", "smelting_" + this.id.m_135815_()));
                    this.unlockCriteria(blastingRecipeBuilder).m_126140_(registryConsumer, new ResourceLocation("aoa3", "blasting_" + this.id.m_135815_()));
                    break;
                }
                case SHAPED: {
                    ShapedRecipeBuilder shapedRecipeBuilder = new ShapedRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.outputStack.m_41613_()){

                        public void m_126143_(ResourceLocation id) {
                        }
                    };
                    for (int i = 0; i < this.ingredients.size(); ++i) {
                        shapedRecipeBuilder.m_126124_(this.ingredientKeys.get(i), this.ingredients.get(i));
                    }
                    for (String line : this.recipeShape) {
                        shapedRecipeBuilder.m_126130_(line);
                    }
                    if (this.group != null) {
                        shapedRecipeBuilder.m_126145_(this.group);
                    }
                    this.unlockCriteria(shapedRecipeBuilder);
                    shapedRecipeBuilder.m_126140_(registryConsumer, this.id);
                    break;
                }
                case SHAPELESS: {
                    ShapelessRecipeBuilder shapelessRecipeBuilder = new ShapelessRecipeBuilder((ItemLike)this.outputStack.m_41720_(), this.outputStack.m_41613_()){

                        public void m_126207_(ResourceLocation id) {
                        }
                    };
                    for (Ingredient ing : this.ingredients) {
                        shapelessRecipeBuilder.m_126184_(ing);
                    }
                    if (this.group != null) {
                        shapelessRecipeBuilder.m_126145_(this.group);
                    }
                    this.unlockCriteria(shapelessRecipeBuilder);
                    shapelessRecipeBuilder.m_126140_(registryConsumer, this.id);
                    break;
                }
                case UPGRADE_KIT: {
                    UpgradeKitRecipeBuilder upgradeKitRecipeBuilder = new UpgradeKitRecipeBuilder(this.ingredients.get(0), this.ingredients.get(1), (ItemLike)this.outputStack.m_41720_(), this.outputStack.m_41613_());
                    this.unlockCriteria(upgradeKitRecipeBuilder);
                    upgradeKitRecipeBuilder.build(registryConsumer, this.id);
                    break;
                }
                case INFUSION: {
                    Ingredient input = this.ingredients.get(0);
                    this.ingredients.remove(0);
                    InfusionRecipeBuilder infusionRecipeBuilder = new InfusionRecipeBuilder(input, this.ingredients, this.outputStack, this.infusionReq);
                    this.unlockCriteria(infusionRecipeBuilder);
                    infusionRecipeBuilder.build(registryConsumer, this.id);
                    break;
                }
                case IMBUING: {
                    ImbuingRecipeBuilder imbuingRecipeBuilder = new ImbuingRecipeBuilder(this.ingredients, new EnchantmentInstance(this.infusionEnchant, this.infusionEnchantLevel), this.infusionReq);
                    this.unlockCriteria(imbuingRecipeBuilder);
                    imbuingRecipeBuilder.build(registryConsumer, this.id);
                    break;
                }
                case TROPHY: {
                    TrophyRecipeBuilder trophyRecipeBuilder = new TrophyRecipeBuilder();
                    this.unlockCriteria(trophyRecipeBuilder);
                    trophyRecipeBuilder.build(registryConsumer, this.id);
                    break;
                }
            }
        }
        catch (Exception ex) {
            if (this.id != null) {
                Logging.logMessage(Level.FATAL, "Error building recipe: " + this.id.m_135815_());
            } else {
                Logging.logMessage(Level.FATAL, "Error building recipe");
            }
            throw ex;
        }
    }

    protected void finaliseRecipeId() {
        switch (this.recipeType) {
            case STONECUTTING: 
            case SMOKING: 
            case BLASTING: 
            case SMELTING: 
            case UPGRADE_KIT: 
            case INFUSION: {
                String outputId = this.recipeType.toString().toLowerCase() + "_" + (this.dynamicId ? ForgeRegistries.ITEMS.getKey((Object)this.outputStack.m_41720_()).m_135815_() : this.id.m_135815_());
                this.id = new ResourceLocation("aoa3", outputId);
                break;
            }
            case IMBUING: {
                Object enchantName = ForgeRegistries.ENCHANTMENTS.getKey((Object)this.infusionEnchant).m_135815_();
                if (this.infusionEnchantLevel > 1) {
                    enchantName = this.infusionEnchantLevel > 10 ? (String)enchantName + "_" + this.infusionEnchantLevel : (String)enchantName + "_" + LocaleUtil.getLocaleString("enchantment.level." + this.infusionEnchantLevel).toLowerCase(Locale.ENGLISH);
                }
                String outputId = this.recipeType.toString().toLowerCase() + "_" + (this.dynamicId ? ((String)enchantName).replace(" ", "_") : this.id.m_135815_());
                this.id = new ResourceLocation("aoa3", outputId);
                break;
            }
            case CAMPFIRE_COOKING: {
                String outputId = "campfire_" + (this.dynamicId ? ForgeRegistries.ITEMS.getKey((Object)this.outputStack.m_41720_()).m_135815_() : this.id.m_135815_());
                this.id = new ResourceLocation("aoa3", outputId);
                break;
            }
            case ALL_COOKING: 
            case ALL_MINERAL_PROCESSING: {
                String outputId = this.dynamicId ? ForgeRegistries.ITEMS.getKey((Object)this.outputStack.m_41720_()).m_135815_() : this.id.m_135815_();
                this.id = new ResourceLocation("aoa3", outputId);
                break;
            }
            case SHAPED: {
                String outputId = "shaped_craft_" + (this.dynamicId ? ForgeRegistries.ITEMS.getKey((Object)this.outputStack.m_41720_()).m_135815_() : this.id.m_135815_());
                this.id = new ResourceLocation("aoa3", outputId);
                break;
            }
            case SHAPELESS: {
                String outputId = "shapeless_craft_" + (this.dynamicId ? ForgeRegistries.ITEMS.getKey((Object)this.outputStack.m_41720_()).m_135815_() : this.id.m_135815_());
                this.id = new ResourceLocation("aoa3", outputId);
                break;
            }
            case TROPHY: {
                String outputId = "trophy_crafting";
                this.id = new ResourceLocation("aoa3", outputId);
            }
        }
    }

    private SimpleCookingRecipeBuilder unlockCriteria(SimpleCookingRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    private SingleItemRecipeBuilder unlockCriteria(SingleItemRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    private ShapelessRecipeBuilder unlockCriteria(ShapelessRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    private ShapedRecipeBuilder unlockCriteria(ShapedRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    private UpgradeKitRecipeBuilder unlockCriteria(UpgradeKitRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    private InfusionRecipeBuilder unlockCriteria(InfusionRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    private ImbuingRecipeBuilder unlockCriteria(ImbuingRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    private TrophyRecipeBuilder unlockCriteria(TrophyRecipeBuilder recipeBuilder) {
        return recipeBuilder;
    }

    public static enum Type {
        SHAPED,
        SHAPELESS,
        SMELTING,
        BLASTING,
        ALL_MINERAL_PROCESSING,
        SMOKING,
        CAMPFIRE_COOKING,
        ALL_COOKING,
        STONECUTTING,
        INFUSION,
        IMBUING,
        UPGRADE_KIT,
        TROPHY,
        TOOL_INTERACTION;

    }
}

