/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.loot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.tslat.aoa3.advent.datagen.builder.loot.LootPoolBuilder;

public class LootTableBuilder {
    private final ResourceLocation id;
    private final ArrayList<LootPoolBuilder> pools = new ArrayList(1);
    private final ArrayList<LootItemFunction.Builder> functions = new ArrayList(1);
    private LootContextParamSet params = LootContextParamSets.f_81420_;

    public LootTableBuilder(ResourceLocation id) {
        this.id = id;
    }

    public LootTableBuilder(String path) {
        this(new ResourceLocation("aoa3", path));
    }

    public LootTableBuilder(String group, ResourceLocation objectId) {
        this(new ResourceLocation(objectId.m_135827_(), group), objectId);
    }

    public LootTableBuilder(ResourceLocation subPath, ResourceLocation objectId) {
        this(new ResourceLocation(objectId.m_135827_(), subPath.m_135815_() + "/" + objectId.m_135815_()));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public LootTableBuilder forEntities() {
        this.params = LootContextParamSets.f_81415_;
        return this;
    }

    public LootTableBuilder forChests() {
        this.params = LootContextParamSets.f_81411_;
        return this;
    }

    public LootTableBuilder forBlocks() {
        this.params = LootContextParamSets.f_81421_;
        return this;
    }

    public LootTableBuilder forAdvancements() {
        this.params = LootContextParamSets.f_81418_;
        return this;
    }

    public LootTableBuilder forFishing() {
        this.params = LootContextParamSets.f_81414_;
        return this;
    }

    public LootTableBuilder forGift() {
        this.params = LootContextParamSets.f_81416_;
        return this;
    }

    public LootTableBuilder forPiglinBartering() {
        this.params = LootContextParamSets.f_81417_;
        return this;
    }

    public LootTableBuilder pools(LootPoolBuilder ... pools) {
        Collections.addAll(this.pools, pools);
        return this;
    }

    public LootTableBuilder andDo(LootItemFunction.Builder ... functions) {
        this.functions.addAll(Arrays.asList(functions));
        return this;
    }

    public LootTableBuilder withExplosionDecay() {
        return this.andDo(new LootItemFunction.Builder[]{ApplyExplosionDecay.m_80037_()});
    }

    public LootTable build() {
        LootTable.Builder tableBuilder = new LootTable.Builder();
        tableBuilder.m_79165_(this.params);
        for (LootItemFunction.Builder function : this.functions) {
            tableBuilder.m_79078_(function);
        }
        for (LootPoolBuilder compactPool : this.pools) {
            tableBuilder.m_79161_(compactPool.build());
        }
        return tableBuilder.m_79167_();
    }

    public void finalize(HashMap<ResourceLocation, LootTable> lootTables) {
        lootTables.put(this.getId(), this.build());
    }
}

