/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.loot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.builder.loot.LootEntryBuilder;
import net.tslat.aoa3.content.loottable.condition.HoldingItem;
import net.tslat.aoa3.content.loottable.condition.PlayerHasLevel;
import net.tslat.aoa3.content.loottable.condition.PlayerHasResource;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;

public class LootPoolBuilder {
    private final String name;
    private NumberProvider rolls = ConstantValue.m_165692_((float)1.0f);
    private UniformGenerator bonusRolls = UniformGenerator.m_165780_((float)0.0f, (float)0.0f);
    private final ArrayList<LootItemCondition.Builder> conditions = new ArrayList(1);
    private final ArrayList<LootItemFunction.Builder> functions = new ArrayList(1);
    private final ArrayList<LootPoolEntryContainer.Builder<?>> entries = new ArrayList();

    public LootPoolBuilder() {
        this(null);
    }

    public LootPoolBuilder(String name) {
        this.name = name;
    }

    public LootPoolBuilder rolls(int rolls) {
        this.rolls = ConstantValue.m_165692_((float)rolls);
        return this;
    }

    public LootPoolBuilder rolls(int min, int max) {
        this.rolls = UniformGenerator.m_165780_((float)min, (float)max);
        return this;
    }

    public LootPoolBuilder bonusLuckRolls(int bonusRolls) {
        return this.bonusLuckRolls(bonusRolls, bonusRolls);
    }

    public LootPoolBuilder bonusLuckRolls(int min, int max) {
        this.bonusRolls = UniformGenerator.m_165780_((float)min, (float)max);
        return this;
    }

    public LootPoolBuilder onlyWhen(LootItemCondition.Builder ... conditions) {
        Collections.addAll(this.conditions, conditions);
        return this;
    }

    public LootPoolBuilder onlyWhenAny(LootItemCondition.Builder ... conditions) {
        return this.onlyWhen(new LootItemCondition.Builder[]{AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])conditions)});
    }

    public LootPoolBuilder andDo(LootItemFunction.Builder ... functions) {
        Collections.addAll(this.functions, functions);
        return this;
    }

    public LootPoolBuilder entries(LootPoolEntryContainer.Builder<?> ... entries) {
        Collections.addAll(this.entries, entries);
        return this;
    }

    public LootPoolBuilder item(RegistryObject<? extends ItemLike> item, int weight, int luckAdjust, int minAmount, int maxAmount, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.item((ItemLike)item.get(), weight, luckAdjust, minAmount, maxAmount, entryModifier);
    }

    public LootPoolBuilder item(RegistryObject<? extends ItemLike> item, int weight, int luckAdjust, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.item(item, weight, luckAdjust, 1, 1, entryModifier);
    }

    public LootPoolBuilder item(RegistryObject<? extends ItemLike> item, int weight, int minAmount, int maxAmount, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.item(item, weight, 0, minAmount, maxAmount, entryModifier);
    }

    public LootPoolBuilder item(RegistryObject<? extends ItemLike> item, int weight, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.item(item, weight, 0, 1, 1, entryModifier);
    }

    public LootPoolBuilder item(ItemLike item, int weight, int luckAdjust, int minAmount, int maxAmount, Consumer<LootEntryBuilder> ... entryModifier) {
        LootEntryBuilder builder = new LootEntryBuilder(item, weight).luckAdjust(luckAdjust);
        if (maxAmount > 1) {
            builder.setCount(minAmount, maxAmount);
        }
        if (entryModifier != null && entryModifier.length > 0) {
            entryModifier[0].accept(builder);
        }
        return this.entries(new LootPoolEntryContainer.Builder[]{builder.build()});
    }

    public LootPoolBuilder item(ItemLike item, int weight, int luckAdjust, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.item(item, weight, luckAdjust, 1, 1, entryModifier);
    }

    public LootPoolBuilder item(ItemLike item, int weight, int minAmount, int maxAmount, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.item(item, weight, 0, minAmount, maxAmount, entryModifier);
    }

    public LootPoolBuilder item(ItemLike item, int weight, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.item(item, weight, 0, 1, 1, entryModifier);
    }

    public LootPoolBuilder empty(int weight, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.empty(weight, 0, entryModifier);
    }

    public LootPoolBuilder empty(int weight, int luckAdjust, Consumer<LootEntryBuilder> ... entryModifier) {
        LootEntryBuilder builder = new LootEntryBuilder(EmptyLootItem.m_79533_().m_79707_(weight)).luckAdjust(luckAdjust);
        if (entryModifier != null && entryModifier.length > 0) {
            entryModifier[0].accept(builder);
        }
        return this.entries(new LootPoolEntryContainer.Builder[]{builder.build()});
    }

    public LootPoolBuilder table(ResourceLocation table, int weight, int quality, Consumer<LootEntryBuilder> ... entryModifier) {
        LootEntryBuilder builder = new LootEntryBuilder(LootTableReference.m_79776_((ResourceLocation)table).m_79707_(weight)).luckAdjust(quality);
        if (entryModifier != null && entryModifier.length > 0) {
            entryModifier[0].accept(builder);
        }
        return this.entries(new LootPoolEntryContainer.Builder[]{builder.build()});
    }

    public LootPoolBuilder table(ResourceLocation table, int weight, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.table(table, weight, 0, entryModifier);
    }

    public LootPoolBuilder table(String table, int weight, int quality, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.table(new ResourceLocation("aoa3", table), weight, quality, entryModifier);
    }

    public LootPoolBuilder table(String table, int weight, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.table(table, weight, 0, entryModifier);
    }

    public LootPoolBuilder tag(TagKey<Item> tag, int weight, int luckAdjust, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.tag(tag, weight, luckAdjust, 1, 1, entryModifier);
    }

    public LootPoolBuilder tag(TagKey<Item> tag, int weight, int minAmount, int maxAmount, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.tag(tag, weight, 0, minAmount, maxAmount, entryModifier);
    }

    public LootPoolBuilder tag(TagKey<Item> tag, int weight, Consumer<LootEntryBuilder> ... entryModifier) {
        return this.tag(tag, weight, 0, 1, 1, entryModifier);
    }

    public LootPoolBuilder tag(TagKey<Item> tag, int weight, int luckAdjust, int minAmount, int maxAmount, Consumer<LootEntryBuilder> ... entryModifier) {
        LootEntryBuilder builder = new LootEntryBuilder(TagEntry.m_205095_(tag).m_79707_(weight)).luckAdjust(luckAdjust);
        if (maxAmount > 1) {
            builder.setCount(minAmount, maxAmount);
        }
        if (entryModifier != null && entryModifier.length > 0) {
            entryModifier[0].accept(builder);
        }
        return this.entries(new LootPoolEntryContainer.Builder[]{builder.build()});
    }

    public LootPoolBuilder firstSuccessfulEntry(LootEntryBuilder ... entries) {
        LootPoolEntryContainer.Builder[] builders = new LootPoolEntryContainer.Builder[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            builders[i] = entries[i].build();
        }
        return this.firstSuccessfulEntry(builders);
    }

    public LootPoolBuilder firstSuccessfulEntry(LootPoolEntryContainer.Builder<?> ... entries) {
        AlternativesEntry.Builder builder = AlternativesEntry.m_79395_(entries);
        return this.entries(new LootPoolEntryContainer.Builder[]{builder});
    }

    public LootPoolBuilder onlyIfPlayerKills() {
        return this.onlyWhen(LootItemKilledByPlayerCondition.m_81901_());
    }

    public LootPoolBuilder ifHolding(ItemPredicate itemPredicate, LootContext.EntityTarget entityPredicate, @Nullable InteractionHand hand) {
        return this.onlyWhen(() -> new HoldingItem(entityPredicate, itemPredicate, hand));
    }

    public LootPoolBuilder ifHolding(ItemLike item, LootContext.EntityTarget entityPredicate, @Nullable InteractionHand hand) {
        return this.ifHolding(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), entityPredicate, hand);
    }

    public LootPoolBuilder ifHolding(ItemLike item) {
        return this.ifHolding(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), LootContext.EntityTarget.THIS, null);
    }

    public LootPoolBuilder ifPlayerKillsWith(ItemLike item) {
        return this.ifHolding(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), LootContext.EntityTarget.KILLER_PLAYER, InteractionHand.MAIN_HAND);
    }

    public LootPoolBuilder ifHasResource(AoAResource resource, float amount, boolean consumeResource) {
        return this.onlyWhen(() -> new PlayerHasResource(resource, amount, consumeResource));
    }

    public LootPoolBuilder ifHasResource(AoAResource resource, float amount) {
        return this.ifHasResource(resource, amount, false);
    }

    public LootPoolBuilder ifHasLevel(AoASkill skill, int lvl) {
        return this.onlyWhen(() -> new PlayerHasLevel(skill, lvl));
    }

    public LootPoolBuilder ifHasSilkTouch() {
        return this.onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))));
    }

    public LootPoolBuilder ifToolMatches(ItemLike tool) {
        return this.onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{tool})));
    }

    public LootPoolBuilder ifToolMatches(TagKey<Item> tag) {
        return this.onlyWhen(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(tag)));
    }

    public LootPoolBuilder ifSurvivesExplosion() {
        return this.onlyWhen(ExplosionCondition.m_81661_());
    }

    public LootPoolBuilder onlyWhenNot(LootItemCondition.Builder condition) {
        return this.onlyWhen(InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)condition));
    }

    public LootPoolBuilder checkExplosionDecay() {
        return this.andDo(new LootItemFunction.Builder[]{ApplyExplosionDecay.m_80037_()});
    }

    public LootPoolBuilder percentChance(float chance) {
        return this.onlyWhen(LootItemRandomChanceCondition.m_81927_((float)chance));
    }

    public LootPool.Builder build() {
        LootPool.Builder poolBuilder = new LootPool.Builder();
        poolBuilder.name(this.name);
        poolBuilder.m_165133_(this.rolls);
        poolBuilder.m_165135_((NumberProvider)this.bonusRolls);
        for (LootItemCondition.Builder builder : this.conditions) {
            poolBuilder.m_79080_(builder);
        }
        for (LootItemFunction.Builder builder : this.functions) {
            poolBuilder.m_79078_(builder);
        }
        for (LootPoolEntryContainer.Builder builder : this.entries) {
            poolBuilder.m_79076_(builder);
        }
        return poolBuilder;
    }
}

