/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.loot;

import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.tslat.aoa3.content.loottable.condition.HoldingItem;
import net.tslat.aoa3.content.loottable.condition.PlayerHasLevel;
import net.tslat.aoa3.content.loottable.condition.PlayerHasResource;
import net.tslat.aoa3.content.loottable.function.EnchantSpecific;
import net.tslat.aoa3.content.loottable.function.GrantSkillXp;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;

public class LootEntryBuilder {
    private final LootPoolSingletonContainer.Builder<?> builder;

    public LootEntryBuilder(LootPoolSingletonContainer.Builder<?> builder) {
        this.builder = builder;
    }

    public LootEntryBuilder(ItemLike item, int weight) {
        this(LootItem.m_79579_((ItemLike)item).m_79707_(weight));
    }

    public LootEntryBuilder luckAdjust(int quality) {
        this.builder.m_79711_(quality);
        return this;
    }

    public LootEntryBuilder onlyWhen(LootItemCondition.Builder condition) {
        this.builder.m_79080_(condition);
        return this;
    }

    public LootEntryBuilder onlyWhenAny(LootItemCondition.Builder ... conditions) {
        return this.onlyWhen((LootItemCondition.Builder)AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])conditions));
    }

    public LootEntryBuilder andDo(LootItemFunction.Builder function) {
        this.builder.m_79078_(function);
        return this;
    }

    public LootEntryBuilder smeltLootIfOnFire() {
        return this.andDo((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_()))));
    }

    public LootEntryBuilder lootingBonus(int min, int max) {
        return this.andDo((LootItemFunction.Builder)new LootingEnchantFunction.Builder((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootEntryBuilder lootingBonus(int bonus) {
        return this.lootingBonus(bonus, bonus);
    }

    public LootEntryBuilder onlyIfPlayerKills() {
        return this.onlyWhen(LootItemKilledByPlayerCondition.m_81901_());
    }

    public LootEntryBuilder ifHolding(ItemPredicate itemPredicate, LootContext.EntityTarget entityPredicate, @Nullable InteractionHand hand) {
        return this.onlyWhen(() -> new HoldingItem(entityPredicate, itemPredicate, hand));
    }

    public LootEntryBuilder ifHolding(ItemLike item, LootContext.EntityTarget entityPredicate, @Nullable InteractionHand hand) {
        return this.ifHolding(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), entityPredicate, hand);
    }

    public LootEntryBuilder ifHolding(ItemLike item) {
        return this.ifHolding(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), LootContext.EntityTarget.THIS, null);
    }

    public LootEntryBuilder ifPlayerKillsWith(ItemLike item) {
        return this.ifHolding(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), LootContext.EntityTarget.KILLER_PLAYER, InteractionHand.MAIN_HAND);
    }

    public LootEntryBuilder ifHasResource(AoAResource resource, float amount, boolean consumeResource) {
        return this.onlyWhen(() -> new PlayerHasResource(resource, amount, consumeResource));
    }

    public LootEntryBuilder ifHasResource(AoAResource resource, float amount) {
        return this.ifHasResource(resource, amount, false);
    }

    public LootEntryBuilder ifHasLevel(AoASkill skill, int lvl) {
        return this.onlyWhen(() -> new PlayerHasLevel(skill, lvl));
    }

    public LootEntryBuilder ifSurvivesExplosion() {
        return this.onlyWhen(ExplosionCondition.m_81661_());
    }

    public LootEntryBuilder ifHasSilkTouch() {
        return this.onlyWhen(LootEntryBuilder.hasEnchantAtLeast(Enchantments.f_44985_, 1));
    }

    public LootEntryBuilder ifPassesLooting(float baseChance, float extraChancePerLevel) {
        return this.onlyWhen(LootItemRandomChanceWithLootingCondition.m_81963_((float)baseChance, (float)extraChancePerLevel));
    }

    public LootEntryBuilder ifMeetsEnchantmentBasedChance(Enchantment enchant, float ... chances) {
        return this.onlyWhen(BonusLevelTableCondition.m_81517_((Enchantment)enchant, (float[])chances));
    }

    public LootEntryBuilder grantSkillXp(AoASkill skill, float xp) {
        return this.andDo((LootItemFunction.Builder)GrantSkillXp.builder(skill, xp));
    }

    public LootEntryBuilder withNbt(CompoundTag nbt) {
        return this.andDo((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)nbt));
    }

    public LootEntryBuilder withEnchants(EnchantmentInstance ... enchantments) {
        return this.andDo((LootItemFunction.Builder)EnchantSpecific.builder(enchantments));
    }

    public LootEntryBuilder withRandomEnchants(Enchantment ... enchants) {
        EnchantRandomlyFunction.Builder builder = new EnchantRandomlyFunction.Builder();
        for (Enchantment enchant : enchants) {
            builder.m_80444_(enchant);
        }
        return this.andDo((LootItemFunction.Builder)builder);
    }

    public LootEntryBuilder fortuneOreBonuses() {
        return this.andDo((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_));
    }

    public LootEntryBuilder checkExplosionDecay() {
        return this.andDo((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
    }

    public LootEntryBuilder setCount(int min, int max) {
        if (min == max) {
            return this.andDo((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)min)));
        }
        return this.andDo((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootPoolSingletonContainer.Builder<?> build() {
        return this.builder;
    }

    public static AlternativesEntry.Builder firstSuccessfulEntry(LootEntryBuilder ... entries) {
        LootPoolEntryContainer.Builder[] entryArray = new LootPoolEntryContainer.Builder[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            entryArray[i] = entries[i].build();
        }
        return LootEntryBuilder.firstSuccessfulEntry(entryArray);
    }

    public static AlternativesEntry.Builder firstSuccessfulEntry(LootPoolEntryContainer.Builder<?> ... entries) {
        return AlternativesEntry.m_79395_(entries);
    }

    public static LootItemCondition.Builder matchItem(TagKey<Item> tag) {
        return MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(tag));
    }

    public static LootItemCondition.Builder matchItem(ItemLike item) {
        return MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}));
    }

    public static LootItemCondition.Builder matchEnchant(Enchantment enchant, int lvlMin, boolean exactMatch) {
        MinMaxBounds.Ints bounds = exactMatch ? MinMaxBounds.Ints.m_55371_((int)lvlMin) : MinMaxBounds.Ints.m_55386_((int)lvlMin);
        return MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(enchant, bounds)));
    }

    public static LootItemCondition.Builder hasEnchant(Enchantment enchant) {
        return LootEntryBuilder.matchEnchant(enchant, 1, false);
    }

    public static LootItemCondition.Builder hasEnchantAtLeast(Enchantment enchant, int lvlMin) {
        return LootEntryBuilder.matchEnchant(enchant, lvlMin, false);
    }

    public static LootItemCondition.Builder hasEnchantExactly(Enchantment enchant, int lvlMin) {
        return LootEntryBuilder.matchEnchant(enchant, lvlMin, true);
    }

    public static LootItemCondition.Builder anyCondition(LootItemCondition.Builder ... conditions) {
        return AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])conditions);
    }
}

