/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.AoAAbilityBuilder;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;

public class PotionDurationReducerBuilder
extends AoAAbilityBuilder<PotionDurationReducerBuilder> {
    private Boolean matchType = null;

    public PotionDurationReducerBuilder(float modifier) {
        super(AoAAbilities.POTION_DURATION_REDUCER);
        this.modifier(modifier);
    }

    public PotionDurationReducerBuilder modifier(float amount) {
        return (PotionDurationReducerBuilder)this.floatProperty("modifier", amount);
    }

    public PotionDurationReducerBuilder useAddition() {
        return (PotionDurationReducerBuilder)this.booleanProperty("use_addition", true);
    }

    public PotionDurationReducerBuilder matchEffectType(MobEffectCategory effectType) {
        if (this.matchType == null) {
            this.matchType = true;
        } else if (!this.matchType.booleanValue()) {
            throw new IllegalStateException("Cannot use both MobEffectCategory and ID matching for PotionDurationReducer ability.");
        }
        return (PotionDurationReducerBuilder)this.stringProperty("match_effect_type", effectType.toString());
    }

    public PotionDurationReducerBuilder matchPotions(MobEffect ... effects) {
        if (this.matchType == null) {
            this.matchType = false;
        } else if (this.matchType.booleanValue()) {
            throw new IllegalStateException("Cannot use both MobEffectCategory and ID matching for PotionDurationReducer ability.");
        }
        return (PotionDurationReducerBuilder)this.arrayProperty("match_effects", Arrays.asList(effects).stream().map(effect -> ForgeRegistries.MOB_EFFECTS.getKey(effect).toString()).collect(Collectors.toList()));
    }
}

