/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class AoAAbilityBuilder<T extends AoAAbilityBuilder<?>> {
    private final ResourceLocation id;
    private String uniqueId;
    private final HashMap<String, JsonElement> properties = new HashMap();
    private final List<Pair<String, String>> translations = new ArrayList<Pair<String, String>>();

    public AoAAbilityBuilder(RegistryObject<AoAAbility> ability) {
        this((AoAAbility)ability.get());
    }

    public AoAAbilityBuilder(AoAAbility ability) {
        this.id = AoARegistries.AOA_ABILITIES.getId(ability);
        this.levelReq(1);
    }

    public T uniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return (T)this;
    }

    public T levelReq(int level) {
        if (level <= 0 || level > 1000) {
            throw new IllegalArgumentException("Invalid level requirement, must be between 1 and 1000 (inclusive)");
        }
        return this.intProperty("level_req", level);
    }

    public T description(RegistryObject<AoASkill> parentSkill, String localeSubNodes, String translation) {
        return this.description((AoASkill)parentSkill.get(), localeSubNodes, translation);
    }

    public T description(AoASkill parentSkill, String localeSubNodes, String translation) {
        String locale = "skills.aoa3." + AoARegistries.AOA_SKILLS.getId(parentSkill).m_135815_() + ".abilities." + localeSubNodes + ".description";
        this.localeEntry(locale, translation);
        return this.stringProperty("description", locale);
    }

    public T localeEntry(String localeId, String translation) {
        this.translations.add((Pair<String, String>)Pair.of((Object)localeId, (Object)translation));
        return (T)this;
    }

    public boolean propertyExists(String id) {
        return this.properties.containsKey(id);
    }

    public T intProperty(String id, int value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return (T)this;
    }

    public T longProperty(String id, long value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return (T)this;
    }

    public T shortProperty(String id, short value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return (T)this;
    }

    public T floatProperty(String id, float value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)Float.valueOf(value)));
        return (T)this;
    }

    public T doubleProperty(String id, double value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return (T)this;
    }

    public T byteProperty(String id, byte value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return (T)this;
    }

    public T booleanProperty(String id, boolean value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
        return (T)this;
    }

    public T charProperty(String id, char value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(Character.valueOf(value)));
        return (T)this;
    }

    public T stringProperty(String id, String value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(value));
        return (T)this;
    }

    public T arrayProperty(String id, Collection<?> values) {
        this.properties.put(id, this.objectToJson(values));
        return (T)this;
    }

    public T mapProperty(String id, Map<String, ?> map) {
        this.properties.put(id, this.objectToJson(map));
        return (T)this;
    }

    private JsonElement objectToJson(Object obj) {
        if (obj instanceof Map) {
            JsonObject jsonObj = new JsonObject();
            ((Map)obj).keySet().stream().findFirst().ifPresent(key -> {
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Invalid key type for JSON object, must be string. " + obj);
                }
            });
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                jsonObj.add((String)entry.getKey(), this.objectToJson(entry.getValue()));
            }
            return jsonObj;
        }
        if (obj instanceof Collection) {
            JsonArray array = new JsonArray();
            for (Object value : (Collection)obj) {
                array.add(this.objectToJson(value));
            }
            return array;
        }
        if (obj instanceof Boolean) {
            return new JsonPrimitive((Boolean)obj);
        }
        if (obj instanceof Number) {
            return new JsonPrimitive((Number)obj);
        }
        if (obj instanceof String) {
            return new JsonPrimitive((String)obj);
        }
        if (obj instanceof Character) {
            return new JsonPrimitive((Character)obj);
        }
        throw new IllegalArgumentException("Invalid object type for JSON entry. " + obj.toString());
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<Pair<String, String>> getTranslations() {
        return this.translations;
    }

    public void finalize(ArrayList<AoAAbilityBuilder> skillsList) {
        skillsList.add(this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.uniqueId == null) {
            this.uniqueId = String.valueOf(this.hashCode());
        }
        json.addProperty("id", this.id.toString());
        json.addProperty("unique_id", this.uniqueId);
        for (Map.Entry<String, JsonElement> property : this.properties.entrySet()) {
            json.add(property.getKey(), property.getValue());
        }
        return json;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AoAAbilityBuilder other = (AoAAbilityBuilder)object;
        return this.id.equals((Object)other.id) && Objects.equals(this.uniqueId, other.uniqueId) && this.properties.equals(other.properties) && this.translations.equals(other.translations);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uniqueId, this.properties, this.translations);
    }
}

