/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.aoaplayer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.AdventOfAscension;

public class HaulingFishBuilder {
    private final ResourceLocation id;
    private final ArrayList<FishEntry> entities = new ArrayList();
    private final ArrayList<TagKey<Biome>> biomeTags = new ArrayList();
    private final ArrayList<ResourceKey<Biome>> biomes = new ArrayList();
    private boolean forLava = false;
    private boolean forTraps = false;

    public HaulingFishBuilder(String id) {
        this.id = AdventOfAscension.id(id);
    }

    public HaulingFishBuilder tags(TagKey<Biome> ... tags) {
        this.biomeTags.addAll(Arrays.asList(tags));
        return this;
    }

    public HaulingFishBuilder forLava() {
        this.forLava = true;
        return this;
    }

    public HaulingFishBuilder forTraps() {
        this.forTraps = true;
        return this;
    }

    public HaulingFishBuilder biomes(ResourceLocation ... biomes) {
        for (ResourceLocation biome : biomes) {
            this.biomes.add((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biome));
        }
        return this;
    }

    public HaulingFishBuilder biomes(RegistryObject<Biome> ... biomes) {
        for (RegistryObject<Biome> biome : biomes) {
            this.biomes.add((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biome.getId()));
        }
        return this;
    }

    public HaulingFishBuilder biomes(Biome ... biomes) {
        for (Biome biome : biomes) {
            this.biomes.add((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)ForgeRegistries.BIOMES.getKey((Object)biome)));
        }
        return this;
    }

    public HaulingFishBuilder entity(RegistryObject<EntityType<?>> entity) {
        return this.entity(entity, 1, 1);
    }

    public HaulingFishBuilder entity(RegistryObject<EntityType<?>> entity, int weight) {
        return this.entity(entity, weight, 1);
    }

    public HaulingFishBuilder entity(RegistryObject<EntityType<?>> entity, int weight, float weightMod) {
        return this.entity(entity, weight, weightMod, 1);
    }

    public HaulingFishBuilder entity(RegistryObject<EntityType<?>> entity, int weight, int level) {
        return this.entity((EntityType)entity.get(), weight, level);
    }

    public HaulingFishBuilder entity(RegistryObject<EntityType<?>> entity, int weight, float weightMod, int level) {
        return this.entity((EntityType)entity.get(), weight, weightMod, level);
    }

    public HaulingFishBuilder entity(EntityType<?> entity) {
        return this.entity(entity, 1, 1);
    }

    public HaulingFishBuilder entity(EntityType<?> entity, int weight) {
        return this.entity(entity, weight, 0.0f, 1);
    }

    public HaulingFishBuilder entity(EntityType<?> entity, int weight, float weightMod) {
        return this.entity(entity, weight, weightMod, 1);
    }

    public HaulingFishBuilder entity(EntityType<?> entity, int weight, int level) {
        return this.entity(entity, weight, 0.0f, level);
    }

    public HaulingFishBuilder entity(EntityType<?> entity, int weight, float weightMod, int level) {
        this.entities.add(new FishEntry(entity, weight, level, weightMod));
        return this;
    }

    public HaulingFishBuilder item(RegistryObject<Item> item) {
        return this.item(item, 1, 1);
    }

    public HaulingFishBuilder item(RegistryObject<Item> item, int weight) {
        return this.item(item, weight, 1);
    }

    public HaulingFishBuilder item(RegistryObject<Item> item, int weight, float weightMod) {
        return this.item(item, weight, weightMod, 1);
    }

    public HaulingFishBuilder item(RegistryObject<Item> item, int weight, int level) {
        return this.item((Item)item.get(), weight, level);
    }

    public HaulingFishBuilder item(RegistryObject<Item> item, int weight, float weightMod, int level) {
        return this.item((Item)item.get(), weight, weightMod, level);
    }

    public HaulingFishBuilder item(Item item) {
        return this.item(item, 1, 1);
    }

    public HaulingFishBuilder item(Item entity, int weight) {
        return this.item(entity, weight, 1);
    }

    public HaulingFishBuilder item(Item entity, int weight, float weightMod) {
        return this.item(entity, weight, weightMod, 1);
    }

    public HaulingFishBuilder item(Item item, int weight, int level) {
        return this.item(item, weight, 0.0f, level);
    }

    public HaulingFishBuilder item(Item item, int weight, float weightMod, int level) {
        this.entities.add(new FishEntry(item, weight, level, weightMod));
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void finalize(ArrayList<HaulingFishBuilder> list) {
        list.add(this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.forLava) {
            json.addProperty("for_lava", Boolean.valueOf(true));
        }
        if (this.forTraps) {
            json.addProperty("for_traps", Boolean.valueOf(true));
        }
        if (!this.biomeTags.isEmpty()) {
            JsonArray tagsArray = new JsonArray();
            for (TagKey<Biome> tagKey : this.biomeTags) {
                tagsArray.add(tagKey.f_203868_().toString());
            }
            json.add("tags", (JsonElement)tagsArray);
        }
        if (!this.biomes.isEmpty()) {
            JsonArray biomesArray = new JsonArray();
            for (ResourceKey resourceKey : this.biomes) {
                biomesArray.add(resourceKey.m_135782_().toString());
            }
            json.add("biomes", (JsonElement)biomesArray);
        }
        JsonArray entityList = new JsonArray();
        for (FishEntry fishEntry : this.entities) {
            JsonObject obj = new JsonObject();
            if (fishEntry.levelReq > 1) {
                obj.addProperty("level", (Number)fishEntry.levelReq);
            }
            if (fishEntry.weight > 1) {
                obj.addProperty("weight", (Number)fishEntry.weight);
            }
            if (fishEntry.weightMod != 0.0f) {
                obj.addProperty("weight_mod", (Number)Float.valueOf(fishEntry.weightMod));
            }
            obj.addProperty(fishEntry.type, fishEntry.registryEntry.toString());
            entityList.add((JsonElement)obj);
        }
        json.add("entities", (JsonElement)entityList);
        return json;
    }

    private static class FishEntry {
        private final String type;
        private final ResourceLocation registryEntry;
        private final int weight;
        private final int levelReq;
        private final float weightMod;

        private FishEntry(Item item, int weight, int levelReq, float weightMod) {
            this("item", ForgeRegistries.ITEMS.getKey((Object)item), weight, levelReq, weightMod);
        }

        private FishEntry(EntityType<?> entity, int weight, int levelReq, float weightMod) {
            this("entity", ForgeRegistries.ENTITIES.getKey(entity), weight, levelReq, weightMod);
        }

        private FishEntry(String type, ResourceLocation obj, int weight, int levelReq, float weightMod) {
            this.type = type;
            this.registryEntry = obj;
            this.weight = weight;
            this.levelReq = levelReq;
            this.weightMod = weightMod;
        }
    }
}

