/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.aoaplayer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.AoAAbilityBuilder;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.skill.AoASkill;

public class AoASkillBuilder {
    private final ResourceLocation id;
    private final HashMap<String, JsonElement> properties = new HashMap();
    private final ArrayList<AoAAbilityBuilder<?>> abilities = new ArrayList();

    public AoASkillBuilder(RegistryObject<AoASkill> skill) {
        this((AoASkill)skill.get());
    }

    public AoASkillBuilder(AoASkill skill) {
        this.id = AoARegistries.AOA_SKILLS.getId(skill);
        this.xpModifier(1.0f);
    }

    public AoASkillBuilder xpModifier(float modifier) {
        return this.floatProperty("xp_modifier", modifier);
    }

    public AoASkillBuilder abilities(AoAAbilityBuilder<?> ... abilities) {
        this.abilities.addAll(Arrays.asList(abilities));
        return this;
    }

    public AoASkillBuilder intProperty(String id, int value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoASkillBuilder longProperty(String id, long value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoASkillBuilder shortProperty(String id, short value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoASkillBuilder floatProperty(String id, float value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)Float.valueOf(value)));
        return this;
    }

    public AoASkillBuilder doubleProperty(String id, double value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoASkillBuilder byteProperty(String id, byte value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoASkillBuilder booleanProperty(String id, boolean value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
        return this;
    }

    public AoASkillBuilder charProperty(String id, char value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(Character.valueOf(value)));
        return this;
    }

    public AoASkillBuilder stringProperty(String id, String value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(value));
        return this;
    }

    public AoASkillBuilder arrayProperty(String id, Collection<?> values) {
        this.properties.put(id, this.objectToJson(values));
        return this;
    }

    public AoASkillBuilder mapProperty(String id, Map<String, ?> map) {
        this.properties.put(id, this.objectToJson(map));
        return this;
    }

    private JsonElement objectToJson(Object obj) {
        if (obj instanceof Map) {
            JsonObject jsonObj = new JsonObject();
            ((Map)obj).keySet().stream().findFirst().ifPresent(key -> {
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Invalid key type for JSON object, must be string. " + obj);
                }
            });
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                jsonObj.add((String)entry.getKey(), this.objectToJson(entry.getValue()));
            }
            return jsonObj;
        }
        if (obj instanceof Collection) {
            JsonArray array = new JsonArray();
            for (Object value : (Collection)obj) {
                array.add(this.objectToJson(value));
            }
            return array;
        }
        if (obj instanceof Boolean) {
            return new JsonPrimitive((Boolean)obj);
        }
        if (obj instanceof Number) {
            return new JsonPrimitive((Number)obj);
        }
        if (obj instanceof String) {
            return new JsonPrimitive((String)obj);
        }
        if (obj instanceof Character) {
            return new JsonPrimitive((Character)obj);
        }
        throw new IllegalArgumentException("Invalid object type for JSON entry. " + obj.toString());
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ArrayList<AoAAbilityBuilder<?>> getAbilities() {
        return this.abilities;
    }

    public void finalize(ArrayList<AoASkillBuilder> skillsList) {
        skillsList.add(this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray abilityArray = new JsonArray();
        for (Map.Entry<String, JsonElement> entry : this.properties.entrySet()) {
            json.add(entry.getKey(), entry.getValue());
        }
        for (AoAAbilityBuilder aoAAbilityBuilder : this.abilities) {
            abilityArray.add((JsonElement)aoAAbilityBuilder.toJson());
        }
        json.add("abilities", (JsonElement)abilityArray);
        return json;
    }
}

