/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder.aoaplayer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.resource.AoAResource;

public class AoAResourceBuilder {
    private final ResourceLocation id;
    private final HashMap<String, JsonElement> properties = new HashMap();

    public AoAResourceBuilder(AoAResource resource) {
        this.id = AoARegistries.AOA_RESOURCES.getId(resource);
    }

    public AoAResourceBuilder maxValue(float max) {
        this.properties.put("max_value", (JsonElement)new JsonPrimitive((Number)Float.valueOf(max)));
        return this;
    }

    public AoAResourceBuilder intProperty(String id, int value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoAResourceBuilder longProperty(String id, long value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoAResourceBuilder shortProperty(String id, short value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoAResourceBuilder floatProperty(String id, float value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)Float.valueOf(value)));
        return this;
    }

    public AoAResourceBuilder doubleProperty(String id, double value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoAResourceBuilder byteProperty(String id, byte value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive((Number)value));
        return this;
    }

    public AoAResourceBuilder booleanProperty(String id, boolean value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
        return this;
    }

    public AoAResourceBuilder charProperty(String id, char value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(Character.valueOf(value)));
        return this;
    }

    public AoAResourceBuilder stringProperty(String id, String value) {
        this.properties.put(id, (JsonElement)new JsonPrimitive(value));
        return this;
    }

    public AoAResourceBuilder arrayProperty(String id, Collection<?> values) {
        this.properties.put(id, this.objectToJson(values));
        return this;
    }

    public AoAResourceBuilder mapProperty(String id, Map<String, ?> map) {
        this.properties.put(id, this.objectToJson(map));
        return this;
    }

    private JsonElement objectToJson(Object obj) {
        if (obj instanceof Map) {
            JsonObject jsonObj = new JsonObject();
            ((Map)obj).keySet().stream().findFirst().ifPresent(key -> {
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Invalid key type for JSON object, must be string. " + obj);
                }
            });
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                jsonObj.add((String)entry.getKey(), this.objectToJson(entry.getValue()));
            }
            return jsonObj;
        }
        if (obj instanceof Collection) {
            JsonArray array = new JsonArray();
            for (Object value : (Collection)obj) {
                array.add(this.objectToJson(value));
            }
            return array;
        }
        if (obj instanceof Boolean) {
            return new JsonPrimitive((Boolean)obj);
        }
        if (obj instanceof Number) {
            return new JsonPrimitive((Number)obj);
        }
        if (obj instanceof String) {
            return new JsonPrimitive((String)obj);
        }
        if (obj instanceof Character) {
            return new JsonPrimitive((Character)obj);
        }
        throw new IllegalArgumentException("Invalid object type for JSON entry. " + obj.toString());
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void finalize(ArrayList<AoAResourceBuilder> resourcesList) {
        resourcesList.add(this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, JsonElement> property : this.properties.entrySet()) {
            json.add(property.getKey(), property.getValue());
        }
        return json;
    }
}

