/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.skill.AoASkill;

public class SkillReqBuilder {
    private final ResourceLocation itemId;
    @Nullable
    private SkillReqPredicateBuilder equipPredicate = null;
    @Nullable
    private SkillReqPredicateBuilder blockPlacePredicate = null;
    @Nullable
    private SkillReqPredicateBuilder blockBreakPredicate = null;
    @Nullable
    private SkillReqPredicateBuilder interactPredicate = null;

    public SkillReqBuilder(RegistryObject<? extends ItemLike> registryObject) {
        this(registryObject.getId());
    }

    public SkillReqBuilder(Item item) {
        this(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public SkillReqBuilder(Block block) {
        this(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public SkillReqBuilder(ResourceLocation itemId) {
        this.itemId = itemId;
    }

    public SkillReqPredicateBuilder forEquipping() {
        this.equipPredicate = new SkillReqPredicateBuilder(this);
        return this.equipPredicate;
    }

    public SkillReqPredicateBuilder forBlockPlacing() {
        this.blockPlacePredicate = new SkillReqPredicateBuilder(this);
        return this.blockPlacePredicate;
    }

    public SkillReqPredicateBuilder forBlockBreaking() {
        this.blockBreakPredicate = new SkillReqPredicateBuilder(this);
        return this.blockBreakPredicate;
    }

    public SkillReqPredicateBuilder forInteracting() {
        this.interactPredicate = new SkillReqPredicateBuilder(this);
        return this.interactPredicate;
    }

    public ResourceLocation getId() {
        return this.itemId;
    }

    public void finalize(ArrayList<SkillReqBuilder> list) {
        list.add(this);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (this.equipPredicate != null) {
            obj.add("equip", this.equipPredicate.toJson());
        }
        if (this.blockPlacePredicate != null) {
            obj.add("place_block", this.blockPlacePredicate.toJson());
        }
        if (this.blockBreakPredicate != null) {
            obj.add("break_block", this.blockBreakPredicate.toJson());
        }
        if (this.interactPredicate != null) {
            obj.add("interact_with", this.interactPredicate.toJson());
        }
        return obj;
    }

    public static class SkillReqPredicateBuilder {
        private final SkillReqBuilder reqBuilder;
        private final ArrayList<Pair<AoASkill, Integer>> reqs = new ArrayList();

        private SkillReqPredicateBuilder(SkillReqBuilder reqBuilder) {
            this.reqBuilder = reqBuilder;
        }

        public SkillReqPredicateBuilder skillReq(RegistryObject<AoASkill> skill, int level) {
            return this.skillReq((AoASkill)skill.get(), level);
        }

        public SkillReqPredicateBuilder skillReq(AoASkill skill, int level) {
            this.reqs.add((Pair<AoASkill, Integer>)Pair.of((Object)skill, (Object)level));
            return this;
        }

        public void finalize(ArrayList<SkillReqBuilder> list) {
            this.reqBuilder.finalize(list);
        }

        private JsonElement toJson() {
            if (this.reqs.size() > 1) {
                JsonArray json = new JsonArray();
                for (Pair<AoASkill, Integer> req : this.reqs) {
                    JsonObject reqObj = new JsonObject();
                    reqObj.addProperty("skill", AoARegistries.AOA_SKILLS.getId((AoASkill)req.getFirst()).toString());
                    reqObj.addProperty("level", (Number)req.getSecond());
                    json.add((JsonElement)reqObj);
                }
                return json;
            }
            if (this.reqs.size() == 1) {
                JsonObject json = new JsonObject();
                Pair<AoASkill, Integer> req = this.reqs.get(0);
                json.addProperty("skill", AoARegistries.AOA_SKILLS.getId((AoASkill)req.getFirst()).toString());
                json.addProperty("level", (Number)req.getSecond());
                return json;
            }
            return new JsonObject();
        }
    }
}

