/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder;

import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;

public class CompactBlockModelBuilder<B extends Block>
extends BlockModelBuilder {
    private final BlockStateProvider stateProvider;
    private final B block;

    public CompactBlockModelBuilder(BlockStateProvider stateProvider, B block, String pathExtension, boolean skipTextures) {
        super(new ResourceLocation("aoa3", stateProvider.blockTexture(block).m_135815_() + pathExtension), stateProvider.models().existingFileHelper);
        stateProvider.models().existingFileHelper.trackGenerated(this.getModelPath(), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".json", "models"));
        stateProvider.models().generatedModels.putIfAbsent(this.getModelPath(), this);
        this.parent((ModelFile)stateProvider.models().getExistingFile(stateProvider.mcLoc("block/block")));
        this.stateProvider = stateProvider;
        this.block = block;
        if (!skipTextures) {
            this.texture("texture", this.getModelPath());
            this.texture("particle", this.getModelPath());
        }
    }

    public CompactBlockModelBuilder(BlockStateProvider stateProvider, B block, String pathExtension) {
        this(stateProvider, block, pathExtension, false);
    }

    public CompactBlockModelBuilder(BlockStateProvider stateProvider, B block) {
        this(stateProvider, block, "");
    }

    public CompactBlockModelBuilder(BlockStateProvider stateProvider, DataGenBlockPackage blockPackage, boolean skipTextures) {
        this(stateProvider, blockPackage.getBlock(), "", skipTextures);
    }

    public CompactBlockModelBuilder(BlockStateProvider stateProvider, RegistryObject<B> block) {
        this(stateProvider, (Block)block.get());
    }

    public CompactBlockModelBuilder(BlockStateProvider stateProvider, DataGenBlockPackage blockPackage) {
        this(stateProvider, blockPackage.getBlock());
    }

    public B getBlock() {
        return this.block;
    }

    public ResourceLocation getModelPath() {
        return this.getLocation();
    }

    public BlockModelBuilder texture(String key, String texture) {
        if (texture.charAt(0) == '#') {
            this.textures.put(key, texture);
            return this;
        }
        ResourceLocation asLoc = texture.contains(":") ? new ResourceLocation(texture) : new ResourceLocation(this.getLocation().m_135827_(), texture);
        return this.texture(key, asLoc);
    }

    public BlockModelBuilder texture(String key, ResourceLocation texture) {
        this.textures.put(key, texture.toString());
        return this;
    }

    public CompactBlockModelBuilder<B> defaultTextureRef(String ref) {
        this.textures.remove("texture");
        this.texture(ref, this.getModelPath());
        return this;
    }

    public CompactBlockModelBuilder<B> setTexture(String key, ResourceLocation texture) {
        this.texture(key, texture);
        return this;
    }

    public CompactBlockModelBuilder<B> matchTextures(String key, String existing) {
        this.texture(key, (String)this.textures.get(existing));
        return this;
    }

    public CompactBlockModelBuilder<B> vanillaParent(String parentName) {
        this.parent((ModelFile)this.stateProvider.models().getExistingFile(this.stateProvider.mcLoc("block/" + parentName)));
        return this;
    }

    public CompactBlockModelBuilder<B> modParent(String parentName) {
        this.parent((ModelFile)this.stateProvider.models().getExistingFile(this.stateProvider.modLoc("block/" + parentName)));
        return this;
    }

    public CompactBlockModelBuilder<B> parent(String parentName) {
        return this.vanillaParent(parentName);
    }

    public CompactBlockModelBuilder<B> noOcclusion() {
        this.ao(false);
        return this;
    }

    public VariantBlockStateBuilder stateBuilder() {
        return this.stateProvider.getVariantBuilder(this.block);
    }

    public MultiPartBlockStateBuilder multiPartStateBuilder() {
        return this.stateProvider.getMultipartBuilder(this.block);
    }

    public CompactBlockModelBuilder<B> simpleBlockState() {
        this.stateBuilder().partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this)});
        return this;
    }

    public ItemModelBuilder itemModel() {
        return (ItemModelBuilder)((ItemModelBuilder)this.stateProvider.itemModels().getBuilder(ForgeRegistries.BLOCKS.getKey(this.block).toString())).parent((ModelFile)this);
    }

    public CompactElementBuilder newPart() {
        return new CompactElementBuilder(this);
    }

    public class CompactElementBuilder {
        private final CompactBlockModelBuilder<?> modelBuilder;
        private final ModelBuilder.ElementBuilder elementBuilder;

        protected CompactElementBuilder(CompactBlockModelBuilder<?> modelBuilder) {
            this.modelBuilder = modelBuilder;
            this.elementBuilder = modelBuilder.element();
        }

        public CompactElementBuilder from(float minX, float minY, float minZ) {
            this.elementBuilder.from(minX, minY, minZ);
            return this;
        }

        public CompactElementBuilder to(float maxX, float maxY, float maxZ) {
            this.elementBuilder.to(maxX, maxY, maxZ);
            return this;
        }

        public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder side(Direction face) {
            return new CompactFaceBuilder(face, this);
        }

        public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder northFace() {
            return this.side(Direction.NORTH);
        }

        public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder southFace() {
            return this.side(Direction.SOUTH);
        }

        public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder eastFace() {
            return this.side(Direction.EAST);
        }

        public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder westFace() {
            return this.side(Direction.WEST);
        }

        public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder upFace() {
            return this.side(Direction.UP);
        }

        public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder downFace() {
            return this.side(Direction.DOWN);
        }

        public class CompactFaceBuilder {
            private final Direction direction;
            private final ModelBuilder.FaceBuilder facebuilder;

            protected CompactFaceBuilder(Direction face, CompactElementBuilder elementBuilder) {
                this.facebuilder = elementBuilder.elementBuilder.face(face);
                this.direction = face;
                this.facebuilder.texture("#texture");
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder texture(String texture) {
                this.facebuilder.texture(texture);
                return this;
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder noTexture() {
                this.facebuilder.texture(MissingTextureAtlasSprite.m_118071_().toString());
                return this;
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder uv(float uStart, float vStart, float uEnd, float vEnd) {
                this.facebuilder.uvs(uStart, vStart, uEnd, vEnd);
                return this;
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder rotateLeft() {
                return this.rotate(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90);
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder rotateRight() {
                return this.rotate(ModelBuilder.FaceRotation.CLOCKWISE_90);
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder flipUpsideDown() {
                return this.rotate(ModelBuilder.FaceRotation.UPSIDE_DOWN);
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder rotate(ModelBuilder.FaceRotation rotation) {
                this.facebuilder.rotation(rotation);
                return this;
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder tint(int index) {
                this.facebuilder.tintindex(index);
                return this;
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder skipRenderIfTouching(Direction direction) {
                this.facebuilder.cullface(direction);
                return this;
            }

            public net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder$CompactElementBuilder.CompactFaceBuilder autoCull() {
                return this.skipRenderIfTouching(this.direction);
            }
        }
    }
}

