/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemDurabilityTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advancement.trigger.AoACycleTrigger;
import net.tslat.aoa3.advancement.trigger.AoALevelUpTrigger;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.block.functional.misc.TrophyBlock;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.StringUtil;

public class AdvancementBuilder {
    private Advancement builtAdvancement = null;
    @Nullable
    private AdvancementBuilder parentAdvancement = null;
    protected List<AdvancementBuilder> childAdvancements = null;
    @Nullable
    private final ResourceLocation thirdPartyParent;
    private String category;
    private final String id;
    private final ItemLike icon;
    private final ResourceLocation background;
    private String title = null;
    private ChatFormatting colour = null;
    private String description = null;
    private ChatFormatting descriptionColour = null;
    private FrameType type = FrameType.TASK;
    private boolean announce = false;
    private boolean hideToast = false;
    private boolean hidden = false;
    private RequirementsStrategy requirementType = RequirementsStrategy.f_15978_;
    private HashMap<String, CriterionTriggerInstance> requirements = new HashMap();

    public AdvancementBuilder(ArrayList<AdvancementBuilder> advancementsList, String category, ItemLike icon, Block background) {
        this(advancementsList, category, "root", icon, new ResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)background).m_135827_(), "textures/block/" + ForgeRegistries.BLOCKS.getKey((Object)background).m_135815_() + ".png"));
    }

    public AdvancementBuilder(ArrayList<AdvancementBuilder> advancementsList, String category, String id, ItemLike icon, @Nullable ResourceLocation background) {
        this.category = category;
        this.id = id;
        this.icon = icon;
        this.background = background;
        this.thirdPartyParent = null;
        advancementsList.add(this);
    }

    public AdvancementBuilder(ArrayList<AdvancementBuilder> advancementsList, ResourceLocation parent, String category, String id, ItemLike icon) {
        this.thirdPartyParent = parent;
        this.category = category;
        this.id = id;
        this.icon = icon;
        this.background = null;
        advancementsList.add(this);
    }

    public AdvancementBuilder(String id, ItemLike icon) {
        this.category = null;
        this.id = id;
        this.icon = icon;
        this.background = null;
        this.thirdPartyParent = null;
    }

    public Advancement getBuiltAdvancement() {
        return this.builtAdvancement;
    }

    @Nullable
    public List<AdvancementBuilder> getChildAdvancements() {
        return this.childAdvancements;
    }

    public AdvancementBuilder translations(String title, String description) {
        this.title = title;
        this.description = description;
        return this;
    }

    public AdvancementBuilder colours(ChatFormatting titleColour, ChatFormatting descriptionColour) {
        this.colour = titleColour;
        this.descriptionColour = descriptionColour;
        return this;
    }

    public AdvancementBuilder type(FrameType type) {
        this.type = type;
        return this;
    }

    public AdvancementBuilder announce() {
        this.announce = true;
        return this;
    }

    public AdvancementBuilder hideToast() {
        this.hideToast = true;
        return this;
    }

    public AdvancementBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public AdvancementBuilder requireAnyCondition() {
        this.requirementType = RequirementsStrategy.f_15979_;
        return this;
    }

    public AdvancementBuilder useItem(EntityPredicate userPredicate, Item item) {
        this.requirements.put("use_" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), (CriterionTriggerInstance)ItemDurabilityTrigger.TriggerInstance.m_43694_((EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)userPredicate), (ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_(), (MinMaxBounds.Ints)MinMaxBounds.Ints.f_55364_));
        return this;
    }

    public AdvancementBuilder obtainTrophy(EntityType<?> entity, Block trophyBlock) {
        this.requirements.put("obtain_" + ForgeRegistries.BLOCKS.getKey((Object)trophyBlock).m_135815_().replace("trophy", ForgeRegistries.ENTITIES.getKey(entity).m_135815_() + "_trophy"), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(null, Set.of(trophyBlock.m_5456_()), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, new NbtPredicate(TrophyBlock.getOriginalTrophyTag(entity, trophyBlock)))}));
        return this;
    }

    public AdvancementBuilder obtainItem(ItemLike item) {
        this.requirements.put("obtain_" + ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public AdvancementBuilder killEntity(String criteriaName, EntityPredicate playerPredicate, EntityPredicate targetPredicate, DamageSourcePredicate damagePredicate) {
        this.requirements.put(criteriaName, (CriterionTriggerInstance)new KilledTrigger.TriggerInstance(CriteriaTriggers.f_10568_.m_7295_(), EntityPredicate.Composite.m_36673_((EntityPredicate)playerPredicate), EntityPredicate.Composite.m_36673_((EntityPredicate)targetPredicate), damagePredicate));
        return this;
    }

    public AdvancementBuilder killEntity(EntityType<?> entity) {
        this.requirements.put("kill_" + ForgeRegistries.ENTITIES.getKey(entity).m_135815_(), (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)new EntityPredicate.Builder().m_36636_(entity)));
        return this;
    }

    public AdvancementBuilder levelUp(@Nullable AoASkill skill, int level) {
        this.requirements.put((String)(skill == null ? "level_" : AoARegistries.AOA_SKILLS.getId(skill).toString() + "_level_") + level, (CriterionTriggerInstance)new AoALevelUpTrigger.Instance(skill, level));
        return this;
    }

    public AdvancementBuilder cycleSkill(@Nullable AoASkill skill, int cycle) {
        this.requirements.put((String)(skill == null ? "cycle_" : AoARegistries.AOA_SKILLS.getId(skill).toString() + "_cycle") + cycle, (CriterionTriggerInstance)new AoACycleTrigger.Instance(skill, cycle));
        return this;
    }

    public AdvancementBuilder specialTrigger(String criteriaName) {
        assert (StringUtil.isSnakeCase(criteriaName));
        this.requirements.put(criteriaName, (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
        return this;
    }

    public AdvancementBuilder dimensionChange(ResourceKey<Level> toDimension) {
        this.requirements.put("access_dim_" + toDimension.m_135782_().m_135815_(), (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_(toDimension));
        return this;
    }

    public AdvancementBuilder enterBlock(Block block) {
        this.requirements.put("enter_block_" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)block));
        return this;
    }

    public AdvancementBuilder consumeItem(ItemLike item) {
        this.requirements.put("consume_" + ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)item));
        return this;
    }

    public AdvancementBuilder location(String criteraName, LocationPredicate location) {
        this.requirements.put(criteraName, (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)location));
        return this;
    }

    public AdvancementBuilder hurtEntity(String criteriaName, EntityPredicate playerPredicate, EntityPredicate entityPredicate, DamagePredicate damagePredicate) {
        this.requirements.put(criteriaName, (CriterionTriggerInstance)new PlayerHurtEntityTrigger.TriggerInstance(EntityPredicate.Composite.m_36673_((EntityPredicate)playerPredicate), damagePredicate, EntityPredicate.Composite.m_36673_((EntityPredicate)entityPredicate)));
        return this;
    }

    public AdvancementBuilder children(AdvancementBuilder ... childAdvancements) {
        this.childAdvancements = Arrays.asList(childAdvancements);
        for (AdvancementBuilder adv : childAdvancements) {
            this.applyChildAdvancements(this, adv);
        }
        return this;
    }

    public void applyChildAdvancements(AdvancementBuilder parent, AdvancementBuilder adv) {
        adv.parentAdvancement = parent;
        adv.category = parent.category;
        if (adv.childAdvancements != null) {
            for (AdvancementBuilder child : adv.childAdvancements) {
                this.applyChildAdvancements(adv, child);
            }
        }
    }

    public Advancement build(Consumer<Advancement> writer) {
        Advancement parent = null;
        if (this.parentAdvancement != null) {
            parent = this.parentAdvancement.builtAdvancement;
        }
        MutableComponent title = Component.m_237115_((String)("advancements.aoa3." + this.category + "." + this.id + ".title"));
        MutableComponent description = Component.m_237115_((String)("advancements.aoa3." + this.category + "." + this.id + ".description"));
        if (this.colour != null) {
            title.m_130940_(this.colour);
        }
        if (this.descriptionColour != null) {
            description.m_130940_(this.descriptionColour);
        }
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        if (this.thirdPartyParent != null) {
            builder.m_138396_(this.thirdPartyParent);
        } else {
            builder.m_138398_(parent);
        }
        builder.m_138371_(this.icon, (Component)title, (Component)description, this.background, this.type, !this.hideToast, this.announce, this.hidden);
        this.requirements.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).m_138386_(arg_0, arg_1));
        builder.m_138360_(this.requirementType);
        if (this.thirdPartyParent != null) {
            this.builtAdvancement = new Advancement(new ResourceLocation("aoa3", this.category + "/" + this.id), new Advancement(this.thirdPartyParent, null, null, AdvancementRewards.f_9978_, new HashMap(), (String[][])new String[0][]), new DisplayInfo(new ItemStack((ItemLike)this.icon.m_5456_()), (Component)title, (Component)description, this.background, this.type, !this.hideToast, this.announce, this.hidden), AdvancementRewards.f_9978_, builder.m_138405_(), this.requirementType.m_15985_(builder.m_138405_().keySet()));
            writer.accept(this.builtAdvancement);
        } else {
            this.builtAdvancement = builder.m_138389_(writer, "aoa3:" + this.category + "/" + this.id);
        }
        if (this.childAdvancements != null) {
            for (AdvancementBuilder adv : this.childAdvancements) {
                adv.build(writer);
            }
        }
        return this.builtAdvancement;
    }

    public String getTitleLangKey() {
        return ((TranslatableContents)this.builtAdvancement.m_138320_().m_14977_().m_214077_()).m_237508_();
    }

    public String getDescriptionLangKey() {
        return ((TranslatableContents)this.builtAdvancement.m_138320_().m_14985_().m_214077_()).m_237508_();
    }

    public String getTitle() {
        Objects.requireNonNull(this.title);
        return this.title;
    }

    public String getDescription() {
        Objects.requireNonNull(this.description);
        return this.description;
    }
}

