/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.datagen.DataGenBlocks;
import net.tslat.aoa3.advent.datagen.DataGenItems;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.advent.datagen.packages.DataGenItemPackage;
import net.tslat.aoa3.common.registration.AoABannerPatterns;
import net.tslat.aoa3.common.registration.AoATags;

public final class DataGenTags {
    private static BlockTagsProvider BLOCK_TAGS_PROVIDER;

    public static final class BannerPatterns
    extends BannerPatternTagsProvider {
        private final ArrayList<Consumer<BannerPatterns>> additionalTags = new ArrayList();

        public BannerPatterns(DataGenerator generator, ExistingFileHelper fileHelper) {
            super(generator, "aoa3", fileHelper);
        }

        public void addTag(Consumer<BannerPatterns> tagAdder) {
            this.additionalTags.add(tagAdder);
        }

        public TagsProvider.TagAppender<BannerPattern> m_206424_(TagKey<BannerPattern> pTag) {
            return super.m_206424_(pTag);
        }

        protected void m_6577_() {
            for (Consumer<BannerPatterns> tagAdder : this.additionalTags) {
                tagAdder.accept(this);
            }
            this.registerVanillaTags();
        }

        private void registerVanillaTags() {
            this.m_206424_(AoABannerPatterns.COMPASS_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.COMPASS_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.DISTORTION_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.DISTORTION_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.ENERGY_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.ENERGY_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.FIRE_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.FIRE_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.KINETIC_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.KINETIC_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.LIFE_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.LIFE_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.LUNAR_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.LUNAR_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.POISON_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.POISON_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.POWER_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.POWER_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.STORM_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.STORM_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.STRIKE_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.STRIKE_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.WATER_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.WATER_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.WIND_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.WIND_RUNE.pattern().get()));
            this.m_206424_(AoABannerPatterns.WITHER_RUNE.tag()).m_126582_((Object)((BannerPattern)AoABannerPatterns.WITHER_RUNE.pattern().get()));
        }
    }

    public static final class ConfiguredStructures
    extends StructureTagsProvider {
        private final ArrayList<Consumer<ConfiguredStructures>> additionalTags = new ArrayList();

        public ConfiguredStructures(DataGenerator generator, ExistingFileHelper fileHelper) {
            super(generator, "aoa3", fileHelper);
        }

        public void addTag(Consumer<ConfiguredStructures> tagAdder) {
            this.additionalTags.add(tagAdder);
        }

        public TagsProvider.TagAppender<Structure> m_206424_(TagKey<Structure> pTag) {
            return super.m_206424_(pTag);
        }

        protected void m_6577_() {
            for (Consumer<ConfiguredStructures> tagAdder : this.additionalTags) {
                tagAdder.accept(this);
            }
            this.registerVanillaTags();
        }

        private void registerVanillaTags() {
        }
    }

    public static final class Biomes
    extends BiomeTagsProvider {
        private final ArrayList<Consumer<Biomes>> additionalTags = new ArrayList();

        public Biomes(DataGenerator generator, ExistingFileHelper fileHelper) {
            super(generator, "aoa3", fileHelper);
        }

        public void addTag(Consumer<Biomes> tagAdder) {
            this.additionalTags.add(tagAdder);
        }

        public TagsProvider.TagAppender<Biome> m_206424_(TagKey<Biome> pTag) {
            return super.m_206424_(pTag);
        }

        protected void m_6577_() {
            for (Consumer<Biomes> tagAdder : this.additionalTags) {
                tagAdder.accept(this);
            }
            this.registerVanillaTags();
        }

        private void registerVanillaTags() {
            this.m_206424_(AoATags.Biomes.HAS_RUINED_TELEPORTER).m_206428_(BiomeTags.f_207596_);
        }
    }

    public static final class Items
    extends ItemTagsProvider {
        private final ArrayList<Consumer<Items>> additionalTags = new ArrayList();

        public Items(DataGenerator generator, ExistingFileHelper fileHelper) {
            super(generator, BLOCK_TAGS_PROVIDER, "aoa3", fileHelper);
        }

        public void addTag(Consumer<Items> tagAdder) {
            this.additionalTags.add(tagAdder);
        }

        public TagsProvider.TagAppender<Item> m_206424_(TagKey<Item> pTag) {
            return super.m_206424_(pTag);
        }

        protected void m_6577_() {
            for (DataGenBlockPackage dataGenBlockPackage : DataGenBlocks.BLOCKS) {
                for (TagKey<Item> tag : dataGenBlockPackage.getItemTags()) {
                    this.m_206424_(tag).m_126582_((Object)dataGenBlockPackage.getItem());
                }
            }
            for (DataGenItemPackage dataGenItemPackage : DataGenItems.ITEMS) {
                for (TagKey<Item> tag : dataGenItemPackage.getItemTags()) {
                    this.m_206424_(tag).m_126582_((Object)dataGenItemPackage.getItem());
                }
            }
            for (Consumer consumer : this.additionalTags) {
                consumer.accept(this);
            }
            this.registerVanillaItemTags();
        }

        private void registerVanillaItemTags() {
            this.m_206424_(AoATags.Items.GRASS).m_126582_((Object)net.minecraft.world.item.Items.f_42276_);
            this.m_206424_(AoATags.Items.SWORDS).m_126584_((Object[])new Item[]{net.minecraft.world.item.Items.f_42420_, net.minecraft.world.item.Items.f_42425_, net.minecraft.world.item.Items.f_42383_, net.minecraft.world.item.Items.f_42430_, net.minecraft.world.item.Items.f_42388_, net.minecraft.world.item.Items.f_42393_});
            this.m_206424_(AoATags.Items.RAWFISH).m_126584_((Object[])new Item[]{net.minecraft.world.item.Items.f_42526_, net.minecraft.world.item.Items.f_42527_, net.minecraft.world.item.Items.f_42529_, net.minecraft.world.item.Items.f_42528_});
            this.m_206424_(AoATags.Items.SHULKER_BOXES).m_126584_((Object[])new Item[]{net.minecraft.world.item.Items.f_42265_, net.minecraft.world.item.Items.f_42229_, net.minecraft.world.item.Items.f_42225_, net.minecraft.world.item.Items.f_42226_, net.minecraft.world.item.Items.f_42275_, net.minecraft.world.item.Items.f_42273_, net.minecraft.world.item.Items.f_42227_, net.minecraft.world.item.Items.f_42269_, net.minecraft.world.item.Items.f_42274_, net.minecraft.world.item.Items.f_42271_, net.minecraft.world.item.Items.f_42268_, net.minecraft.world.item.Items.f_42267_, net.minecraft.world.item.Items.f_42272_, net.minecraft.world.item.Items.f_42224_, net.minecraft.world.item.Items.f_42228_, net.minecraft.world.item.Items.f_42266_, net.minecraft.world.item.Items.f_42270_});
            this.m_206424_((TagKey<Item>)Tags.Items.RODS).addTags(new TagKey[]{AoATags.Items.RODS_METAL});
            this.m_206424_((TagKey<Item>)Tags.Items.RAW_MATERIALS).m_206428_(AoATags.Items.RAW_MATERIALS_LIMONITE);
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!item.m_41472_() || !ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals("minecraft")) continue;
                this.m_206424_(AoATags.Items.FOOD).m_126582_((Object)item);
            }
        }
    }

    public static final class Fluids
    extends FluidTagsProvider {
        private final ArrayList<Consumer<Fluids>> additionalTags = new ArrayList();

        public Fluids(DataGenerator generator, ExistingFileHelper fileHelper) {
            super(generator, "aoa3", fileHelper);
        }

        public void addTag(Consumer<Fluids> tagAdder) {
            this.additionalTags.add(tagAdder);
        }

        public TagsProvider.TagAppender<Fluid> m_206424_(TagKey<Fluid> pTag) {
            return super.m_206424_(pTag);
        }

        protected void m_6577_() {
            for (DataGenBlockPackage dataGenBlockPackage : DataGenBlocks.BLOCKS) {
                TagKey<Fluid>[] fluidTags = dataGenBlockPackage.getFluidTags();
                if (fluidTags.length <= 0) continue;
                FlowingFluid fluid = ((LiquidBlock)dataGenBlockPackage.getBlock()).getFluid();
                for (TagKey<Fluid> tag : fluidTags) {
                    TagsProvider.TagAppender<Fluid> builder = this.m_206424_(tag);
                    if (fluid instanceof ForgeFlowingFluid) {
                        builder.m_126582_((Object)((ForgeFlowingFluid)fluid).m_5613_());
                        builder.m_126582_((Object)((ForgeFlowingFluid)fluid).m_5615_());
                        continue;
                    }
                    builder.m_126582_((Object)fluid);
                }
            }
            for (Consumer consumer : this.additionalTags) {
                consumer.accept(this);
            }
        }
    }

    public static final class Blocks
    extends BlockTagsProvider {
        private final ArrayList<Consumer<Blocks>> additionalTags = new ArrayList();

        public Blocks(DataGenerator generator, ExistingFileHelper fileHelper) {
            super(generator, "aoa3", fileHelper);
            BLOCK_TAGS_PROVIDER = this;
        }

        public void addTag(Consumer<Blocks> tagAdder) {
            this.additionalTags.add(tagAdder);
        }

        public TagsProvider.TagAppender<Block> m_206424_(TagKey<Block> pTag) {
            return super.m_206424_(pTag);
        }

        protected void m_6577_() {
            for (DataGenBlockPackage dataGenBlockPackage : DataGenBlocks.BLOCKS) {
                for (TagKey<Block> tag : dataGenBlockPackage.getBlockTags()) {
                    this.m_206424_(tag).m_126582_((Object)dataGenBlockPackage.getBlock());
                }
            }
            for (Consumer consumer : this.additionalTags) {
                consumer.accept(this);
            }
            this.registerVanillaBlockTags();
        }

        private void registerVanillaBlockTags() {
            TagsProvider.TagAppender<Block> grassTag = this.m_206424_(AoATags.Blocks.GRASS);
            TagsProvider.TagAppender<Block> mushroomTag = this.m_206424_(AoATags.Blocks.MUSHROOMS);
            grassTag.m_126582_((Object)net.minecraft.world.level.block.Blocks.f_50440_);
            mushroomTag.m_126582_((Object)net.minecraft.world.level.block.Blocks.f_50072_);
            mushroomTag.m_126582_((Object)net.minecraft.world.level.block.Blocks.f_50073_);
            mushroomTag.m_126582_((Object)net.minecraft.world.level.block.Blocks.f_50691_);
            mushroomTag.m_126582_((Object)net.minecraft.world.level.block.Blocks.f_50700_);
        }
    }
}

