/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeMod;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.AoAResourceBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.AoASkillBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.AoAAbilityBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.AttributeModificationBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.AutoEnchantCraftingBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.BlockConversionBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.BonusCraftingOutputBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.BowDamageIncreaseBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.DoubleJumpBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.EntityTagDamageBonusBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.FallDamageReductionBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.FishingXpBoostBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.HarvestSpeedBoostBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.HoeAreaHarvestBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.InnervationDodgeBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.InnervationMobLureBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.JumpBoostBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.LevelRestrictionBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.OneShotDamageLimiterBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.PotionDurationReducerBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.ScalableModAbilityBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.StunStrikeBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.VulcaneDamageIncreaseBuilder;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.player.resource.AoAResource;
import org.apache.logging.log4j.Level;

public class DataGenPlayerStats
implements DataProvider {
    protected static final ArrayList<AoAResourceBuilder> RESOURCES = new ArrayList();
    protected static final ArrayList<AoASkillBuilder> SKILLS = new ArrayList();
    private final DataGenerator generator;

    public DataGenPlayerStats(DataGenerator generator) {
        this.generator = generator;
    }

    private void registerResources() {
        new AoAResourceBuilder((AoAResource)AoAResources.SPIRIT.get()).maxValue(200.0f).floatProperty("regen_per_damage", 0.75f).floatProperty("inverse_health_regen_mod", 3.0f).floatProperty("regen_per_tick", 0.04f).finalize(RESOURCES);
        new AoAResourceBuilder((AoAResource)AoAResources.RAGE.get()).maxValue(100.0f).floatProperty("per_tick_drain", 0.01f).finalize(RESOURCES);
        new AoAResourceBuilder((AoAResource)AoAResources.ENERGY.get()).maxValue(100.0f).intProperty("delay_on_empty", 100).intProperty("delay_on_hit", 40).floatProperty("regen_per_tick", 0.3f).finalize(RESOURCES);
    }

    private void registerAlchemy() {
        new AoASkillBuilder(AoASkills.ALCHEMY).abilities(new AoAAbilityBuilder[0]).finalize(SKILLS);
    }

    private void registerCreation() {
        new AoASkillBuilder(AoASkills.CREATION).abilities(new AoAAbilityBuilder[0]).finalize(SKILLS);
    }

    private void registerDexterity() {
        new AoASkillBuilder(AoASkills.DEXTERITY).abilities(new AttributeModificationBuilder(Attributes.f_22279_).levelReq(5).perLevelMod(0.002f).operation(AttributeModifier.Operation.MULTIPLY_BASE), new FallDamageReductionBuilder().levelReq(15).perLevelMod(0.0085f).maxHeight(10), new JumpBoostBuilder().levelReq(25).baseValue(0.25f).perLevelMod(0.004f), new AttributeModificationBuilder(Attributes.f_22279_).levelReq(40).baseValue(0.05f).operation(AttributeModifier.Operation.MULTIPLY_BASE), new AttributeModificationBuilder((Attribute)ForgeMod.SWIM_SPEED.get()).levelReq(50).perLevelMod(0.003f).operation(AttributeModifier.Operation.MULTIPLY_BASE), new FallDamageReductionBuilder().levelReq(60).perLevelMod(0.005f).minHeight(11), new JumpBoostBuilder().levelReq(70).amplifyLateralVelocity().baseValue(0.25f), new AttributeModificationBuilder(Attributes.f_22279_).levelReq(80).baseValue(0.05f).operation(AttributeModifier.Operation.MULTIPLY_BASE), ((DoubleJumpBuilder)new DoubleJumpBuilder().levelReq(90)).energyConsumption(20.0f), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoAArmour.HELM_OF_THE_DEXTROUS).levelReq(100)).restrictEquipping()).finalize(SKILLS);
    }

    private void registerEngineering() {
        new AoASkillBuilder(AoASkills.ENGINEERING).abilities(new AoAAbilityBuilder[0]).finalize(SKILLS);
    }

    private void registerExtraction() {
        new AoASkillBuilder(AoASkills.EXTRACTION).abilities(new AoAAbilityBuilder[]{((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.BONUS_MINING_RESULT).levelReq(6)).baseValue(0.4f), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.HARD_BLOCK_SPEED_INCREASE).levelReq(10)).perLevelMod(0.02f), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.BONUS_SMELT_RESULT).levelReq(16)).baseValue(0.5f), ((HarvestSpeedBoostBuilder)new HarvestSpeedBoostBuilder().levelReq(25)).energyDrain(1.7f).costReduction(0.0135f).speedBoost(2.5f), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.BONUS_MINING_RESULT).levelReq(32)).baseValue(0.4f), new BonusCraftingOutputBuilder().tag((TagKey<Item>)ItemTags.f_13168_).baseValue(0.5f).levelReq(39), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.BONUS_SMELT_RESULT).levelReq(48)).baseValue(0.5f), ((AutoEnchantCraftingBuilder)new AutoEnchantCraftingBuilder().levelReq(55)).enchant(Enchantments.f_44987_, 3).enchant(Enchantments.f_44986_, 3), new BonusCraftingOutputBuilder().item(Items.f_42000_).baseValue(0.5f).levelReq(62), new AoAAbilityBuilder(AoAAbilities.AUTO_HARVESTING_TRASH).levelReq(74), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.BONUS_SMELT_RESULT).levelReq(82)).baseValue(0.5f), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.BONUS_MINING_RESULT).levelReq(89)).baseValue(0.4f), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.RARE_TABLE_HARVESTING_CHANCE).levelReq(96)).baseValue(0.001f), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoAArmour.HELM_OF_THE_TREASURER).levelReq(100)).restrictEquipping()}).finalize(SKILLS);
    }

    private void registerFarming() {
        new AoASkillBuilder(AoASkills.FARMING).abilities(new AoAAbilityBuilder[]{new AoAAbilityBuilder(AoAAbilities.FERTILISE_FARMLAND).levelReq(8), new BlockConversionBuilder().radius(1).targetBlock(Blocks.f_50652_).replacementBlock(Blocks.f_50079_).interactionItem((ItemLike)Items.f_42404_).levelReq(16), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoABlocks.GREEN_MANURE).levelReq(24)).restrictInteraction().restrictBlockPlacement(), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoABlocks.MAGIC_MARANG_CROP).levelReq(29)).restrictBlockPlacement(), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.BREEDING_BONUS).levelReq(35)).baseValue(0.1f).perLevelMod(0.002f), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.DRYAD_SPRITE_SPAWN).levelReq(44)).baseValue(7.5E-4f).perLevelMod(8.0E-5f), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.HARVEST_REPLANT).levelReq(49)).baseValue(0.1f).perLevelMod(0.003f), ((HoeAreaHarvestBuilder)new HoeAreaHarvestBuilder().levelReq(57)).baseRadius(1).levelsPerRadiusIncrease(20), new BlockConversionBuilder().radius(4).targetBlock(Blocks.f_50440_).replacementBlock(Blocks.f_50195_).interactionItem((ItemLike)AoAItems.MUSHROOM_SPORES.get()).levelReq(66), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoABlocks.TRILLIAD_CROP).levelReq(74)).restrictBlockPlacement(), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoABlocks.THORNY_PLANT_CROP).levelReq(86)).restrictBlockPlacement(), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoATools.DRYADS_BLESSING).levelReq(92)).restrictEquipping(), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoAArmour.HELM_OF_THE_DRYAD).levelReq(100)).restrictEquipping()}).finalize(SKILLS);
    }

    private void registerFaunamancy() {
        new AoASkillBuilder(AoASkills.FAUNAMANCY).abilities(new EntityTagDamageBonusBuilder(AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_MELEE).levelReq(42).baseValue(0.2f).tag(AoATags.Entities.WEAK_TO_MELEE), new EntityTagDamageBonusBuilder(AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_PROJECTILE).levelReq(55).baseValue(0.2f).tag(AoATags.Entities.WEAK_TO_RANGED), new EntityTagDamageBonusBuilder(AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_EXPLOSION).levelReq(68).baseValue(0.2f).tag(AoATags.Entities.WEAK_TO_EXPLOSIONS), new EntityTagDamageBonusBuilder(AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_MAGIC).levelReq(83).baseValue(0.2f).tag(AoATags.Entities.WEAK_TO_MAGIC)).finalize(SKILLS);
    }

    private void registerHauling() {
        new AoASkillBuilder(AoASkills.HAULING).abilities(new AoAAbilityBuilder[]{((ScalableModAbilityBuilder)new FishingXpBoostBuilder().levelReq(8)).baseValue(1.0f), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoATools.HAULING_ROD).levelReq(15)).restrictEquipping(), new ScalableModAbilityBuilder(AoAAbilities.FISHING_TRAP_SPAWN).baseValue(0.05f).perLevelMod(-0.0035f).levelReq(25), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoATools.FISHING_CAGE).levelReq(31)).restrictEquipping(), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.HAULING_ROD_PULL_STRENGTH).levelReq(45)).perLevelMod(0.0025f), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoATools.THERMALLY_INSULATED_ROD).levelReq(54)).restrictEquipping(), new AoAAbilityBuilder(AoAAbilities.HAULING_GLOWING_FISH).levelReq(60), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoATools.LIGHT_ROD).levelReq(69)).restrictEquipping(), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.HAULING_ROD_PULL_DAMAGE).levelReq(77)).baseValue(3.0f), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoAArmour.HELM_OF_THE_TRAWLER).levelReq(100)).restrictEquipping()}).finalize(SKILLS);
    }

    private void registerImbuing() {
        new AoASkillBuilder(AoASkills.IMBUING).abilities(new AoAAbilityBuilder[0]).finalize(SKILLS);
    }

    private void registerInnervation() {
        new AoASkillBuilder(AoASkills.INNERVATION).abilities(new AoAAbilityBuilder[]{new AttributeModificationBuilder(Attributes.f_22276_).operation(AttributeModifier.Operation.ADDITION).perLevelMod(0.3f), ((OneShotDamageLimiterBuilder)new OneShotDamageLimiterBuilder().levelReq(10)).restoreHealthTo(1.0f), ((PotionDurationReducerBuilder)new PotionDurationReducerBuilder(0.5f).levelReq(19)).matchPotions(MobEffects.f_19597_, MobEffects.f_19599_, MobEffects.f_19613_, MobEffects.f_19610_, MobEffects.f_19604_), new AttributeModificationBuilder(Attributes.f_22276_).levelReq(25).operation(AttributeModifier.Operation.ADDITION).baseValue(10.0f), ((BowDamageIncreaseBuilder)new BowDamageIncreaseBuilder(1.2f).levelReq(36)).requireFullBowCharge(), ((InnervationMobLureBuilder)new InnervationMobLureBuilder().levelReq(44)).perTickDrain(0.4f).luredDamageModifier(0.25f), new AttributeModificationBuilder(Attributes.f_22276_).levelReq(50).operation(AttributeModifier.Operation.ADDITION).baseValue(10.0f), ((InnervationDodgeBuilder)new InnervationDodgeBuilder().levelReq(59)).energyCost(30.0f), new VulcaneDamageIncreaseBuilder(1.5f).levelReq(65), ((ScalableModAbilityBuilder)new ScalableModAbilityBuilder(AoAAbilities.DOUBLE_DROPS_CHANCE).levelReq(77)).baseValue(0.1f).perLevelMod(0.00147f), new AttributeModificationBuilder(Attributes.f_22276_).levelReq(85).operation(AttributeModifier.Operation.ADDITION).baseValue(10.0f), ((StunStrikeBuilder)new StunStrikeBuilder(30.0f).levelReq(91)).stunDuration(40), ((LevelRestrictionBuilder)new LevelRestrictionBuilder(AoAArmour.HELM_OF_THE_WARRIOR).levelReq(100)).restrictEquipping()}).finalize(SKILLS);
    }

    private void registerSkills() {
        this.registerAlchemy();
        this.registerCreation();
        this.registerDexterity();
        this.registerEngineering();
        this.registerExtraction();
        this.registerFarming();
        this.registerFaunamancy();
        this.registerHauling();
        this.registerImbuing();
        this.registerInnervation();
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        this.registerResources();
        this.registerSkills();
        try {
            for (AoAResourceBuilder resource : RESOURCES) {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)resource.toJson(), (Path)this.generator.m_123916_().resolve("data/aoa3/player/resources/" + resource.getId().m_135815_() + ".json"));
            }
            for (AoASkillBuilder skill : SKILLS) {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)skill.toJson(), (Path)this.generator.m_123916_().resolve("data/aoa3/player/skills/" + skill.getId().m_135815_() + ".json"));
            }
        }
        catch (IOException ex) {
            Logging.logMessage(Level.ERROR, "Error while generating player resources & skills.", ex);
        }
    }

    public String m_6055_() {
        return "Player Stats";
    }

    public static ArrayList<AoASkillBuilder> getSkillBuilders() {
        return SKILLS;
    }
}

