/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import org.apache.logging.log4j.Level;

public class DataGenParticles
implements DataProvider {
    private final DataGenerator generator;
    private static final HashMap<RegistryObject<?>, Integer> PARTICLES = new HashMap();

    public DataGenParticles(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) {
        Path outputPath = this.generator.m_123916_();
        for (Map.Entry<RegistryObject<?>, Integer> entry : PARTICLES.entrySet()) {
            RegistryObject<?> particleType = entry.getKey();
            String id = particleType.getId().toString();
            Path savePath = outputPath.resolve("assets/" + particleType.getId().m_135827_() + "/particles/" + particleType.getId().m_135815_() + ".json");
            JsonObject obj = new JsonObject();
            JsonArray textures = new JsonArray();
            if (entry.getValue() > 1) {
                for (int i = 0; i < entry.getValue(); ++i) {
                    textures.add(id + "_" + i);
                }
            } else if (entry.getValue() == 1) {
                textures.add(id);
            }
            if (entry.getValue() > 0) {
                obj.add("textures", (JsonElement)textures);
            }
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)obj, (Path)savePath);
            }
            catch (IOException ex) {
                Logging.logMessage(Level.ERROR, "Couldn't save particle type texture reference: " + particleType.getId().toString());
            }
        }
    }

    public String m_6055_() {
        return "Particles";
    }

    static {
        PARTICLES.put(AoAParticleTypes.PORTAL_FLOATER, 8);
        PARTICLES.put(AoAParticleTypes.SPARKLER, 8);
        PARTICLES.put(AoAParticleTypes.LINGERING_SPARKLER, 8);
        PARTICLES.put(AoAParticleTypes.RAINBOW_SPARKLER, 8);
        PARTICLES.put(AoAParticleTypes.FLICKERING_SPARKLER, 8);
        PARTICLES.put(AoAParticleTypes.SWIRLY, 8);
        PARTICLES.put(AoAParticleTypes.FLOATING_ITEM_FRAGMENT, 0);
        PARTICLES.put(AoAParticleTypes.FREEZING_SNOWFLAKE, 1);
    }
}

