/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import com.mojang.datafixers.util.Pair;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.datagen.DataGenAdvancements;
import net.tslat.aoa3.advent.datagen.DataGenBlocks;
import net.tslat.aoa3.advent.datagen.DataGenEntities;
import net.tslat.aoa3.advent.datagen.DataGenItems;
import net.tslat.aoa3.advent.datagen.DataGenPlayerStats;
import net.tslat.aoa3.advent.datagen.DataGenSounds;
import net.tslat.aoa3.advent.datagen.builder.AdvancementBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.AoASkillBuilder;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.ability.AoAAbilityBuilder;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.advent.datagen.packages.DataGenEntityPackage;
import net.tslat.aoa3.advent.datagen.packages.DataGenItemPackage;
import net.tslat.aoa3.advent.datagen.packages.DataGenSoundPackage;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.StringUtil;

public final class DataGenLang
extends LanguageProvider {
    public DataGenLang(DataGenerator gen) {
        super(gen, "aoa3", "en_us");
    }

    protected void addTranslations() {
        this.handleBlocksLang();
        this.handleItemsLang();
        this.handleItemGroupsLang();
        this.handleEntitiesLang();
        this.handleConfigLang();
        this.handleLangConstants();
        this.handleAdvancementsLang();
        this.handleEnchantmentsLang();
        this.handleBiomesLang();
        this.handleSoundsLang();
        this.handleGamerulesLang();
        this.handleSkillsLang();
        this.handleResourcesLang();
        this.handleAbilitiesLang();
        this.handleMiscLang();
    }

    private void handleBlocksLang() {
        for (DataGenBlockPackage blockPackage : DataGenBlocks.BLOCKS) {
            blockPackage.addLocaleEntries(this);
        }
        this.add("block.aoa3.gold_trophy.desc", "Gold %1$s Trophy");
        this.add("block.aoa3.ornate_trophy.desc", "Ornate %1$s Trophy");
        this.add("block.aoa3.trophy.desc", "%1$s Trophy");
    }

    private void handleItemsLang() {
        for (DataGenItemPackage itemPackage : DataGenItems.ITEMS) {
            itemPackage.addLocaleEntries(this);
        }
        AoARegistries.ITEMS.getAllAoARegisteredObjects().stream().filter(item -> item.get() instanceof SpawnEggItem).forEach(egg -> this.add((Item)egg.get(), StringUtil.toTitleCase(egg.getId().m_135815_())));
        this.add("items.description.blaster.effect", "Shots have no penetration power");
        this.add("items.description.blaster.fire", "First shot must be charged");
        this.add("items.description.boss_summon_item.unstable", "Unstable if thrown");
        this.add("items.description.bow.drawSpeed", "Draw time: %1$ss");
        this.add("items.description.cannon.damage", "Deals more damage to armoured enemies");
        this.add("items.description.damage.arrows", "%1$s Average ranged damage");
        this.add("items.description.damage.blaster", "%1$s Blaster damage");
        this.add("items.description.damage.gun", "%1$s Gun damage");
        this.add("items.description.damage.magic", "%1$s Magic damage");
        this.add("items.description.damage.ranged", "%1$s Ranged damage");
        this.add("items.description.damage.shotgun", "%1$sx%2$s Gun damage");
        this.add("items.description.damage.true", "%1$s True damage");
        this.add("items.description.gun.fully_automatic", "Fully-automatic firing");
        this.add("items.description.gun.semi_automatic", "Semi-automatic firing");
        this.add("items.description.healingFood.desc.1", "In addition to restoring hunger:");
        this.add("items.description.healingFood.desc.2", "Heals up to %1$s health when eaten");
        this.add("items.description.infusionBowl.desc.1", "Used to siphon resources from stray Pixons");
        this.add("items.description.maul.knockback", "Knocks targets back %1$s blocks");
        this.add("items.description.scythe", "Leeches Spirit From Targets");
        this.add("items.description.skillCrystal.desc.1", "Grants experience to your lowest level skill");
        this.add("items.description.skillCrystal.desc.2", "Ignores skills below level %1$s");
        this.add("items.description.sniper.use", "Crouch to stabilise your shots and scope in");
        this.add("items.description.staff.runesRequired", "Runes required:");
        this.add("items.description.staff.runesRequired.specific", "%1$s %2$s");
        this.add("items.description.tablet.placementCost", "Activation cost: %1$s Soul Power");
        this.add("items.description.tablet.radius", "Effect radius: %1$s blocks");
        this.add("items.description.tablet.usageCost", "Soul Power drain: %1$s/s");
        this.add("items.description.throwable.speed", "Throw rate: %1$s/sec");
        this.add("items.description.thrownWeapon", "Thrown weapon");
        this.add("items.description.tool.energisticCharge", "Right click to charge with Spirit");
        this.add("items.description.tool.energisticStorage", "Stored Spirit: %1$s");
        this.add("items.description.tool.goofyNoDamage", "Deals no damage to enemies");
        this.add("items.description.tool.goofyRegen", "Slowly regenerates durability over time");
        this.add("items.description.tool.skeletal", "High in calcium");
        this.add("items.description.vulcane.use", "Usable when at least 50 Rage has been accrued");
        this.add("items.description.vulcane.target", "Can only be used within 5 seconds of last attack taken");
        this.add("items.description.helmet.airTight", "Provides its own oxygen");
        this.add("item.aoa3.potion.medic", "Potion of The Medic");
        this.add("item.aoa3.potion.gills", "Potion of Gills");
        this.add("item.aoa3.potion.unignitable", "Potion of The Unignitable");
        this.add("item.aoa3.potion.everlastingStrength", "Potion of Everlasting Strength");
        this.add("item.aoa3.potion.nocturnal", "Potion of The Nocturnal");
        this.add("item.aoa3.potion.decay", "Splash Potion of Decay");
        this.add("items.description.stickler.1", "Shoots a Sticky Bomb That Attaches to Enemies");
        this.add("items.description.stickler.2", "Bomb explodes after 5 seconds");
        this.add("items.description.unbreakable", "Unbreakable");
        for (RegistryObject item2 : new RegistryObject[]{AoAItems.COMPASS_RUNE, AoAItems.DISTORTION_RUNE, AoAItems.ENERGY_RUNE, AoAItems.FIRE_RUNE, AoAItems.LIFE_RUNE, AoAItems.KINETIC_RUNE, AoAItems.LUNAR_RUNE, AoAItems.POISON_RUNE, AoAItems.POWER_RUNE, AoAItems.STORM_RUNE, AoAItems.STRIKE_RUNE, AoAItems.WATER_RUNE, AoAItems.WIND_RUNE, AoAItems.WITHER_RUNE}) {
            for (DyeColor color : DyeColor.values()) {
                this.add("block.minecraft.banner." + item2.getId().m_135815_() + "." + color.m_41065_(), StringUtil.toTitleCase(color.m_41065_()) + " " + StringUtil.toTitleCase(item2.getId().m_135815_()));
            }
        }
    }

    private void handleItemGroupsLang() {
        for (AoAItemGroups.AoAItemGroup itemGroup : AoAItemGroups.REGISTERED_ITEM_GROUPS) {
            this.add("itemGroup." + itemGroup.m_40783_(), itemGroup.getLocaleName());
        }
    }

    private void handleEntitiesLang() {
        for (DataGenEntityPackage entityPackage : DataGenEntities.ENTITIES) {
            entityPackage.addLocaleEntries(this);
        }
        this.add("message.mob.four_guardians.spawn", "The Guardians have awoken!");
    }

    private void handleEnchantmentsLang() {
        for (RegistryObject<Enchantment> enchant : AoARegistries.ENCHANTMENTS.getAllAoARegisteredObjects()) {
            if (((Enchantment)enchant.get()).m_6589_()) {
                this.add((Enchantment)enchant.get(), StringUtil.toTitleCase("Curse of " + enchant.getId().m_135815_()));
                continue;
            }
            this.add((Enchantment)enchant.get(), StringUtil.toTitleCase(enchant.getId().m_135815_()));
        }
        this.add("enchantment.aoa3.archmage.desc", "Reduces rune cost of staves by 1 rune per level.");
        this.add("enchantment.aoa3.brace.desc", "Converts the weapon into an offhand-variant, allowing firing while in the offhand.");
        this.add("enchantment.aoa3.control.desc", "Reduces recoil on guns.");
        this.add("enchantment.aoa3.crush.desc", "Increases knockback on mauls.");
        this.add("enchantment.aoa3.form.desc", "Reduces pellet-spread on shotguns.");
        this.add("enchantment.aoa3.greed.desc", "Increases rune cost of staves, consumes an additional bullet when firing guns, and increases energy drain on blasters.");
        this.add("enchantment.aoa3.intervention.desc", "Prevents the user from losing the item from their inventory when dying. Chance to lose the enchantment each activation.");
        this.add("enchantment.aoa3.recharge.desc", "Reduces energy consumption of blasters.");
        this.add("enchantment.aoa3.sever.desc", "Increases damage dealt when critically striking with greatblades.");
        this.add("enchantment.aoa3.shell.desc", "Increases damage dealt by guns.");
    }

    private void handleBiomesLang() {
        this.add("biome.aoa3.abyssal_plains", "Abyssal Plains");
        this.add("biome.aoa3.asteroid_belt", "Asteroid Belt");
        this.add("biome.aoa3.barren_grounds", "Barren Grounds");
        this.add("biome.aoa3.candy_hills", "Candy Hills");
        this.add("biome.aoa3.cavern_depths", "Cavern Depths");
        this.add("biome.aoa3.celevian_highlands", "Celevian Highlands");
        this.add("biome.aoa3.coral_fields", "Coral Fields");
        this.add("biome.aoa3.creepoid_forest", "Creepoid Forest");
        this.add("biome.aoa3.crystevian_caverns", "Crystevian Caverns");
        this.add("biome.aoa3.dustopian_forest", "Dustopian Forest");
        this.add("biome.aoa3.floral_islands", "Floral Islands");
        this.add("biome.aoa3.fungal_caverns", "Fungal Caverns");
        this.add("biome.aoa3.greckon_mountains", "Greckon Mountians");
        this.add("biome.aoa3.haven", "Haven");
        this.add("biome.aoa3.iromine", "Iromine");
        this.add("biome.aoa3.lelyetian_plains", "Lelyetian Plains");
        this.add("biome.aoa3.nowhere", "Nowhere");
        this.add("biome.aoa3.precasian_tall_forest", "Precasian Tall Forest");
        this.add("biome.aoa3.runic_cliffs", "Runic Cliffs");
        this.add("biome.aoa3.shyre_remnants", "Shyre Remnants");
        this.add("biome.aoa3.vox_wastes", "Vox Wastes");
    }

    private void handleSoundsLang() {
        for (DataGenSoundPackage sound : DataGenSounds.SOUNDS) {
            if (sound.getSubtitle() == null) continue;
            this.add("subtitles." + sound.name(), sound.getSubtitle());
        }
    }

    private void handleConfigLang() {
        this.add("config.aoa3.server.allowUnsafeInfusion", "Allow Unsafe Infusion");
        this.add("config.aoa3.server.portalSearchRadius", "Portal Search Radius");
        this.add("config.aoa3.server.easyCorruptedTravellers", "Easier Corrupted Travellers");
        this.add("config.aoa3.server.allowNonPlayerPortalTravel", "Allow Mobs to Use Portals");
        this.add("config.aoa3.server.globalXpModifier", "Global Xp Modifier");
        this.add("config.aoa3.server.saveLootFromExplosions", "Explosion-Proof Loot");
        this.add("config.aoa3.server.disableSkills", "Disable All Skills");
        this.add("config.aoa3.server.skillsLeaderboardEnabled", "Skills Leaderboard Enabled");
        this.add("config.aoa3.server.maxLeaderboardThreads", "Max Leaderboard Threads");
        this.add("config.aoa3.server.dontCacheDatabase", "Don't Cache Database");
        this.add("config.aoa3.server.databaseUsername", "Database Username");
        this.add("config.aoa3.server.databasePassword", "Database Password");
        this.add("config.aoa3.client.showXpParticles", "Display XP Particles");
        this.add("config.aoa3.client.showWelcomeMessage", "Show Welcome Message");
        this.add("config.aoa3.client.showPlayerHalos", "Show Player Halos");
        this.add("config.aoa3.client.personalHaloPreference", "Preferred Player Halo");
        this.add("config.aoa3.client.adventGuiTheme", "Advent Gui Theme");
        this.add("config.aoa3.client.thirdPartyBestiary", "Third-Party Bestiary Entries");
        this.add("config.aoa3.client.hudSkillProgressRenderType", "HUD Skill Progress Render Type");
        this.add("config.aoa3.client.hudResourcesPosition", "Resources Gui Corner");
        this.add("config.aoa3.client.hudResourcesHorizontal", "Horizontal Resources Layout");
        this.add("config.aoa3.client.disableHudPotionOffset", "Disable HUD Potion Offset");
        this.add("config.aoa3.client.useToasts", "Use Toasts For Feedback");
        this.add("config.aoa3.client.rotatingTrophies", "Rotating Trophies");
        this.add("config.aoa3.client.partyDeaths", "Party Deaths");
        this.add("config.aoa3.client.healthRenderType", "Health Render Type");
        this.add("config.aoa3.integrations.jei", "JEI Integration Enabled");
        this.add("config.aoa3.integrations.jer", "JER Integration Enabled");
        this.add("config.aoa3.integrations.immersiveEngineering", "Immersive Engineering Integration Enabled");
        this.add("config.aoa3.integrations.patchouli", "Patchouli Integration Enabled");
        this.add("config.aoa3.integrations.tinkersConstruct", "Tinker's Construct Integration Enabled");
    }

    private void handleAdvancementsLang() {
        for (AdvancementBuilder adv : DataGenAdvancements.advancements) {
            this.doAdvancementLang(adv);
        }
    }

    private void doAdvancementLang(AdvancementBuilder adv) {
        this.add(adv.getTitleLangKey(), adv.getTitle());
        this.add(adv.getDescriptionLangKey(), adv.getDescription());
        if (adv.getChildAdvancements() != null) {
            for (AdvancementBuilder child : adv.getChildAdvancements()) {
                this.doAdvancementLang(child);
            }
        }
    }

    private void handleLangConstants() {
        this.add("items.description.ammo.resource", "Consumes %1$s %2$s");
        this.add("items.description.ammo.item", "Ammo: %1$s");
        this.add("items.description.gun.firingSpeed", "Firing rate: %1$s/sec");
        this.add("items.description.armour.anySet", "Stacks with any armor set");
        this.add("items.description.armour.piece", "Per piece worn:");
        this.add("items.description.armour.set", "Full set bonus:");
        this.add("items.description.damage.fire", "Sets targets on fire");
        this.add("items.description.damage.explosion", "Explodes on successful hit");
        this.add("items.description.damage.poison", "Poisons targets");
        this.add("items.description.damage.weak", "Weakens targets");
        this.add("items.description.damage.wither", "Withers targets");
        this.add("items.description.damage.random", "Randomly deals between %1$s and %2$s damage");
        this.add("items.description.damage.slow", "Slows targets");
        this.add("items.description.damage.leech", "Leeches health from targets");
        this.add("items.description.damage.knockback", "Blows back targets on impact");
        this.add("items.description.damage.specImmune", "Does not work on exceptionally strong souls");
        this.add("items.description.skillRequirement", "Requires level %1$s %2$s");
        this.add("items.description.skillXpBonus", "+%1$s%% Xp gained for %2$s");
        this.add("dimension.aoa3.abyss", "Abyss");
        this.add("dimension.aoa3.barathos", "Barathos");
        this.add("dimension.aoa3.candyland", "Candyland");
        this.add("dimension.aoa3.celeve", "Celeve");
        this.add("dimension.aoa3.creeponia", "Creeponia");
        this.add("dimension.aoa3.crystevia", "Crystevia");
        this.add("dimension.aoa3.deeplands", "Deeplands");
        this.add("dimension.aoa3.dustopia", "Dustopia");
        this.add("dimension.aoa3.gardencia", "Gardencia");
        this.add("dimension.aoa3.greckon", "Greckon");
        this.add("dimension.aoa3.haven", "Haven");
        this.add("dimension.aoa3.iromine", "Iromine");
        this.add("dimension.aoa3.lborean", "L'Borean");
        this.add("dimension.aoa3.lelyetia", "Lelyetia");
        this.add("dimension.aoa3.lunalus", "Lunalus");
        this.add("dimension.aoa3.mysterium", "Mysterium");
        this.add("dimension.aoa3.nether", "Nether");
        this.add("dimension.aoa3.nowhere", "Nowhere");
        this.add("dimension.aoa3.overworld", "Overworld");
        this.add("dimension.aoa3.precasia", "Precasia");
        this.add("dimension.aoa3.runandor", "Runandor");
        this.add("dimension.aoa3.shyrelands", "Shyrelands");
        this.add("dimension.aoa3.vox_ponds", "Vox Ponds");
    }

    private void handleGamerulesLang() {
        this.add("gamerule.destructiveWeaponPhysics", "AoA Weapon physics break blocks");
        this.add("gamerule.doStrongerMobGriefing", "Even more mob griefing");
    }

    private void handleSkillsLang() {
        for (RegistryObject<AoASkill> skill : AoARegistries.AOA_SKILLS.getAllAoARegisteredObjects()) {
            this.add(Util.m_137492_((String)"skill", (ResourceLocation)skill.getId()), StringUtil.toTitleCase(skill.getId().m_135815_()));
        }
    }

    private void handleResourcesLang() {
        for (RegistryObject<AoAResource> resource : AoARegistries.AOA_RESOURCES.getAllAoARegisteredObjects()) {
            this.add(Util.m_137492_((String)"resource", (ResourceLocation)resource.getId()), StringUtil.toTitleCase(resource.getId().m_135815_()));
        }
    }

    private void handleAbilitiesLang() {
        for (RegistryObject<AoAAbility> ability : AoARegistries.AOA_ABILITIES.getAllAoARegisteredObjects()) {
            this.add(Util.m_137492_((String)"ability", (ResourceLocation)ability.getId()), StringUtil.toTitleCase(ability.getId().m_135815_()));
        }
        for (AoASkillBuilder skillBuilder : DataGenPlayerStats.getSkillBuilders()) {
            for (AoAAbilityBuilder<?> abilityBuilder : skillBuilder.getAbilities()) {
                for (Pair<String, String> localePair : abilityBuilder.getTranslations()) {
                    this.add((String)localePair.getFirst(), (String)localePair.getSecond());
                }
            }
        }
        this.add("ability.aoa3.descriptions.scaling", "%1$s per skill level (Current value: %2$s)");
        this.add("ability.aoa3.descriptions.scaling.percent", "%1$s%% per skill level (Current value: %2$s%%)");
        this.add("ability.aoa3.descriptions.flat", "%1$s");
        this.add("ability.aoa3.descriptions.flat.percent", "%1$s%%");
        this.add("ability.aoa3.descriptions.flatAndScaling", "%1$s + %2$s per skill level (Current value: %3$s)");
        this.add("ability.aoa3.descriptions.flatAndScaling.percent", "%1$s%% + %2$s%% per skill level (Current value: %3$s%%)");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ATTRIBUTE_MODIFICATION.getId()) + ".description", "Modify the %1$s attribute by %2$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.FLAT_XP_BOOST.getId()) + ".description", "Increase XP gain for %1$s by %2$s%%");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.FALL_DAMAGE_REDUCTION.getId()) + ".description", "Reduce fall damage from falls %1$s-%2$s blocks high by %3$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.FALL_DAMAGE_REDUCTION.getId()) + ".description.max", "Reduce fall damage from falls up to %2$s blocks high by %3$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.FALL_DAMAGE_REDUCTION.getId()) + ".description.min", "Reduce fall damage from falls more than %1$s blocks high by %3$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.JUMP_BOOST.getId()) + ".description.lateral", "Increases jump distance when sprinting by ~%1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.JUMP_BOOST.getId()) + ".description.vertical", "Increases jump height by ~%1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.DOUBLE_JUMP.getId()) + ".description", "Allows for a second jump without touching the ground at the cost of %1$s Energy.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ONE_SHOT_DAMAGE_LIMITER.getId()) + ".description", "Prevents being killed by a single powerful blow when above %1$s health, leaving you alive with %2$s health remaining.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ONE_SHOT_DAMAGE_LIMITER.getId()) + ".description.full", "Prevents being killed by a single powerful blow from max health, leaving you alive with %1$s health remaining.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.POTION_DURATION_REDUCER.getId()) + ".description.addition.type", "Adjusts the duration of %1$s type potions when applied to you by %2$s.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.POTION_DURATION_REDUCER.getId()) + ".description.addition.list", "Adjusts the duration of various specified potions when applied by %1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.POTION_DURATION_REDUCER.getId()) + ".description.multiply.type", "Adjusts the duration of %1$s type potions when applied to you by %2$s%%.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.POTION_DURATION_REDUCER.getId()) + ".description.multiply.list", "Adjusts the duration of various specified potions when applied to you by %1$s%%.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BOW_DAMAGE_INCREASE.getId()) + ".description.fullCharge", "Increases the damage of bow damage dealt by %1$s%% when firing fully-charged shots.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BOW_DAMAGE_INCREASE.getId()) + ".description", "Increases the damage dealt by bows by %1$s%%.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.INNERVATION_MOB_LURE.getId()) + ".description", "Press the Ability Action keybind while crouching to force the last entity you hit to target you. Consumes %1$s spirit per second while active. An attack from the lured entity is reduced to %2$s%% damage, and ends the lure.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ON_KILL_DAMAGE_BOOST.getId()) + ".description", "Grants a %1$s%% damage boost to all standard attacks for %2$s seconds after a successful kill.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.VULCANE_DAMAGE_INCREASE.getId()) + ".description", "Increases the damage dealt by Vulcanes by %1$s%%.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.VULCANE_DAMAGE_INCREASE.getId()) + ".description.minRage", "Increases the damage dealt by Vulcanes by %1$s%%, as long as at least %2$s Rage is consumed.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.DOUBLE_DROPS_CHANCE.getId()) + ".description", "Has a %1$s chance to double a slain creature's loot on death.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.INNERVATION_DODGE.getId()) + ".description", "Press the Ability Action keybind while strafing to perform a strafe-dash at the cost of %1$s energy. Incoming melee attacks taken while dashing will be negated.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.STUN_STRIKE.getId()) + ".description", "Press the Ability Action keybind while standing still to prepare a stun-strike for your next attack. The next melee attack you deal will also quickly throw a secondary punch, stunning the target for %1$s seconds, at the cost of %2$s energy. Must be holding an off-hand item.");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.LEVEL_RESTRICTION.getId()) + ".description", "Gives access to the following for %1$s: ");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.LEVEL_RESTRICTION.getId()) + ".description.equip", "Equip/Wear");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.LEVEL_RESTRICTION.getId()) + ".description.place_block", "Place block");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.LEVEL_RESTRICTION.getId()) + ".description.break_block", "Break block");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.LEVEL_RESTRICTION.getId()) + ".description.interact_with", "Interact with block");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HAULING_GLOWING_FISH.getId()) + ".description", "Fish that are currently attracted to your lure will glow through blocks");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.FISHING_XP_BOOST.getId()) + ".description", "Increases the amount of xp orbs gained from fishing by %1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HAULING_ROD_PULL_STRENGTH.getId()) + ".description", "Modifies the pull strength of a hauling rod by %1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HAULING_ROD_PULL_DAMAGE.getId()) + ".description", "Deals %1$s damage when pulling on a hooked entity with a hauling rod");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.FISHING_TRAP_SPAWN.getId()) + ".description", "Has a %1$s chance spawning of trap entities when fishing, and increases Hauling xp gain");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BLOCK_CONVERSION.getId()) + ".description", "Use %4$s on %2$s to convert all %2$s within %1$s blocks flat radius to %3$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BLOCK_CONVERSION.getId()) + ".description.noItem", "Interact with %2$s to convert all %2$s within %1$s blocks flat radius to %3$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BLOCK_CONVERSION.getId()) + ".description.single", "Use %4$s on %2$s to convert it to %3$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BLOCK_CONVERSION.getId()) + ".description.noItem.single", "Interact with %2$s to convert it to %3$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HOE_AREA_HARVEST.getId()) + ".description", "Harvest crops within %1$s blocks by using a hoe on one, costing %3$s durability per crop. Increases radius every %2$s levels");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HOE_AREA_HARVEST.getId()) + ".description.flat", "Harvest crops within %1$s blocks by using a hoe on one, costing %3$s durability per crop");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HOE_AREA_HARVEST.getId()) + ".description.noDamage", "Harvest crops within %1$s blocks by using a hoe on one. Increases radius every %2$s levels");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HOE_AREA_HARVEST.getId()) + ".description.flat.noDamage", "Harvest crops within %1$s blocks by using a hoe on one");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.FERTILISE_FARMLAND.getId()) + ".description", "Treat farmland with bone meal to make fertilised farmland, boosting crop yield");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.DRYAD_SPRITE_SPAWN.getId()) + ".description", "Gives a %1$s chance to spawn a Dryad Sprite when harvesting crops");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BREEDING_BONUS.getId()) + ".description", "Gives a %1$s chance to spawn an extra child when breeding animals");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HARVEST_REPLANT.getId()) + ".description", "Gives a %1$s chance to instantly replant crops when harvested");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.AUTO_HARVESTING_TRASH.getId()) + ".description", "Consume a chosen item when harvesting blocks. Crouch click here to select an item");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.AUTO_HARVESTING_TRASH.getId()) + ".description.item", "When harvesting blocks, all %1$s dropped will be consumed. Crouch click here to change or remove the selection");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HARD_BLOCK_SPEED_INCREASE.getId()) + ".description", "Increases mining speed on hard blocks, increasing further on harder blocks. Increase is approximately %1$s faster on Obsidian");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HARVEST_SPEED_BOOST.getId()) + ".description", "Press the Ability Action keybind while mining to activate a temporary mining speed boost, consuming your energy at %1$s per second");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.HARVEST_SPEED_BOOST.getId()) + ".description.scaling", "Press the Ability Action keybind while mining to activate a temporary mining speed boost, consuming your energy at %1$s per second, reducing by %2$s per level");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BONUS_SMELT_RESULT.getId()) + ".description", "Gives a %1$s chance to find extra items when retrieving smelted items from a furnace");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BONUS_MINING_RESULT.getId()) + ".description", "Gives a %1$s chance to find extra items when mining ores that drop minerals");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.AUTO_ENCHANT_CRAFTING.getId()) + ".description", "When crafting, automatically enchants the crafting result if compatible with the following enchantments: ");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.RARE_TABLE_HARVESTING_CHANCE.getId()) + ".description", "Gives a %1$s chance to find rare loot while mining most natural blocks");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BONUS_CRAFTING_OUTPUT.getId()) + ".description.item", "Increases crafting output of %2$s by %1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.BONUS_CRAFTING_OUTPUT.getId()) + ".description.tag", "Increases crafting output of any items tagged as '%2$s' by %1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ENTITY_TAG_DAMAGE_BONUS.getId()) + ".description", "Increases damage to entities tagged as '%2$s' by %1$s");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_MELEE.getId()) + ".description.melee", "Increases damage to entities tagged as '%2$s' by %1$s if killed with melee attacks");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_MAGIC.getId()) + ".description.magic", "Increases damage to entities tagged as '%2$s' by %1$s if killed with magic attacks");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_PROJECTILE.getId()) + ".description.projectile", "Increases damage to entities tagged as '%2$s' by %1$s if killed with projectile attacks");
        this.add(Util.m_137492_((String)"ability", (ResourceLocation)AoAAbilities.ENTITY_TAG_DAMAGE_BONUS_EXPLOSION.getId()) + ".description.explosion", "Increases damage to entities tagged as '%2$s' by %1$s if killed with explosive attacks");
    }

    private void handleMiscLang() {
        this.add("attribute.name.generic.reach_distance", "Reach Distance");
        this.add("argument.aoa.skill.notFound", "Unknown AoA Skill %1$s");
        this.add("argument.aoa.resource.notFound", "Unknown AoA Resource %1$s");
        this.add("command.aoa.player.desc", "AoAPlayer - Check or adjust any online player's stats and resources");
        this.add("command.aoa.player.exp.adjust", "Adjusted %1$s's exp by %2$s, current value: %3$s (Level %4$s)");
        this.add("command.aoa.player.exp.check.other", "%1$s's current exp: %2$s (Level %3$s)");
        this.add("command.aoa.player.exp.check.self", "Current exp: %1$s (Level %2$s)");
        this.add("command.aoa.player.food.adjust", "Adjusted %1$s's food level by %2$s, current value: %3$s/20");
        this.add("command.aoa.player.food.hunger.check.other", "%1$s's current food level: %2$s/20");
        this.add("command.aoa.player.food.hunger.check.self", "Current food level: %1$s/20");
        this.add("command.aoa.player.food.saturation.check.other", "%1$s's current saturation: %2$s");
        this.add("command.aoa.player.food.saturation.check.self", "Current saturation: %1$s");
        this.add("command.aoa.player.health.adjust", "Adjusted %1$s's health by %2$s, current value: %3$s/%4$s");
        this.add("command.aoa.player.health.check.other", "%1$s's current health: %2$s/%3$s");
        this.add("command.aoa.player.health.check.self", "Current Health: %1$s/%2$s");
        this.add("command.aoa.player.resource.adjust", "Adjusted %1$s's %2$s by %3$s, current value: %4$s");
        this.add("command.aoa.player.resource.check.other", "%1$s has %2$s %3$s.");
        this.add("command.aoa.player.resource.check.self", "%1$s value: %2$s");
        this.add("command.aoa.player.saturation.adjust", "Adjusted %1$s's saturation by %2$s, current value: %3$s");
        this.add("command.aoa.player.skill.adjust", "Adjusted %1$s's %2$s level by %3$s, new value: %4$s");
        this.add("command.aoa.player.skill.check.other", "%1$s's %2$s level is %3$s");
        this.add("command.aoa.player.skill.check.self", "%1$s level: %2$s");
        this.add("command.aoa.player.tribute.adjust", "Adjusted %1$s's %2$s Tribute by %3$s, current value: %4$s");
        this.add("command.aoa.player.tribute.check.other", "%1$s has %2$s %3$s Tribute.");
        this.add("command.aoa.player.tribute.check.self", "%1$s Tribute value: %2$s");
        this.add("command.aoa.player.xp.adjust", "Adjusted %1$s's %2$s xp by %3$s, current xp: %4$s");
        this.add("command.aoa.player.xp.check.other", "%1$s has %3$s %2$s xp");
        this.add("command.aoa.player.xp.check.self", "%1$s xp: %2$s");
        this.add("command.aoa.player.cycle.adjust", "Adjusted %1$s's %2$s cycles by %3$s, current cycles: %4$s");
        this.add("command.aoa.player.cycle.check.other", "%1$s has completed %3$s cycles in %2$s");
        this.add("command.aoa.player.cycle.check.self", "%1$s cycles completed: %2$s");
        this.add("command.aoa.portalreset.desc", "/aoa portalreset - Reset all saved portal positions (use this if you get stuck outside of the overworld!). Enter your name to confirm.");
        this.add("command.aoa.portalreset.success", "Your saved portal locations have been deleted");
        this.add("command.aoa.structures.desc", "/aoa structures - Generate structures at a given location.");
        this.add("command.aoa.structures.invalidStructure", "Invalid structure id: %1$s");
        this.add("command.aoa.structures.spawn", "Spawned structure: %1$s at: %2$s");
        this.add("command.aoa.wiki.connectionFail", "Unable to connect to the wiki website to search");
        this.add("command.aoa.wiki.desc", "AoAWiki - Search the mod's official wiki for information");
        this.add("command.aoa.wiki.response", "Here's your AoAWiki search result: %s");
        this.add("command.aoa.version.desc", "You're playing on AoA3 v%1$s on Forge v%2$s");
        this.add("command.context.noPermission", "Insufficient permission for command.");
        this.add("container.aoa3.divine_station", "Divine Station");
        this.add("container.aoa3.frame_bench", "Frame Bench");
        this.add("container.aoa3.infusion_table", "Infusion Table");
        this.add("container.aoa3.mending_table", "Mending Table");
        this.add("container.aoa3.whitewashing_table", "Whitewashing Table");
        this.add("container.aoa3.lunar_creation_table", "Lunar Creation Table");
        this.add("death.attack.hauling", "%1$s was pulled apart by a fishing rod");
        this.add("death.attack.acid", "%1$s was dissolved in acid");
        this.add("death.attack.aoe", "%1$s was destroyed");
        this.add("death.attack.aoe.item", "%1$s was destroyed by %2$s using %3$s");
        this.add("death.attack.aoe.player", "%1$s was destroyed by %2$s");
        this.add("death.attack.blaster", "%1$s was blasted away");
        this.add("death.attack.blaster.item", "%1$s was blasted away by %2$s using %3$s");
        this.add("death.attack.blaster.player", "%1$s was blasted away by %2$s");
        this.add("death.attack.gun", "%1$s was shot to death");
        this.add("death.attack.gun.item", "%1$s was shot to death by %2$s using %3$s");
        this.add("death.attack.gun.player", "%1$s was shot to death by %2$s");
        this.add("death.attack.selfharm", "%1$s died to their own recoil");
        this.add("death.attack.skeletanium", "%1$s ran into skeletanium");
        this.add("death.attack.suffocation", "%1$s suffocated");
        this.add("death.attack.temple_trap", "%1$s was killed by temple traps");
        this.add("death.attack.toxic_block", "Toxic blocks put %1$s to sleep");
        this.add("death.attack.vox_ponds", "%1$s fell victim to the toxic atmosphere of the Vox Ponds.");
        this.add("death.attack.vox_ponds.player", "%1$s was killed by the Vox Ponds atmosphere while fighting %2$s");
        this.add("generator.aoa3.generic", "AoA Generic");
        this.add("gui.aoa3.adventGui.bestiary", "Bestiary");
        this.add("gui.aoa3.adventGui.bestiary.armour", "Armour:");
        this.add("gui.aoa3.adventGui.bestiary.attribute", "Creature Attribute:");
        this.add("gui.aoa3.adventGui.bestiary.attribute.arthropod", "Arthropod");
        this.add("gui.aoa3.adventGui.bestiary.attribute.hunterReq", "Hunter Requirement:");
        this.add("gui.aoa3.adventGui.bestiary.attribute.hunterxp", "Hunter Xp:");
        this.add("gui.aoa3.adventGui.bestiary.attribute.illager", "Illager");
        this.add("gui.aoa3.adventGui.bestiary.attribute.none", "None");
        this.add("gui.aoa3.adventGui.bestiary.attribute.undead", "Undead");
        this.add("gui.aoa3.adventGui.bestiary.downloading", "Download mob statistics..");
        this.add("gui.aoa3.adventGui.bestiary.empty", "There's nothing here, maybe you should kill something");
        this.add("gui.aoa3.adventGui.bestiary.emptySearch", "No results found for search");
        this.add("gui.aoa3.adventGui.bestiary.health", "Health:");
        this.add("gui.aoa3.adventGui.bestiary.hunterReq", "Hunter Requirement: ");
        this.add("gui.aoa3.adventGui.bestiary.hunterXp", "Hunter Xp: ");
        this.add("gui.aoa3.adventGui.bestiary.knockback", "Knockback Resist:");
        this.add("gui.aoa3.adventGui.bestiary.projectileStrength", "Projectile Damage:");
        this.add("gui.aoa3.adventGui.bestiary.size", "Size:");
        this.add("gui.aoa3.adventGui.bestiary.speed", "Movement Speed:");
        this.add("gui.aoa3.adventGui.bestiary.strength", "Damage:");
        this.add("gui.aoa3.adventGui.bestiary.type", "Creature Type:");
        this.add("gui.aoa3.adventGui.bestiary.type.ambient", "Ambient NPC");
        this.add("gui.aoa3.adventGui.bestiary.type.animal", "Animal");
        this.add("gui.aoa3.adventGui.bestiary.type.flyingMelee", "Flying Melee Attacker");
        this.add("gui.aoa3.adventGui.bestiary.type.flyingRanged", "Flying Ranged Attacker");
        this.add("gui.aoa3.adventGui.bestiary.type.hybrid", "Melee/Ranged Hybrid Attacker");
        this.add("gui.aoa3.adventGui.bestiary.type.melee", "Melee Attacker");
        this.add("gui.aoa3.adventGui.bestiary.type.other", "Other");
        this.add("gui.aoa3.adventGui.bestiary.type.ranged", "Ranged Attacker");
        this.add("gui.aoa3.adventGui.bestiary.type.swimmingMelee", "Swimming Melee Attacker");
        this.add("gui.aoa3.adventGui.bestiary.type.swimmingRanged", "Swimming Ranged Attacker");
        this.add("gui.aoa3.adventGui.bestiary.type.trader", "Trader");
        this.add("gui.aoa3.adventGui.help", "Help");
        this.add("gui.aoa3.adventGui.leaderboards", "Leaderboards");
        this.add("gui.aoa3.adventGui.help.description", "Advent of Ascension is a massive mod, covering a lot of different areas of Minecraft; so don't be surprised if you find yourself a bit lost. Not to worry though, there is a few things that can be done.<br><br> If you're looking for some specific information on any part of the mod, you will almost certainly be able to find the information you're looking for on the official wiki. The link to the wiki can be found on the right. This tab contains little information bundles about various parts of the game that you may need help with.<br><br>If you still can't find what you're looking for, join us on the official Discord server and ask any questions you want, there's plenty of knowledgeable players to help you out!");
        this.add("gui.aoa3.adventGui.help.linkDiscord", "Discord");
        this.add("gui.aoa3.adventGui.help.linkGithub", "Github");
        this.add("gui.aoa3.adventGui.help.linkPatreon", "Patreon");
        this.add("gui.aoa3.adventGui.help.linkUpdate", "Update");
        this.add("gui.aoa3.adventGui.help.linkWiki", "Official Wiki");
        this.add("gui.aoa3.adventGui.help.links", "Links");
        this.add("gui.aoa3.adventGui.help.theme", "Theme");
        this.add("gui.aoa3.adventGui.help.tip", "Random Tip: %1$s");
        this.add("gui.aoa3.adventGui.help.tip.0", "You can change your controls in the options menu");
        this.add("gui.aoa3.adventGui.help.tip.1", "Greatblades and Mauls have longer reach");
        this.add("gui.aoa3.adventGui.help.tip.8", "Some dimensions require a hazmat suit or face mask");
        this.add("gui.aoa3.adventGui.help.tip.9", "Daytime mobs are still controlled by block light");
        this.add("gui.aoa3.adventGui.help.tip.10", "Don't travel across dimensions without being ready");
        this.add("gui.aoa3.adventGui.help.tip.11", "The official wiki has all the info you need");
        this.add("gui.aoa3.adventGui.help.tip.12", "Install Patchouli to get access to AoA books");
        this.add("gui.aoa3.adventGui.help.tip.2", "Skills offer various benefits and powers");
        this.add("gui.aoa3.adventGui.help.tip.3", "Don't start fights that you can't win");
        this.add("gui.aoa3.adventGui.help.tip.4", "Join the Discord server to get involved!");
        this.add("gui.aoa3.adventGui.help.tip.5", "All guns require some form of ammo to fire");
        this.add("gui.aoa3.adventGui.help.tip.6", "Mix and match armour pieces for better results");
        this.add("gui.aoa3.adventGui.help.tip.7", "Different dimensions have different resources");
        this.add("gui.aoa3.adventGui.help.title", "Welcome to Advent of Ascension!");
        this.add("gui.aoa3.adventGui.stats", "Stats");
        this.add("gui.aoa3.adventGui.stats.level", "Lvl: %1$s");
        this.add("gui.aoa3.adventGui.stats.tribute", "Tribute");
        this.add("gui.aoa3.adventGui.stats.xp", "Xp: %1$s/%2$s");
        this.add("gui.aoa3.adventGui.title", "Advent of Ascension Window");
        this.add("gui.aoa3.adventGui.update", "Update Available! New Version: %1$s");
        this.add("gui.aoa3.adventGui.lore", "Lore");
        this.add("gui.aoa3.adventGui.lore.patchouli", "Requires Patchouli.");
        this.add("gui.aoa3.adventGui.lore.clickBook", "Click to open");
        this.add("gui.aoa3.realmstone.title", "Deity Challenges");
        this.add("gui.aoa3.resources.showtip", "Press '%1$s' for resources.");
        this.add("gui.aoa3.skills.showtip", "Press '%1$s' for skills.");
        this.add("gui.aoa3.adventGui.player.totalLevel", "Total Level");
        this.add("gui.aoa3.adventGui.player.skillLevel", "Level");
        this.add("gui.aoa3.adventGui.player.skillCycles", "Cycles");
        this.add("gui.aoa3.adventGui.player.skillXp", "Xp");
        this.add("gui.aoa3.adventGui.player.skillXpRemaining", "Xp Remaining");
        this.add("gui.aoa3.adventGui.player.skillProgress", "Progress to Level");
        this.add("gui.aoa3.adventGui.player.noSkills", "Skills have been disabled by the server owner");
        this.add("gui.aoa3.adventGui.player.abilities", "Abilities");
        this.add("gui.aoa3.adventGui.player.addCycle", "Add Cycle");
        this.add("gui.aoa3.adventGui.player.addCycle.confirm", "Are you sure?");
        this.add("gui.aoa3.adventGui.player.cycleHover", "Reset your level to 1 and increase your cycles for %1$s");
        this.add("gui.aoa3.selectItem.title", "Select Item");
        this.add("gui.aoa3.selectItem.select", "Select %1$s");
        this.add("gui.aoa3.selectItem.remove", "Remove Selection");
        this.add("gui.aoatoast.levelReq.subtitle", "%2$s %1$s required");
        this.add("gui.aoatoast.levelReq.title", "You need a higher level!");
        this.add("gui.aoatoast.resourceReq.subtitle", "%2$s %1$s required");
        this.add("gui.aoatoast.resourceReq.title", "Not enough resources!");
        this.add("gui.aoatoast.abilityUnlock.subtitle", "%1$s");
        this.add("gui.aoatoast.abilityUnlock.title", "Ability Unlocked!");
        this.add("gui.misc.skills.xp", "%1$sxp");
        this.add("gui.realmstoneMenu.hover.abyss", "Summon a Wither in the Nether");
        this.add("gui.realmstoneMenu.hover.barathos", "Kill a Husk with a Blank Realmstone");
        this.add("gui.realmstoneMenu.hover.candyland", "Eat a Heart Fruit in Precasia");
        this.add("gui.realmstoneMenu.hover.celeve", "Kill a Lelyetian Warrior with a Firework");
        this.add("gui.realmstoneMenu.hover.creeponia", "Survive a hit from a Creeper while a TNT is about to explode next to you");
        this.add("gui.realmstoneMenu.hover.crystevia", "Use a Deep Crystal on a Case Construct");
        this.add("gui.realmstoneMenu.hover.deeplands", "Mine an ore block down at Bedrock level");
        this.add("gui.realmstoneMenu.hover.dustopia", "Summon Shadowlord while night vision is active");
        this.add("gui.realmstoneMenu.hover.gardencia", "Throw a Blank Realmstone into a Carrot Crop in Precasia, then defeat your creation");
        this.add("gui.realmstoneMenu.hover.greckon", "Use some Nightmare Flakes on Elusive");
        this.add("gui.realmstoneMenu.hover.haven", "Kill a Flye with melee while high up in the Lelyetian trees");
        this.add("gui.realmstoneMenu.hover.iromine", "Use a Blank Realmstone on a Mineralization Station");
        this.add("gui.realmstoneMenu.hover.lborean", "Let a Gardencian creature soak in Candied Water, then kill it");
        this.add("gui.realmstoneMenu.hover.lelyetia", "Take a fall of at least 26 blocks");
        this.add("gui.realmstoneMenu.hover.lunalus", "Jump over the void in Haven With a Gravitator");
        this.add("gui.realmstoneMenu.hover.mysterium", "Kill a Creepird while you are poisoned");
        this.add("gui.realmstoneMenu.hover.nether", "Throw out a Blank Realmstone while submerged in lava");
        this.add("gui.realmstoneMenu.hover.nowhere", "Combine a Blank Realmstone with a Shulker Box, a Golden Apple, an End Crystal, and a Beacon");
        this.add("gui.realmstoneMenu.hover.overworld", "Carry this Realmstone with you, and complete their tasks..");
        this.add("gui.realmstoneMenu.hover.precasia", "Combine a Blank Realmstone with one of each Overworld Sapling");
        this.add("gui.realmstoneMenu.hover.runandor", "Take a Vox Light to Mysterium and place a Blank Realmstone and Runic Energy on top of it, then activate it with an Active Rune Stone");
        this.add("gui.realmstoneMenu.hover.shyrelands", "Combine a Blank Realmstone and some Magic Mending Solution with a Haunted Flower, Glowstone, Darkly Powder, and a Bloodstone");
        this.add("gui.realmstoneMenu.hover.vox_ponds", "Show any Creeponian trader in Creeponia your Blank Realmstone while wearing a Hazmat Suit");
        this.add("key.aoa3.adventGui", "Toggle AoA Window");
        this.add("key.aoa3.resources", "Toggle Resources Display");
        this.add("key.aoa3.skills", "Toggle Skills Display");
        this.add("key.aoa3.abilityAction", "Activate Skill Ability");
        this.add("key.categories.aoa3", "AoA3 Keys");
        this.add("message.dialogue.creeponiaBlankRealmstone.0", "I've heard legends of these things. Here, I'll give you this for it.");
        this.add("message.dialogue.creeponiaBlankRealmstone.1", "Take this, I have a strange urge to give it to you..");
        this.add("message.dialogue.creeponiaBlankRealmstone.2", "Woah, as soon as you came to me this weird stone appeared in my pocket. Do you know what it is?");
        this.add("message.dialogue.gorb_citizen.0", "Gorb: A human! How did you get here?");
        this.add("message.dialogue.gorb_citizen.1", "Gorb: Aren't you cold down here human?");
        this.add("message.dialogue.gorb_citizen.2", "Gorb: Have you seen any green mushrooms around here? Someone told me eating one gives you an extra life.");
        this.add("message.dialogue.gorb_citizen.3", "Gorb: All these glowing mushrooms make this place so bright it hurts!");
        this.add("message.dialogue.gorb_citizen.4", "Gorb: Hello.");
        this.add("message.dialogue.primordial_guide.0", "Primordial Guide: Beware the red eyes, they are not a good omen.");
        this.add("message.dialogue.primordial_guide.1", "Primordial Guide: Legends tell of a group of Primordial warriors that once roamed the lands.");
        this.add("message.dialogue.primordial_guide.2", "Primordial Guide: Be careful of Stalkers! They will sneak up on you before you know it.");
        this.add("message.dialogue.primordial_guide.3", "Primordial Guide: Stock up from the Primordial Merchants before you leave.");
        this.add("message.dialogue.primordial_guide.4", "Primordial Guide: Merkyres live in towers that are located throughout Dustopia.");
        this.add("message.dialogue.primordial_guide.5", "Primordial Guide: You will need a source of light with you if you intend to journey about.");
        this.add("message.dialogue.primordial_guide.6", "Primordial Guide: There are very dangerous creatures around here. Luckily most are locked up.");
        this.add("message.dialogue.primordial_guide.7", "Primordial Guide: The darkness is ever-present in this world.");
        this.add("message.dialogue.zal_child.0", "Zal Child: Hello weirdo!");
        this.add("message.dialogue.zal_child.1", "Zal Child: I'm not supposed to talk to strangers.");
        this.add("message.dialogue.zal_child.2", "Zal Child: Catch me if you can!");
        this.add("message.dialogue.zal_child.3", "Zal Child: You have a big head.");
        this.add("message.dialogue.zal_child.4", "Zal Child: You're so ugly!");
        this.add("message.dialogue.zal_citizen.0", "Zal Citizen: Be careful mining into lunar geodes, they're often infested!");
        this.add("message.dialogue.zal_citizen.1", "Zal Citizen: I dropped my silver coin and can't seem to find it anywhere.");
        this.add("message.dialogue.zal_citizen.2", "Zal Citizen: Have you seen him? I've seen him once, but everyone says I'm crazy. He's out there, I know it!");
        this.add("message.dialogue.zal_citizen.3", "Zal Citizen: You look weird.");
        this.add("message.dialogue.zal_citizen.4", "Zal Citizen: How do you see anything from up there?");
        this.add("message.dialogue.zal_citizen.alienOrb", "Zal Citizen: You shouldn't have brought that here! Get it away from me!");
        this.add("message.feedback.crystalExtensionShrine.crystals", "The shrine needs more crystals to absorb");
        this.add("message.feedback.item.returnCrystal.noSpace", "You do not have enough inventory space to carry a return crystal!");
        this.add("message.feedback.item.rosidons.dimFail", "There is no surface in this world!");
        this.add("message.feedback.item.rosidons.noHeightFail", "Nothing interesting happens.");
        this.add("message.feedback.item.skillCrystal.levelFail", "You must have at least one skill at level %1$s to use this skill crystal.");
        this.add("message.feedback.krorAltar.chargingTable", "The altar needs to be charged, and seems to be missing something..");
        this.add("message.feedback.minionSlab.maxMinions", "Max concurrent minion limit reached (%1$s).");
        this.add("message.feedback.runeShrine.practice", "A rune won't form without rune posts nearby, but you learn a little from the conversion of energy.");
        this.add("message.feedback.spawnBoss.difficultyFail", "You can't summon bosses in peaceful!");
        this.add("message.feedback.spawnBoss.noSpace", "There isn't enough space to summon this boss!");
        this.add("message.feedback.teleporterFrame.existing", "The portal remains lit, but it doesn't seem to require your key again.");
        this.add("message.feedback.teleporterFrame.fail", "Nothing happens. Maybe there is something missing?");
        this.add("message.feedback.wornBook.droppedRealmstone", "As you open the book, a strange item drops out.");
        this.add("message.feedback.yetiFingernails.eat", "You feel less stressed, though that probably wasn't good for your teeth");
        this.add("message.feedback.nowhere.enderPearl", "Ender Pearls cannot be used in Nowhere.");
        this.add("message.feedback.nowhere.chorusFruit", "Chorus Fruit cannot be used in Nowhere.");
        this.add("message.feedback.nowhere.teleport", "You cannot freely teleport in Nowhere.");
        this.add("message.feedback.runeShrine.blocked", "The rune post needs a block free above it to operate.");
        this.add("message.feedback.insufficientLevels", "You need at least level %2$s %1$s to perform this action.");
        this.add("message.feedback.insufficientResource", "You need at least %2$s remaining %1$s to perform this action.");
        this.add("message.feedback.abilityUnlocked", "New ability unlocked for %1$s: %2$s. See the Advent GUI for more info.");
        this.add("message.login.welcome", "Welcome to Advent of Ascension! Press %1$s to view your stats");
        this.add("message.login.welcome.alt", "Welcome to Advent of Ascension! Check your settings to assign a key to open the main window");
        this.add("recipe.aoa3.frameBench", "Frame Bench");
        this.add("recipe.aoa3.imbuing", "Imbuing");
        this.add("recipe.aoa3.infusion", "Infusion");
        this.add("recipe.aoa3.upgradeKit", "Upgrade Kits");
        this.add("recipe.aoa3.whitewashing", "Whitewashing");
        this.add("recipe.aoa3.toolInteraction", "Tool Interaction");
        this.add("gui.tooltip.skillReq", "Skill requirements:");
        this.add("gui.tooltip.skillReq.hidden", "Has skill requirements");
        this.add("gui.tooltip.jei.imbuing", "Indicative only - recipe is for enchanting a compatible item");
        this.add("filled_map.aoa3.ruined_teleporter_frame", "Ruined Teleporter Frame Map");
    }
}

