/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.DynamicBucketModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.datagen.DataGenItems;
import net.tslat.aoa3.advent.datagen.packages.DataGenItemPackage;
import net.tslat.aoa3.common.registration.AoARegistries;

public class DataGenItemModels
extends ItemModelProvider {
    public DataGenItemModels(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "aoa3", fileHelper);
    }

    protected void registerModels() {
        this.generateBaseModels();
        this.generateSpawnEggModels();
        block12: for (DataGenItemPackage itemPackage : DataGenItems.ITEMS) {
            if (itemPackage.getModelType() == null) {
                ((Consumer)((Function)itemPackage.getLinkedObject("model_function")).apply(this)).accept(itemPackage);
                continue;
            }
            switch (itemPackage.getModelType()) {
                case HANDHELD: {
                    this.generateHandheldModel(itemPackage);
                    continue block12;
                }
                case GREATBLADE: {
                    this.generateGreatbladeModel(itemPackage);
                    continue block12;
                }
                case MAUL: {
                    this.generateMaulModel(itemPackage);
                    continue block12;
                }
                case GUN: {
                    this.generateGunModel(itemPackage);
                    continue block12;
                }
                case SMALL_GUN: {
                    this.generateSmallGunModel(itemPackage);
                    continue block12;
                }
                case STAFF: {
                    this.generateStaffModel(itemPackage);
                    continue block12;
                }
                case VULCANE: {
                    this.generateVulcaneModel(itemPackage);
                    continue block12;
                }
                case BOW: {
                    this.generateBowModel(itemPackage);
                    continue block12;
                }
                case CROSSBOW: {
                    this.generateCrossbowModel(itemPackage);
                    continue block12;
                }
                case BUCKET: {
                    this.generateBucketModel(itemPackage);
                    continue block12;
                }
            }
            this.generateBasicModel(itemPackage);
        }
    }

    private void generateBasicModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), this.mcLoc("item/generated"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateHandheldModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), this.mcLoc("item/handheld"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateBucketModel(DataGenItemPackage itemPackage) {
        Fluid fluid = (Fluid)itemPackage.getLinkedObject("fluid");
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), new ResourceLocation("forge", "item/bucket_drip"))).customLoader((builder, fileHelper) -> DynamicBucketModelBuilder.begin((ModelBuilder)builder, (ExistingFileHelper)fileHelper).fluid(fluid).applyFluidLuminosity(fluid.getAttributes().getLuminosity() > 0));
    }

    private void generateGreatbladeModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), new ResourceLocation("aoa3", "item/greatblade"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateMaulModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), new ResourceLocation("aoa3", "item/maul"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateGunModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), new ResourceLocation("aoa3", "item/gun"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateSmallGunModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), new ResourceLocation("aoa3", "item/small_gun"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateVulcaneModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), new ResourceLocation("aoa3", "item/vulcane_base"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateStaffModel(DataGenItemPackage itemPackage) {
        ((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), new ResourceLocation("aoa3", "item/staff"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
    }

    private void generateBowModel(DataGenItemPackage itemPackage) {
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), this.mcLoc("item/bow"))).texture("layer0", this.itemTexture(itemPackage.getItem()));
        model.override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_pulling_0", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_pulling_0"))).end();
        model.override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.65f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_pulling_1", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_pulling_1"))).end();
        model.override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.9f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_pulling_2", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_pulling_2"))).end();
    }

    private void generateCrossbowModel(DataGenItemPackage itemPackage) {
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString(), this.mcLoc("item/crossbow"))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_standby"));
        ModelBuilder.TransformsBuilder transforms = model.transforms();
        model.override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_pulling_0", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_pulling_0"))).end();
        model.override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.58f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_pulling_1", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_pulling_1"))).end();
        model.override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_pulling_2", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_pulling_2"))).end();
        model.override().predicate(new ResourceLocation("charged"), 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_arrow", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_arrow"))).end();
        model.override().predicate(new ResourceLocation("charged"), 1.0f).predicate(new ResourceLocation("firework"), 1.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(itemPackage.getRegistryName().toString() + "_firework", new ResourceLocation("aoa3", "item/" + itemPackage.getRegistryName().m_135815_()))).texture("layer0", DataGenItemModels.extend(this.itemTexture(itemPackage.getItem()), "_firework"))).end();
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-90.0f, 0.0f, -60.0f).translation(2.0f, 0.1f, -3.0f).scale(0.9f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(-90.0f, 0.0f, 30.0f).translation(2.0f, 0.1f, -3.0f).scale(0.9f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-90.0f, 0.0f, -55.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(-90.0f, 0.0f, 35.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f);
    }

    private void generateBaseModels() {
        this.generateGreatbladeBaseModel();
        this.generateMaulBaseModel();
        this.generateGunBaseModels();
        this.generateStaffBaseModel();
        this.generateVulcaneBaseModel();
    }

    private void generateStaffBaseModel() {
        ModelBuilder.TransformsBuilder transforms = ((ItemModelBuilder)this.withExistingParent("aoa3:staff", this.mcLoc("item/handheld"))).transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-80.0f, -90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-35.0f, -90.0f, -125.0f).translation(0.0f, 4.0f, 7.0f).scale(2.0f, 2.0f, 2.0f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(160.0f, 90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(210.0f, 90.0f, -125.0f).translation(0.0f, 4.0f, 6.0f).scale(2.0f, 2.0f, 2.0f);
    }

    private void generateVulcaneBaseModel() {
        ModelBuilder.TransformsBuilder transforms = ((ItemModelBuilder)this.withExistingParent("aoa3:vulcane_base", this.mcLoc("item/handheld"))).transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-80.0f, -90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-35.0f, -90.0f, -125.0f).translation(0.0f, 4.0f, 7.0f).scale(2.0f, 2.0f, 2.0f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(160.0f, 90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(210.0f, 90.0f, -125.0f).translation(0.0f, 4.0f, 6.0f).scale(2.0f, 2.0f, 2.0f);
    }

    private void generateGunBaseModels() {
        ModelBuilder.TransformsBuilder transforms = ((ItemModelBuilder)this.withExistingParent("aoa3:gun", this.mcLoc("item/handheld"))).transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-110.0f, -90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-65.0f, -90.0f, -125.0f).translation(0.0f, 9.0f, 2.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(130.0f, 90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(180.0f, 90.0f, -125.0f).translation(0.0f, 9.4f, 1.3f).scale(1.75f, 1.75f, 1.75f);
        transforms = ((ItemModelBuilder)this.withExistingParent("aoa3:small_gun", this.mcLoc("item/handheld"))).transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-110.0f, -90.0f, -120.0f).translation(1.2f, 2.5f, 1.0f).scale(1.25f, 1.25f, 1.25f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-65.0f, -90.0f, -125.0f).translation(0.0f, 5.0f, 2.0f).scale(1.25f, 1.25f, 1.25f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(130.0f, 90.0f, -120.0f).translation(1.2f, 2.5f, 0.0f).scale(1.25f, 1.25f, 1.25f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(180.0f, 90.0f, -125.0f).translation(0.0f, 5.4f, 1.5f).scale(1.25f, 1.25f, 1.25f);
    }

    private void generateGreatbladeBaseModel() {
        ModelBuilder.TransformsBuilder transforms = ((ItemModelBuilder)this.withExistingParent("aoa3:greatblade", this.mcLoc("item/handheld"))).transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-80.0f, -90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(160.0f, 90.0f, -120.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-65.0f, -90.0f, -125.0f).translation(0.0f, 15.0f, 6.0f).scale(2.0f, 2.0f, 2.0f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(180.0f, 90.0f, -125.0f).translation(0.0f, 15.0f, 5.0f).scale(2.0f, 2.0f, 2.0f);
    }

    private void generateMaulBaseModel() {
        ModelBuilder.TransformsBuilder transforms = ((ItemModelBuilder)this.withExistingParent("aoa3:maul", this.mcLoc("item/handheld"))).transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-80.0f, -90.0f, -120.0f).translation(1.2f, 10.0f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(160.0f, 90.0f, -120.0f).translation(1.2f, 10.0f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-65.0f, -90.0f, -125.0f).translation(0.0f, 15.0f, 6.0f).scale(2.0f, 2.0f, 2.0f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(180.0f, 90.0f, -125.0f).translation(0.0f, 15.0f, 5.0f).scale(2.0f, 2.0f, 2.0f);
    }

    private void generateSpawnEggModels() {
        AoARegistries.ITEMS.getAllAoARegisteredObjects().stream().filter(item -> item.get() instanceof SpawnEggItem).forEach(egg -> this.withExistingParent(egg.getId().toString(), this.mcLoc("item/template_spawn_egg")));
    }

    public void knightsGuardModel(DataGenItemPackage itemPackage) {
        Item item = itemPackage.getItem();
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString(), new ResourceLocation("aoa3", "item/greatblade"))).texture("layer0", this.itemTexture(item));
        ItemModelBuilder blockingModel = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString() + "_blocking", new ResourceLocation("aoa3", "item/knights_guard"))).texture("layer0", DataGenItemModels.extend(this.itemTexture(item), "_blocking"));
        ModelBuilder.TransformsBuilder transforms = blockingModel.transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(30.0f, 326.0f, 0.0f).translation(-0.3f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(30.0f, 144.0f, 0.0f).translation(1.2f, -0.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-65.0f, -90.0f, -125.0f).translation(0.0f, 15.0f, 6.0f).scale(2.0f, 2.0f, 2.0f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(180.0f, 90.0f, -125.0f).translation(0.0f, 15.0f, 5.0f).scale(2.0f, 2.0f, 2.0f);
        model.override().predicate(new ResourceLocation("blocking"), 1.0f).model((ModelFile)blockingModel);
    }

    public void chainsawModel(DataGenItemPackage itemPackage) {
        Item item = itemPackage.getItem();
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString(), this.mcLoc("item/handheld"))).texture("layer0", this.itemTexture(item));
        ModelBuilder.TransformsBuilder transforms = model.transforms();
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-110.0f, -90.0f, -120.0f).translation(1.2f, 2.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(130.0f, 90.0f, -120.0f).translation(1.2f, 2.7f, 0.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(-65.0f, -90.0f, -125.0f).translation(0.0f, 9.0f, 2.0f).scale(1.75f, 1.75f, 1.75f);
        transforms.transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(180.0f, 90.0f, -125.0f).translation(0.0f, 9.4f, 1.3f).scale(1.75f, 1.75f, 1.75f);
    }

    public void expFlaskModel(DataGenItemPackage itemPackage) {
        Item item = itemPackage.getItem();
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString(), this.mcLoc("item/handheld"))).texture("layer0", this.itemTexture(item));
        ItemModelBuilder filledModel = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString() + "_filled", this.mcLoc("item/handheld"))).texture("layer0", DataGenItemModels.extend(this.itemTexture(item), "_filled"));
        model.override().predicate(new ResourceLocation("filled"), 1.0f).model((ModelFile)filledModel);
    }

    public void rodModel(DataGenItemPackage itemPackage) {
        Item item = itemPackage.getItem();
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString(), this.mcLoc("item/handheld_rod"))).texture("layer0", this.itemTexture(item));
        ItemModelBuilder castModel = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString() + "_cast", model.getUncheckedLocation())).texture("layer0", DataGenItemModels.extend(this.itemTexture(item), "_cast"));
        model.override().predicate(new ResourceLocation("cast"), 1.0f).model((ModelFile)castModel);
    }

    public void paralyzerModel(DataGenItemPackage itemPackage) {
        Item item = itemPackage.getItem();
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString(), new ResourceLocation("aoa3", "item/gun"))).texture("layer0", this.itemTexture(item));
        ItemModelBuilder model0 = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString() + "_0", new ResourceLocation("aoa3", "item/gun"))).texture("layer0", DataGenItemModels.extend(this.itemTexture(item), "_0"));
        ItemModelBuilder model1 = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString() + "_1", new ResourceLocation("aoa3", "item/gun"))).texture("layer0", DataGenItemModels.extend(this.itemTexture(item), "_1"));
        model.override().predicate(new ResourceLocation("firing"), 1.0f).predicate(new ResourceLocation("firing_tick_modulo"), 1.0f).model((ModelFile)model0);
        model.override().predicate(new ResourceLocation("firing"), 1.0f).predicate(new ResourceLocation("firing_tick_modulo"), 2.0f).model((ModelFile)model1);
    }

    public void guardiansSwordModel(DataGenItemPackage itemPackage) {
        Item item = itemPackage.getItem();
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString(), this.mcLoc("item/handheld"))).texture("layer0", this.itemTexture(item));
        ItemModelBuilder chargedModel = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).toString() + "_charged", this.mcLoc("item/handheld"))).texture("layer0", DataGenItemModels.extend(this.itemTexture(item), "_charged"));
        model.override().predicate(new ResourceLocation("charged"), 1.0f).model((ModelFile)chargedModel);
    }

    public ResourceLocation itemTexture(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        return new ResourceLocation(itemId.m_135827_(), "item/" + itemId.m_135815_());
    }

    public static ResourceLocation extend(ResourceLocation path, String pathExtension) {
        return new ResourceLocation(path.m_135827_(), path.m_135815_() + pathExtension);
    }

    public static enum ModelType {
        BASIC,
        HANDHELD,
        GREATBLADE,
        MAUL,
        GUN,
        SMALL_GUN,
        VULCANE,
        BUCKET,
        STAFF,
        BOW,
        CROSSBOW;

    }
}

