/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.datagen.builder.aoaplayer.HaulingFishBuilder;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.common.registration.item.AoAItems;
import org.apache.logging.log4j.Level;

public class DataGenHaulingFish
implements DataProvider {
    private final DataGenerator generator;
    private static final ArrayList<HaulingFishBuilder> HAULING_FISH_MAP = new ArrayList();

    public DataGenHaulingFish(DataGenerator generator) {
        this.generator = generator;
    }

    private void registerHaulingFishLists() {
        new HaulingFishBuilder("fish_default").entity(EntityType.f_20556_, 1000, -50.0f).entity(EntityType.f_20519_, 1000, -50.0f).entity(EntityType.f_20489_, 1000, -50.0f).entity(EntityType.f_20516_, 900, -45.0f, 5).entity(EntityType.f_20480_, 300, 5.0f, 10).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 350, 40.0f).entity((EntityType)AoAAnimals.SAILBACK.get(), 800, 30.0f).entity((EntityType)AoAAnimals.VIOLET_SKIPPER.get(), 800, 30.0f).entity(EntityType.f_20559_, 200, 10.0f, 30).item(Items.f_42715_, 400, 5.0f, 20).item(Items.f_42656_, 600, 5).item(Items.f_42454_, 900, -100.0f, 14).item(AoAItems.CRYSTAL_BOX, 250, 15.0f, 25).item(AoAItems.GEM_BAG, 250, 15.0f, 15).item(AoAItems.TREASURE_BOX, 250, 15.0f, 30).item(AoAItems.WEAPONS_CASE, 250, 15.0f, 20).item(AoAItems.OLD_BOOT, 5, 5.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("traps_lava_default").entity((EntityType)AoAMiscEntities.FAKE_TNT.get(), 200).entity(EntityType.f_20468_, 180).entity(EntityType.f_20497_, 100, 2.0f).entity(EntityType.f_20551_, 130).entity(EntityType.f_20531_, 100).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("fish_lava_default").entity((EntityType)AoAAnimals.CRIMSON_SKIPPER.get(), 200).entity((EntityType)AoAAnimals.CRIMSON_STRIPEFISH.get(), 200).entity((EntityType)AoAAnimals.CHARRED_CHAR.get(), 150).entity((EntityType)AoAAnimals.CANDLEFISH.get(), 150).item(Items.f_41999_, 100).item(Items.f_42754_, 25, 2.0f).item(Items.f_42415_, 50, 5.0f).item(Items.f_42616_, 35, 7.0f).item(Items.f_42413_, 120, -10.0f).item(Items.f_42448_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("barathos_fish").biomes(AdventOfAscension.id("barren_grounds")).entity((EntityType)AoAAnimals.SKELECANTH.get(), 200).item(Items.f_41866_, 200, -20.0f).item(Items.f_42499_, 190, -20.0f).item(Items.f_42500_, 180, -15.0f).item(Items.f_41830_, 160, -10.0f).item(Items.f_42461_, 140).item(Items.f_41831_, 150, -10.0f).item(AoAItems.HIVE_CHUNK, 100, 20.0f).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("creeponia_fish").biomes(AdventOfAscension.id("creepoid_forest")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity(EntityType.f_20489_, 180, -5.0f).entity(EntityType.f_20516_, 150, 5).entity((EntityType)AoAAnimals.ROCKETFISH.get(), 140, 20.0f).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item((Item)AoAItems.UNSTABLE_GUNPOWDER.get(), 90, 10.0f).item(AoAItems.GEM_BAG, 30, 5.0f, 15).item(AoAItems.SHINY_BOX, 30, 5.0f, 10).item(AoAItems.TREASURE_BOX, 30, 5.0f, 30).item(AoAItems.WEAPONS_CASE, 30, 5.0f, 20).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("deeplands_fish").biomes(AdventOfAscension.id("cavern_depths")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity((EntityType)AoAAnimals.IRONBACK.get(), 150, 20.0f).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.PEARL_STRIPEFISH.get(), 150, 20.0f).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item((Item)AoAItems.DENSE_ROCK.get(), 90, 10).item(AoAItems.CRYSTAL_BOX, 30, 5.0f, 25).item(AoAItems.GEM_BAG, 30, 5.0f, 15).item(AoAItems.SHINY_BOX, 30, 5.0f, 10).item(AoAItems.TREASURE_BOX, 30, 5.0f, 30).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("precasia_fish").biomes(AdventOfAscension.id("precasian_tall_forest")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity(EntityType.f_20489_, 180, -5.0f).entity(EntityType.f_20516_, 150, 5).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.SAILBACK.get(), 140, 20.0f).entity((EntityType)AoAAnimals.DARK_HATCHETFISH.get(), 140, 20.0f).item(Items.f_42715_, 65, 5.0f, 20).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item((Item)AoAItems.SHARP_CLAW.get(), 90, 8.0f).item((Item)AoAItems.JUNGLE_THORNS.get(), 90, 8.0f).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("shyrelands_fish").biomes(AdventOfAscension.id("shyre_remnants")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity(EntityType.f_20489_, 180, -5.0f).entity(EntityType.f_20516_, 150, 5).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.SAILBACK.get(), 140, 20.0f).entity((EntityType)AoAAnimals.TURQUOISE_STRIPEFISH.get(), 140, 20.0f).item(Items.f_42715_, 65, 5.0f, 20).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item((Item)AoAItems.WHITEWASHING_SOLUTION.get(), 90, 10.0f).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.GEM_BAG, 35, 5.0f, 15).item(AoAItems.RUNE_BOX, 35, 5.0f, 5).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.WEAPONS_CASE, 35, 5.0f, 20).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("lunalus_fish").biomes(AdventOfAscension.id("asteroid_belt")).item(Items.f_41905_, 200).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("lborean_fish").biomes(AdventOfAscension.id("coral_fields")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity(EntityType.f_20489_, 180, -5.0f).entity(EntityType.f_20516_, 150, 5).entity(EntityType.f_20480_, 80, 10).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.SAILBACK.get(), 150, 20.0f).entity((EntityType)AoAAnimals.REEFTOOTH.get(), 120, 20.0f).entity(EntityType.f_20559_, 40, 30).item(Items.f_42715_, 65, 5.0f, 20).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.GEM_BAG, 35, 5.0f, 15).item(AoAItems.RUNE_BOX, 35, 5.0f, 5).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.WEAPONS_CASE, 35, 5.0f, 20).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("greckon_fish").biomes(AdventOfAscension.id("greckon_mountains")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity(EntityType.f_20516_, 150, 5).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.SAPPHIRE_STRIDER.get(), 140, 20.0f).item(Items.f_42678_, 50, 5.0f).item(Items.f_42681_, 50, 5.0f).item(Items.f_42715_, 65, 5.0f, 20).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.GEM_BAG, 35, 5.0f, 15).item(AoAItems.RUNE_BOX, 35, 5.0f, 5).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.WEAPONS_CASE, 35, 5.0f, 20).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("dustopia_fish").biomes(AdventOfAscension.id("dustopian_forest")).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 45, 10.0f).entity((EntityType)AoAAnimals.PEARL_STRIPEFISH.get(), 140, 10.0f).item(Items.f_42498_, 200, -10.0f).item(Items.f_42490_, 200, -10.0f).item(Items.f_42491_, 200, -10.0f).item(Items.f_42416_, 100, 15.0f).item(Items.f_42749_, 120, 10.0f).item(AoAItems.DARKLY_POWDER, 90, 10.0f).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("vox_ponds_fish").biomes(AdventOfAscension.id("vox_wastes")).entity((EntityType)AoAAnimals.HYDRONE.get(), 80, 20.0f).item(Items.f_42398_, 200, -20.0f).item(Items.f_41866_, 200, -20.0f).item(Items.f_42675_, 100).item(AoAItems.TOXIC_LUMP, 90, 10.0f).item(((Block)AoABlocks.VOX_LOG.get()).m_5456_(), 160, -20.0f).item(((LiquidBlock)AoABlocks.TOXIC_WASTE.get()).getFluid().m_6859_(), 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("mysterium_fish").biomes(AdventOfAscension.id("fungal_caverns")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity(EntityType.f_20489_, 180, -5.0f).entity(EntityType.f_20516_, 150, 5.0f, 5).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.SAILBACK.get(), 140, 20.0f).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.GEM_BAG, 35, 5.0f, 15).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.WEAPONS_CASE, 35, 5.0f, 20).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("iromine_fish").biomes(AdventOfAscension.id("iromine")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.IRONBACK.get(), 140, 20.0f).item(Items.f_42749_, 120, 5.0f).item(Items.f_42587_, 110, 7.0f).item(Items.f_42417_, 90, 11.0f).item(Items.f_42416_, 100, 9.0f).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("crystevia_fish").biomes(AdventOfAscension.id("crystevian_caverns")).entity(EntityType.f_20556_, 200, -10.0f).entity(EntityType.f_20519_, 200, -10.0f).entity(EntityType.f_20489_, 180, -5.0f).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 25, 8.0f).entity((EntityType)AoAAnimals.BLUE_GEMTRAP.get(), 25, 8.0f).entity((EntityType)AoAAnimals.GREEN_GEMTRAP.get(), 25, 8.0f).entity((EntityType)AoAAnimals.PURPLE_GEMTRAP.get(), 25, 8.0f).entity((EntityType)AoAAnimals.RED_GEMTRAP.get(), 25, 8.0f).entity((EntityType)AoAAnimals.WHITE_GEMTRAP.get(), 25, 8.0f).entity((EntityType)AoAAnimals.YELLOW_GEMTRAP.get(), 25, 8.0f).item(AoAItems.BLUE_DRUSE, 20, 5.0f).item(AoAItems.GREEN_DRUSE, 20, 5.0f).item(AoAItems.PURPLE_DRUSE, 20, 5.0f).item(AoAItems.RAINBOW_DRUSE, 30, 10.0f).item(AoAItems.RED_DRUSE, 20, 5.0f).item(AoAItems.WHITE_DRUSE, 20, 5.0f).item(AoAItems.YELLOW_DRUSE, 20, 5.0f).item(Items.f_42656_, 100, 5).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.GEM_BAG, 35, 5.0f, 15).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("celeve_fish").biomes(AdventOfAscension.id("celevian_highlands")).entity(EntityType.f_20489_, 200, -5.0f).entity(EntityType.f_20516_, 180, 5).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.SAILBACK.get(), 140, 20.0f).item(AoAItems.CONFETTI_PILE, 90, 10.0f).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item(AoAItems.GEM_BAG, 35, 5.0f, 15).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.WEAPONS_CASE, 35, 5.0f, 20).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("celeve_traps").biomes(AdventOfAscension.id("celevian_highlands")).forTraps().entity((EntityType)AoAMiscEntities.FAKE_TNT.get(), 200).entity((EntityType)AoAMobs.HAPPY.get(), 150).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("candyland_fish").biomes(AdventOfAscension.id("candy_hills")).entity((EntityType)AoAAnimals.JAMFISH.get(), 120, 10.0f).entity((EntityType)AoAAnimals.CHOCAW.get(), 120, 10.0f).item(Items.f_42533_, 150, -10.0f).item(Items.f_42501_, 200, -20.0f).item(AoAItems.CRYSTAL_BOX, 35, 5.0f, 25).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.WEAPONS_CASE, 35, 5.0f, 20).item(((LiquidBlock)AoABlocks.CANDIED_WATER.get()).getFluid().m_6859_(), 1).finalize(HAULING_FISH_MAP);
        new HaulingFishBuilder("abyss_fish").biomes(AdventOfAscension.id("abyssal_plains")).entity(EntityType.f_20516_, 300, -20.0f).entity((EntityType)AoAAnimals.RAINBOWFISH.get(), 50, 10.0f).entity((EntityType)AoAAnimals.RAZORFISH.get(), 140, 20.0f).entity((EntityType)AoAAnimals.PARAPIRANHA.get(), 140, 20.0f).item(Items.f_42656_, 100, 5).item(Items.f_42454_, 120, -20.0f, 14).item(AoAItems.SHINY_BOX, 35, 5.0f, 10).item(AoAItems.TREASURE_BOX, 35, 5.0f, 30).item(AoAItems.OLD_BOOT, 1, 2.0f, 50).item(Items.f_42447_, 1).finalize(HAULING_FISH_MAP);
    }

    public void m_213708_(CachedOutput cache) {
        this.registerHaulingFishLists();
        try {
            for (HaulingFishBuilder entry : HAULING_FISH_MAP) {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)entry.toJson(), (Path)this.generator.m_123916_().resolve("data/aoa3/player/misc/hauling_fish/" + entry.getId().m_135815_() + ".json"));
            }
        }
        catch (IOException ex) {
            Logging.logMessage(Level.ERROR, "Error while generating hauling fish lists.", ex);
        }
    }

    public String m_6055_() {
        return "Hauling Fish";
    }
}

