/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fluids.FluidAttributes;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.advent.datagen.DataGenBlocks;
import net.tslat.aoa3.advent.datagen.builder.CompactBlockModelBuilder;
import net.tslat.aoa3.advent.datagen.packages.DataGenBlockPackage;
import net.tslat.aoa3.content.block.decoration.misc.CarpetBlock;
import net.tslat.aoa3.content.block.functional.light.LampBlock;
import net.tslat.aoa3.content.block.generation.grass.GrassBlock;
import org.apache.logging.log4j.Level;

public final class DataGenBlockModels
extends BlockStateProvider {
    public DataGenBlockModels(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "aoa3", fileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateBaseModels();
        for (DataGenBlockPackage blockPackage : DataGenBlocks.BLOCKS) {
            if (blockPackage.getModelType() == null) {
                ((Consumer)((Function)blockPackage.getLinkedObject("model_function")).apply(this)).accept(blockPackage);
                continue;
            }
            try {
                switch (blockPackage.getModelType()) {
                    case GRASS: {
                        this.generateGrassBlockModel(blockPackage);
                        break;
                    }
                    case STAIRS: {
                        this.generateStairsBlockModel(blockPackage);
                        break;
                    }
                    case SLAB: {
                        this.generateSlabBlockModel(blockPackage);
                        break;
                    }
                    case FENCE: {
                        this.generateFenceBlockModel(blockPackage);
                        break;
                    }
                    case FENCE_GATE: {
                        this.generateFenceGateBlockModel(blockPackage);
                        break;
                    }
                    case WALL: {
                        this.generateWallBlockModel(blockPackage);
                        break;
                    }
                    case CROSS: {
                        this.generateCrossBlockModel(blockPackage);
                        break;
                    }
                    case VINE: {
                        this.generateVineBlockModel(blockPackage);
                        break;
                    }
                    case BARK: {
                        this.generateBarkBlockModel(blockPackage);
                        break;
                    }
                    case MUSHROOM: {
                        this.generateMushroomBlockModel(blockPackage);
                        break;
                    }
                    case SHROOM: {
                        this.generateShroomBlockModel(blockPackage);
                        break;
                    }
                    case ORE: {
                        this.generateOreBlockModel(blockPackage);
                        break;
                    }
                    case DIRECTIONAL: {
                        this.generateDirectionalBlockModel(blockPackage);
                        break;
                    }
                    case CARPET: {
                        this.generateCarpetBlockModel(blockPackage);
                        break;
                    }
                    case PRESSURE_PLATE: {
                        this.generatePressurePlateBlockModel(blockPackage);
                        break;
                    }
                    case BUTTON: {
                        this.generateButtonBlockModel(blockPackage);
                        break;
                    }
                    case CROP: {
                        this.generateCropBlockModel(blockPackage);
                        break;
                    }
                    case HANGING_CROP: {
                        this.generateHangingCropBlockModel(blockPackage);
                        break;
                    }
                    case MULTI_SIDE: {
                        this.generateMultiSideBlockModel(blockPackage);
                        break;
                    }
                    case HORIZONTAL_LINKED: {
                        this.generateHorizontalLinkedBlockModel(blockPackage);
                        break;
                    }
                    case LAMP: {
                        this.generateLampBlockModel(blockPackage);
                        break;
                    }
                    case LADDER: {
                        this.generateLadderBlockModel(blockPackage);
                        break;
                    }
                    case FLUID: {
                        this.generateFluidBlockModel(blockPackage);
                        break;
                    }
                    case BASIC_LINKED: {
                        this.generateBasicLinkedModel(blockPackage);
                        break;
                    }
                    case BASIC: {
                        this.generateBasicBlockModel(blockPackage);
                        break;
                    }
                    case POTTED_PLANT: {
                        this.generatePottedPlantBlockModel(blockPackage);
                        break;
                    }
                    case NONE: {
                        this.generateEmptyBlockModel(blockPackage);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Model type not prepped for datagen: " + blockPackage.getModelType().toString());
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                if (!ex.getLocalizedMessage().startsWith("Texture ")) {
                    throw ex;
                }
                Logging.logMessage(Level.WARN, "Missing texture for block: " + ex.getLocalizedMessage().substring(8, ex.getLocalizedMessage().indexOf("does")));
                ex.printStackTrace();
            }
        }
    }

    private void generateBasicBlockModel(DataGenBlockPackage blockPackage) {
        new CompactBlockModelBuilder((BlockStateProvider)this, blockPackage, true).vanillaParent("cube_all").defaultTextureRef("all").simpleBlockState().itemModel();
    }

    private void generateBasicLinkedModel(DataGenBlockPackage blockPackage) {
        new CompactBlockModelBuilder((BlockStateProvider)this, blockPackage, true).vanillaParent("cube_all").setTexture("all", this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("source_block")).get())).matchTextures("particle", "all").simpleBlockState().itemModel();
    }

    private void generateEmptyBlockModel(DataGenBlockPackage blockPackage) {
        CompactBlockModelBuilder<Block> modelBuilder = new CompactBlockModelBuilder<Block>(this, blockPackage.getBlock(), "", true);
        modelBuilder.stateBuilder().forAllStates(state -> new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
    }

    private void generateGrassBlockModel(DataGenBlockPackage blockPackage) {
        CompactBlockModelBuilder modelBuilder = new CompactBlockModelBuilder((BlockStateProvider)this, blockPackage, true);
        VariantBlockStateBuilder stateBuilder = modelBuilder.stateBuilder();
        modelBuilder.vanillaParent("cube_bottom_top").setTexture("side", DataGenBlockModels.extend(modelBuilder.getModelPath(), "_side")).setTexture("bottom", this.blockTexture(((GrassBlock)((Object)modelBuilder.getBlock())).getSoilBlock().get())).setTexture("top", DataGenBlockModels.extend(modelBuilder.getModelPath(), "_top")).matchTextures("particle", "side").itemModel();
        stateBuilder.partialState().with((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(false)).setModels(ConfiguredModel.allYRotations(modelBuilder, (int)0, (boolean)false));
        stateBuilder.partialState().with((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(modelBuilder)});
    }

    private void generateOreBlockModel(DataGenBlockPackage blockPackage) {
        CompactBlockModelBuilder builder = new CompactBlockModelBuilder((BlockStateProvider)this, blockPackage).modParent("overlay_cube").matchTextures("overlay", "texture").setTexture("texture", this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("source_block")).get())).matchTextures("particle", "texture").simpleBlockState();
        builder.itemModel();
        if (blockPackage.hasLinkedObject("overlay")) {
            builder.setTexture("overlay", this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("overlay")).get()));
        }
    }

    private void generateLampBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(outputPath.toString(), outputPath);
        BlockModelBuilder modelOff = (BlockModelBuilder)this.models().cubeAll(outputPath.toString() + "_off", DataGenBlockModels.extend(outputPath, "_off"));
        VariantBlockStateBuilder blockState = this.getVariantBuilder(block);
        blockState.partialState().with((Property)LampBlock.f_55654_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        blockState.partialState().with((Property)LampBlock.f_55654_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelOff)});
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)modelOff);
    }

    private void generateDirectionalBlockModel(DataGenBlockPackage blockPackage) {
        RotatedPillarBlock block = (RotatedPillarBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture((Block)block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(outputPath.toString(), outputPath, DataGenBlockModels.extend(outputPath, "_top"));
        BlockModelBuilder horizontalModel = (BlockModelBuilder)this.models().cubeColumnHorizontal(outputPath.toString() + "_horizontal", outputPath, DataGenBlockModels.extend(outputPath, "_top"));
        this.axisBlock(block, (ModelFile)model, (ModelFile)horizontalModel);
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateBarkBlockModel(DataGenBlockPackage blockPackage) {
        RotatedPillarBlock block = (RotatedPillarBlock)blockPackage.getBlock();
        ResourceLocation baseBlockOutputPath = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("log")).get());
        ResourceLocation outputPath = this.blockTexture((Block)block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(outputPath.toString(), baseBlockOutputPath, baseBlockOutputPath);
        BlockModelBuilder horizontalModel = (BlockModelBuilder)this.models().cubeColumnHorizontal(outputPath.toString() + "_horizontal", baseBlockOutputPath, baseBlockOutputPath);
        this.axisBlock(block, (ModelFile)model, (ModelFile)horizontalModel);
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateCarpetBlockModel(DataGenBlockPackage blockPackage) {
        CarpetBlock block = (CarpetBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().carpet(outputPath.toString(), outputPath)).texture("particle", outputPath);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generatePressurePlateBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        ResourceLocation texture = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("planks")).get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString(), this.mcLoc("block/pressure_plate_up"))).texture("texture", texture);
        BlockModelBuilder modelDown = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString() + "_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", texture);
        VariantBlockStateBuilder blockStateBuilder = this.getVariantBuilder(block);
        blockStateBuilder.partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        blockStateBuilder.partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelDown)});
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateButtonBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        ResourceLocation texture = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("source_object")).get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString(), this.mcLoc("block/button"))).texture("texture", texture);
        BlockModelBuilder modelPressed = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString() + "_pressed", this.mcLoc("block/button_pressed"))).texture("texture", texture);
        BlockModelBuilder modelInventory = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString() + "_inventory", this.mcLoc("block/button_inventory"))).texture("texture", texture);
        VariantBlockStateBuilder blockStateBuilder = this.getVariantBuilder(block);
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 90, 90, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 90, 270, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 90, 180, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 90, 0, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 180, 270, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 180, 90, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 180, 0, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 180, 180, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 90, 90, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 90, 270, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 90, 180, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 90, 0, true)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 180, 270, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 180, 90, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 180, 0, false)});
        blockStateBuilder.partialState().with((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelPressed, 180, 180, false)});
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)modelInventory);
    }

    private void generateCropBlockModel(DataGenBlockPackage blockPackage) {
        CropBlock block = (CropBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture((Block)block);
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder((Block)block);
        for (int i = 0; i <= 7; ++i) {
            String stage = outputPath.toString() + "_stage" + i;
            stateBuilder.partialState().with((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent(stage, this.mcLoc("block/crop"))).texture("crop", stage))});
        }
    }

    private void generateHangingCropBlockModel(DataGenBlockPackage blockPackage) {
        CropBlock block = (CropBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture((Block)block);
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder((Block)block);
        for (int i = 0; i <= 7; ++i) {
            String stage = outputPath.toString() + "_stage" + i;
            stateBuilder.partialState().with((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent(stage, this.mcLoc("block/cross"))).texture("cross", stage))});
        }
    }

    private void generatePottedPlantBlockModel(DataGenBlockPackage blockPackage) {
        FlowerPotBlock block = (FlowerPotBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture((Block)block);
        ResourceLocation flowerPath = this.blockTexture(block.m_53560_());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString(), this.mcLoc("block/flower_pot_cross"))).texture("plant", flowerPath);
        this.simpleBlock((Block)block, (ModelFile)model);
    }

    private void generateLadderBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString(), this.mcLoc("block/ladder"))).texture("texture", outputPath)).texture("particle", outputPath);
        VariantBlockStateBuilder blockState = this.getVariantBuilder(block);
        blockState.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        blockState.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 90, false)});
        blockState.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 180, false)});
        blockState.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.WEST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, 270, false)});
        ((ItemModelBuilder)this.itemModels().withExistingParent(blockPackage.getRegistryName().toString(), this.mcLoc("item/generated"))).texture("layer0", this.blockTexture(blockPackage.getBlock()));
    }

    private void generateFluidBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        FluidAttributes attributes = ((LiquidBlock)block).getFluid().getAttributes();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString())).texture("texture", attributes.getStillTexture());
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void generateMushroomBlockModel(DataGenBlockPackage blockPackage) {
        HugeMushroomBlock block = (HugeMushroomBlock)blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture((Block)block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString())).texture("texture", outputPath)).texture("particle", outputPath);
        BlockModelBuilder modelInside = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_inside")).texture("texture", DataGenBlockModels.extend(outputPath, "_inside"))).texture("particle", outputPath)).ao(false);
        BlockModelBuilder modelInventory = (BlockModelBuilder)this.models().cubeAll(outputPath.toString() + "_inventory", outputPath);
        MultiPartBlockStateBuilder stateBuilder = this.getMultipartBuilder((Block)block);
        model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH);
        modelInside.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH);
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)modelInventory);
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)model).addModel()).condition((Property)PipeBlock.f_55148_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)model).rotationY(90).uvLock(true).addModel()).condition((Property)PipeBlock.f_55149_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)model).rotationY(180).uvLock(true).addModel()).condition((Property)PipeBlock.f_55150_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)model).rotationY(270).uvLock(true).addModel()).condition((Property)PipeBlock.f_55151_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)model).rotationX(270).uvLock(true).addModel()).condition((Property)PipeBlock.f_55152_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)model).rotationX(90).uvLock(true).addModel()).condition((Property)PipeBlock.f_55153_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)modelInside).addModel()).condition((Property)PipeBlock.f_55148_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)modelInside).addModel()).condition((Property)PipeBlock.f_55148_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)modelInside).rotationY(90).uvLock(true).addModel()).condition((Property)PipeBlock.f_55149_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)modelInside).rotationY(180).uvLock(true).addModel()).condition((Property)PipeBlock.f_55150_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)modelInside).rotationY(270).uvLock(true).addModel()).condition((Property)PipeBlock.f_55151_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)modelInside).rotationX(270).uvLock(true).addModel()).condition((Property)PipeBlock.f_55152_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)stateBuilder.part().modelFile((ModelFile)modelInside).rotationX(90).uvLock(true).addModel()).condition((Property)PipeBlock.f_55153_, (Comparable[])new Boolean[]{false});
    }

    private void generateShroomBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString(), new ResourceLocation("aoa3", "shroom_block"))).texture("texture", outputPath)).texture("particle", outputPath);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateStairsBlockModel(DataGenBlockPackage blockPackage) {
        StairBlock block = (StairBlock)blockPackage.getBlock();
        String outputPath = this.blockTexture((Block)block).toString();
        ResourceLocation baseBlockOutputPath = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("source_block")).get());
        BlockModelBuilder model = (BlockModelBuilder)this.models().stairs(outputPath, baseBlockOutputPath, baseBlockOutputPath, baseBlockOutputPath);
        BlockModelBuilder modelInner = (BlockModelBuilder)this.models().stairsInner(outputPath + "_inner", baseBlockOutputPath, baseBlockOutputPath, baseBlockOutputPath);
        BlockModelBuilder modelOuter = (BlockModelBuilder)this.models().stairsOuter(outputPath + "_outer", baseBlockOutputPath, baseBlockOutputPath, baseBlockOutputPath);
        this.stairsBlock(block, (ModelFile)model, (ModelFile)modelInner, (ModelFile)modelOuter);
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateSlabBlockModel(DataGenBlockPackage blockPackage) {
        SlabBlock block = (SlabBlock)blockPackage.getBlock();
        String outputPath = this.blockTexture((Block)block).toString();
        ResourceLocation baseBlockOutputPath = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("source_block")).get());
        BlockModelBuilder model = (BlockModelBuilder)this.models().slab(outputPath, baseBlockOutputPath, baseBlockOutputPath, baseBlockOutputPath);
        BlockModelBuilder modelTop = (BlockModelBuilder)this.models().slabTop(outputPath + "_top", baseBlockOutputPath, baseBlockOutputPath, baseBlockOutputPath);
        this.slabBlock(block, (ModelFile)model, (ModelFile)modelTop, (ModelFile)this.models().getExistingFile(baseBlockOutputPath));
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateFenceBlockModel(DataGenBlockPackage blockPackage) {
        FenceBlock block = (FenceBlock)blockPackage.getBlock();
        String outputPath = this.blockTexture((Block)block).toString();
        ResourceLocation baseBlockOutputPath = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("planks")).get());
        BlockModelBuilder model = (BlockModelBuilder)this.models().fencePost(outputPath + "_fence_post", baseBlockOutputPath);
        BlockModelBuilder modelSide = (BlockModelBuilder)this.models().fenceSide(outputPath + "_fence_side", baseBlockOutputPath);
        BlockModelBuilder modelInventory = (BlockModelBuilder)this.models().fenceInventory(outputPath + "_fence_inventory", baseBlockOutputPath);
        this.fourWayBlock((CrossCollisionBlock)block, (ModelFile)model, (ModelFile)modelSide);
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)modelInventory);
    }

    private void generateCrossBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cross(outputPath.toString(), outputPath);
        this.simpleBlock(block, (ModelFile)model);
        ((ItemModelBuilder)this.itemModels().withExistingParent(blockPackage.getRegistryName().toString(), this.mcLoc("item/generated"))).texture("layer0", this.blockTexture(blockPackage.getBlock()));
    }

    private void generateVineBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder modelUp = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_up")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString())).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model1Up = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_1_up")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_2")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model2Up = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_2_up")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model2Opposite = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_2_opposite")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model2UpOpposite = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_2_up_opposite")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model3 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_3")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model3Up = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_3_up")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model4 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_4")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        BlockModelBuilder model4Up = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(outputPath.toString() + "_4_up")).ao(false)).texture("vine", outputPath)).texture("particle", outputPath);
        VariantBlockStateBuilder blockStateBuilder = this.getVariantBuilder(block);
        ModelBuilder.ElementBuilder element = model1.element().from(0.0f, 0.0f, 15.2f).to(16.0f, 16.0f, 15.2f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model1Up.element().from(0.0f, 15.2f, 0.0f).to(16.0f, 15.2f, 16.0f);
        element.shade(false);
        element.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model1Up.element().from(0.0f, 0.0f, 15.2f).to(16.0f, 16.0f, 15.2f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2.element().from(0.0f, 0.0f, 0.8f).to(16.0f, 16.0f, 0.8f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2Opposite.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2Opposite.element().from(0.8f, 0.0f, 0.0f).to(0.8f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2Up.element().from(0.0f, 15.2f, 0.0f).to(16.0f, 15.2f, 16.0f);
        element.shade(false);
        element.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2Up.element().from(0.0f, 0.0f, 0.8f).to(16.0f, 16.0f, 0.8f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2Up.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2UpOpposite.element().from(0.0f, 15.2f, 0.0f).to(16.0f, 15.2f, 16.0f);
        element.shade(false);
        element.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2UpOpposite.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model2UpOpposite.element().from(0.8f, 0.0f, 0.0f).to(0.8f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = modelUp.element().from(0.0f, 15.2f, 0.0f).to(16.0f, 15.2f, 16.0f);
        element.shade(false);
        element.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model3.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model3.element().from(0.0f, 0.0f, 15.2f).to(16.0f, 16.0f, 15.2f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model3.element().from(0.0f, 0.0f, 0.8f).to(16.0f, 16.0f, 0.8f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model3Up.element().from(0.0f, 15.2f, 0.0f).to(16.0f, 15.2f, 16.0f);
        element.shade(false);
        element.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model3Up.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model3Up.element().from(0.0f, 0.0f, 15.2f).to(16.0f, 16.0f, 15.2f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model3Up.element().from(0.0f, 0.0f, 0.8f).to(16.0f, 16.0f, 0.8f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4.element().from(0.8f, 0.0f, 0.0f).to(0.8f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4.element().from(0.0f, 0.0f, 15.2f).to(16.0f, 16.0f, 15.2f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4.element().from(0.0f, 0.0f, 0.8f).to(16.0f, 16.0f, 0.8f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4Up.element().from(0.0f, 15.2f, 0.0f).to(16.0f, 15.2f, 16.0f);
        element.shade(false);
        element.face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4Up.element().from(0.8f, 0.0f, 0.0f).to(0.8f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4Up.element().from(15.2f, 0.0f, 0.0f).to(15.2f, 16.0f, 16.0f);
        element.shade(false);
        element.face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4Up.element().from(0.0f, 0.0f, 15.2f).to(16.0f, 16.0f, 15.2f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element = model4Up.element().from(0.0f, 0.0f, 0.8f).to(16.0f, 16.0f, 0.8f);
        element.shade(false);
        element.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        element.face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#vine").tintindex(0);
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2Opposite)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2Opposite, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model4)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelUp)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1Up)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1Up, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1Up, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model1Up, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2Up)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2Up, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2Up, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2Up, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2UpOpposite)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2UpOpposite, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3Up)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3Up, 0, 90, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3Up, 0, 180, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(false)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model3Up, 0, 270, false)});
        blockStateBuilder.partialState().with((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true)).with((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model4Up)});
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockPackage.getRegistryName().toString())).parent((ModelFile)this.itemModels().getExistingFile(this.mcLoc("item/generated")))).texture("layer0", outputPath);
    }

    private void generateMultiSideBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        ResourceLocation outputPath = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(outputPath.toString(), outputPath, DataGenBlockModels.extend(outputPath, "_bottom"), DataGenBlockModels.extend(outputPath, "_top"));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateHorizontalLinkedBlockModel(DataGenBlockPackage blockPackage) {
        Block block = blockPackage.getBlock();
        Block linkedBlock = (Block)((Supplier)blockPackage.getLinkedObject("source_block")).get();
        ResourceLocation outputPath = this.blockTexture(block);
        ResourceLocation linkedTexture = this.blockTexture(linkedBlock);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(outputPath.toString(), outputPath, linkedTexture, linkedTexture);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateFenceGateBlockModel(DataGenBlockPackage blockPackage) {
        FenceGateBlock block = (FenceGateBlock)blockPackage.getBlock();
        String outputPath = this.blockTexture((Block)block).toString();
        ResourceLocation baseBlockOutputPath = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("planks")).get());
        BlockModelBuilder model = (BlockModelBuilder)this.models().fenceGate(outputPath + "_fence_gate", baseBlockOutputPath);
        BlockModelBuilder modelWall = (BlockModelBuilder)this.models().fenceGateWall(outputPath + "_fence_gate_wall", baseBlockOutputPath);
        BlockModelBuilder modelOpen = (BlockModelBuilder)this.models().fenceGateOpen(outputPath + "_fence_gate_open", baseBlockOutputPath);
        BlockModelBuilder modelWallOpen = (BlockModelBuilder)this.models().fenceGateWallOpen(outputPath + "_fence_gate_wall_open", baseBlockOutputPath);
        this.fenceGateBlock(block, (ModelFile)model, (ModelFile)modelOpen, (ModelFile)modelWall, (ModelFile)modelWallOpen);
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)model);
    }

    private void generateWallBlockModel(DataGenBlockPackage blockPackage) {
        WallBlock block = (WallBlock)blockPackage.getBlock();
        String outputPath = this.blockTexture((Block)block).toString();
        ResourceLocation baseBlockOutputPath = this.blockTexture((Block)((Supplier)blockPackage.getLinkedObject("source_block")).get());
        BlockModelBuilder inventoryModel = (BlockModelBuilder)this.models().wallInventory(outputPath + "_inventory", baseBlockOutputPath);
        this.wallBlock(block, baseBlockOutputPath);
        DataGenBlockModels.itemModel(this.itemModels(), blockPackage, (ModelFile)inventoryModel);
    }

    private void generateBaseModels() {
        this.generateShroomModel();
        this.generateBaseOreModel();
    }

    private void generateBaseOreModel() {
        ResourceLocation outputPath = new ResourceLocation("aoa3", "block/overlay_cube");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString(), this.mcLoc("block"))).texture("texture", "#")).texture("overlay", "#")).texture("particle", "#");
        ModelBuilder.ElementBuilder element = model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        element.allFaces((dir, faceBuilder) -> faceBuilder.texture("#texture").cullface(dir));
        element = model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        element.allFaces((dir, faceBuilder) -> faceBuilder.texture("#overlay").cullface(dir));
    }

    private void generateShroomModel() {
        ResourceLocation outputPath = new ResourceLocation("aoa3", "block/shroom_block");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(outputPath.toString(), this.mcLoc("block/block"))).texture("texture", "#")).texture("particle", "#");
        ModelBuilder.ElementBuilder element = model.element();
        element.from(0.0f, 6.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        element.face(Direction.NORTH).uvs(12.0f, 4.0f, 16.0f, 6.5f).texture("#texture");
        element.face(Direction.EAST).uvs(8.0f, 4.0f, 12.0f, 6.5f).texture("#texture");
        element.face(Direction.SOUTH).uvs(4.0f, 4.0f, 8.0f, 6.5f).texture("#texture");
        element.face(Direction.WEST).uvs(0.0f, 4.0f, 4.0f, 6.5f).texture("#texture");
        element.face(Direction.UP).uvs(0.0f, 0.0f, 4.0f, 4.0f).texture("#texture");
        element.face(Direction.DOWN).uvs(4.0f, 0.0f, 8.0f, 4.0f).texture("#texture");
        element = model.element();
        element.from(5.0f, 0.0f, 5.0f).to(11.0f, 6.0f, 11.0f);
        element.face(Direction.NORTH).uvs(14.5f, 1.5f, 16.0f, 3.0f).texture("#texture");
        element.face(Direction.EAST).uvs(13.0f, 1.5f, 14.5f, 3.0f).texture("#texture");
        element.face(Direction.SOUTH).uvs(11.5f, 1.5f, 13.0f, 3.0f).texture("#texture");
        element.face(Direction.WEST).uvs(10.0f, 1.5f, 11.5f, 3.0f).texture("#texture");
        element.face(Direction.UP).uvs(11.5f, 0.0f, 13.0f, 1.5f).texture("#texture");
        element.face(Direction.DOWN).uvs(13.0f, 0.0f, 14.5f, 1.5f).texture("#texture");
    }

    public static ResourceLocation extend(ResourceLocation path, String pathExtension) {
        return new ResourceLocation(path.m_135827_(), path.m_135815_() + pathExtension);
    }

    public static void itemModel(ItemModelProvider modelProvider, DataGenBlockPackage blockPackage, ModelFile blockModel) {
        if (blockPackage.hasItem()) {
            ((ItemModelBuilder)modelProvider.getBuilder(blockPackage.getRegistryName().toString())).parent(blockModel);
        }
    }

    public static enum ModelType {
        BASIC,
        BASIC_LINKED,
        GRASS,
        STAIRS,
        SLAB,
        BARK,
        FENCE,
        CARPET,
        PRESSURE_PLATE,
        BUTTON,
        LAMP,
        FENCE_GATE,
        WALL,
        CROSS,
        VINE,
        CROP,
        HANGING_CROP,
        MUSHROOM,
        SHROOM,
        ORE,
        PORTAL,
        FLUID,
        LADDER,
        DIRECTIONAL,
        MULTI_SIDE,
        NONE,
        POTTED_PLANT,
        HORIZONTAL_LINKED;

    }
}

