/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent.datagen;

import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.tslat.aoa3.advent.datagen.DataGenAdvancements;
import net.tslat.aoa3.advent.datagen.DataGenBlockModels;
import net.tslat.aoa3.advent.datagen.DataGenHaulingFish;
import net.tslat.aoa3.advent.datagen.DataGenItemModels;
import net.tslat.aoa3.advent.datagen.DataGenLang;
import net.tslat.aoa3.advent.datagen.DataGenParticles;
import net.tslat.aoa3.advent.datagen.DataGenPlayerStats;
import net.tslat.aoa3.advent.datagen.DataGenRealmstoneInserts;
import net.tslat.aoa3.advent.datagen.DataGenSkillReqs;
import net.tslat.aoa3.advent.datagen.DataGenSounds;
import net.tslat.aoa3.advent.datagen.DataGenTags;
import net.tslat.aoa3.advent.datagen.loot.DataGenBlockLootTables;
import net.tslat.aoa3.advent.datagen.loot.DataGenEntityLootTables;
import net.tslat.aoa3.advent.datagen.loot.DataGenLootModifiers;
import net.tslat.aoa3.advent.datagen.loot.DataGenMiscLootTables;
import net.tslat.aoa3.advent.datagen.recipes.DataGenRecipes;
import net.tslat.aoa3.advent.datagen.worldgen.feature.DataGenConfiguredFeatures;
import net.tslat.aoa3.advent.datagen.worldgen.feature.DataGenPlacedFeatures;
import net.tslat.aoa3.advent.datagen.worldgen.structure.DataGenStructureSets;
import net.tslat.aoa3.advent.datagen.worldgen.structure.DataGenStructures;
import net.tslat.aoa3.advent.datagen.worldgen.structure.DataGenTemplatePools;

@Mod.EventBusSubscriber(modid="aoa3", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGen {
    private static DataGenLang localeProvider = null;
    private static DataGenTags.Blocks blockTags = null;
    private static DataGenTags.Items itemTags = null;
    private static DataGenTags.Fluids fluidTags = null;
    private static DataGenTags.Biomes biomeTags = null;
    private static DataGenTags.ConfiguredStructures configuredStructures = null;
    private static DataGenTags.BannerPatterns bannerPatterns = null;

    @SubscribeEvent
    public static void onDataGen(GatherDataEvent ev) {
        DataGenerator generator = ev.getGenerator();
        ExistingFileHelper fileHelper = ev.getExistingFileHelper();
        if (ev.includeClient()) {
            localeProvider = new DataGenLang(generator);
        }
        if (ev.includeServer()) {
            blockTags = new DataGenTags.Blocks(generator, fileHelper);
            itemTags = new DataGenTags.Items(generator, fileHelper);
            fluidTags = new DataGenTags.Fluids(generator, fileHelper);
            biomeTags = new DataGenTags.Biomes(generator, fileHelper);
            configuredStructures = new DataGenTags.ConfiguredStructures(generator, fileHelper);
            bannerPatterns = new DataGenTags.BannerPatterns(generator, fileHelper);
        }
        if (ev.includeClient() && ev.includeServer()) {
            DataGen.handleCommonDatagen(ev);
        }
        if (ev.includeServer()) {
            DataGen.handleServerDatagen(ev);
        }
        if (ev.includeClient()) {
            DataGen.handleClientDatagen(ev);
        }
    }

    public static void forLocales(Consumer<DataGenLang> localeProvider) {
        if (DataGen.localeProvider != null) {
            localeProvider.accept(DataGen.localeProvider);
        }
    }

    public static void addBlockTag(Consumer<DataGenTags.Blocks> tagAdder) {
        blockTags.addTag(tagAdder);
    }

    public static void addItemTag(Consumer<DataGenTags.Items> tagAdder) {
        itemTags.addTag(tagAdder);
    }

    public static void addFluidTag(Consumer<DataGenTags.Fluids> tagAdder) {
        fluidTags.addTag(tagAdder);
    }

    public static void addBiomeTag(Consumer<DataGenTags.Biomes> tagAdder) {
        biomeTags.addTag(tagAdder);
    }

    public static void addConfiguredStructureTag(Consumer<DataGenTags.ConfiguredStructures> tagAdder) {
        configuredStructures.addTag(tagAdder);
    }

    private static void handleServerDatagen(GatherDataEvent ev) {
        DataGenerator generator = ev.getGenerator();
        generator.m_236039_(true, (DataProvider)new DataGenBlockLootTables(generator));
        generator.m_236039_(true, (DataProvider)new DataGenEntityLootTables(generator));
        generator.m_236039_(true, (DataProvider)new DataGenMiscLootTables(generator));
        generator.m_236039_(true, (DataProvider)new DataGenRecipes(generator));
        generator.m_236039_(true, (DataProvider)new DataGenAdvancements(generator));
        generator.m_236039_(true, (DataProvider)new DataGenLootModifiers(generator));
        generator.m_236039_(true, (DataProvider)new DataGenConfiguredFeatures(generator));
        generator.m_236039_(true, (DataProvider)new DataGenPlacedFeatures(generator));
        generator.m_236039_(true, (DataProvider)new DataGenStructures(generator));
        generator.m_236039_(true, (DataProvider)new DataGenTemplatePools(generator));
        generator.m_236039_(true, (DataProvider)new DataGenStructureSets(generator));
        generator.m_236039_(true, (DataProvider)new DataGenPlayerStats(generator));
        generator.m_236039_(true, (DataProvider)new DataGenSkillReqs(generator));
        generator.m_236039_(true, (DataProvider)new DataGenHaulingFish(generator));
        generator.m_236039_(true, (DataProvider)blockTags);
        generator.m_236039_(true, (DataProvider)itemTags);
        generator.m_236039_(true, (DataProvider)fluidTags);
        generator.m_236039_(true, (DataProvider)biomeTags);
        generator.m_236039_(true, (DataProvider)configuredStructures);
        generator.m_236039_(true, (DataProvider)bannerPatterns);
    }

    private static void handleClientDatagen(GatherDataEvent ev) {
        DataGenerator generator = ev.getGenerator();
        generator.m_236039_(false, (DataProvider)new DataGenItemModels(generator, ev.getExistingFileHelper()));
        generator.m_236039_(false, (DataProvider)new DataGenBlockModels(generator, ev.getExistingFileHelper()));
        generator.m_236039_(false, (DataProvider)new DataGenParticles(generator));
        generator.m_236039_(false, (DataProvider)new DataGenSounds(generator));
        generator.m_236039_(false, (DataProvider)new DataGenRealmstoneInserts(generator));
        generator.m_236039_(false, (DataProvider)localeProvider);
    }

    private static void handleCommonDatagen(GatherDataEvent ev) {
        DataGenerator generator = ev.getGenerator();
    }
}

