/*
 * Decompiled with CFR 0.152.
 */
package wraith.musica;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_215;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_219;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_91;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wraith.musica.Config;
import wraith.musica.Utils;
import wraith.musica.registry.BlockRegistry;
import wraith.musica.registry.CustomScreenHandlerRegistry;
import wraith.musica.registry.ItemRegistry;
import wraith.musica.registry.SoundEventsRegistry;

public class Musica
implements ModInitializer {
    public static final String MOD_ID = "musica";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean isReloading = false;

    public void onInitialize() {
        Config.saveFilesFromJar("configs", "", false);
        Config.getInstance().parseConfig();
        if (Config.getInstance().shouldOverrideConfigs()) {
            Config.saveFilesFromJar("configs", "", true);
        }
        this.registerLootTable();
        this.registerCommands();
        this.registerPacketHandlers();
        BlockRegistry.register();
        ItemRegistry.init();
        SoundEventsRegistry.init();
        CustomScreenHandlerRegistry.register();
        LOGGER.info("[Musica] has successfully been loaded!");
    }

    private void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("song_mixer.click_disc"), (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag != null && tag.method_10545("sync_id") && tag.method_10545("click_slot")) {
                server.execute(() -> {
                    int syncId = tag.method_10550("sync_id");
                    int button = tag.method_10550("click_slot");
                    if (player.field_7512.field_7763 == syncId) {
                        player.field_7512.method_7604((class_1657)player, button);
                    }
                });
            }
        });
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(2))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (!isReloading) {
                isReloading = true;
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[\u00a7eMusica\u00a76] \u00a73is being reloaded. \u00a74This might cause some lag!"), false);
                }
                Config.getInstance().parseConfig();
                MinecraftServer server = ((class_2168)context.getSource()).method_9211();
                server.method_29439(server.method_3836().method_29210());
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[\u00a7eMusica\u00a76] \u00a73has successfully reloaded!"), false);
                }
                isReloading = false;
            } else if (player != null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[\u00a7eMusica\u00a76] \u00a73is already being reloaded. Please be patient."), false);
            }
            return 1;
        }))));
    }

    private void registerLootTable() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, fabricLootSupplierBuilder, lootTableSetter) -> {
            String[] segments = id.toString().split(":");
            if (segments.length < 2) {
                return;
            }
            String[] segmentsPath = segments[1].split("/");
            if (segmentsPath.length < 2) {
                return;
            }
            boolean isEntity = "entities".equals(segmentsPath[0]);
            boolean isChest = "chests".equals(segmentsPath[0]);
            if (!isEntity && !isChest) {
                return;
            }
            String lootId = segments[0] + ":" + segmentsPath[1];
            if (isEntity) {
                if (!Config.getInstance().MOB_DROPS.containsKey(lootId)) {
                    return;
                }
                HashMap<String, HashMap<String, Float>> killers = Config.getInstance().MOB_DROPS.get(lootId);
                class_55.class_56 poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f));
                for (Map.Entry<String, HashMap<String, Float>> killer : killers.entrySet()) {
                    String killerId = killer.getKey();
                    for (Map.Entry<String, Float> items : killer.getValue().entrySet()) {
                        String item = items.getKey();
                        if (item.startsWith("#")) {
                            poolBuilder.with(class_91.method_35517((class_6862)class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)Utils.ID(item.substring(1)))).method_419());
                        } else {
                            poolBuilder.with(class_77.method_411((class_1935)ItemRegistry.get(item)).method_419());
                        }
                        poolBuilder.conditionally(class_219.method_932((float)(items.getValue().floatValue() / 100.0f)).build());
                        if ("any".equals(killerId)) continue;
                        if (killerId.startsWith("#")) {
                            poolBuilder.conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_936, (class_2048)class_2048.class_2049.method_8916().method_8922(class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960(killerId.substring(1)))).method_8920()).build());
                            continue;
                        }
                        poolBuilder.conditionally(class_215.method_27865((class_47.class_50)class_47.class_50.field_936, (class_2048)class_2048.class_2049.method_8916().method_8921((class_1299)class_2378.field_11145.method_10223(new class_2960(killerId))).method_8920()).build());
                    }
                }
                fabricLootSupplierBuilder.pool(poolBuilder.method_355());
            } else {
                if (!Config.getInstance().TREASURES.containsKey(lootId)) {
                    return;
                }
                HashMap<String, Float> discs = Config.getInstance().TREASURES.get(lootId);
                class_55.class_56 poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f));
                for (Map.Entry<String, Float> disc : discs.entrySet()) {
                    String item = disc.getKey();
                    if (item.startsWith("#")) {
                        poolBuilder.with(class_91.method_35517((class_6862)class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)Utils.ID(item.substring(1)))).method_419());
                    } else {
                        poolBuilder.with(class_77.method_411((class_1935)ItemRegistry.get(item)).method_419());
                    }
                    poolBuilder.conditionally(class_219.method_932((float)(disc.getValue().floatValue() / 100.0f)).build());
                }
                fabricLootSupplierBuilder.pool(poolBuilder.method_355());
            }
        });
    }
}

