/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftcapes.MinecraftCapesConstants;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.helpers.MinecraftApi;
import net.minecraftcapes.player.PlayerHandler;
import org.apache.commons.io.FileUtils;

public class DownloadManager {
    public static void prepareDownload(Player player, boolean doRefresh) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (player.m_20148_().version() != 4 && localPlayer != null && !localPlayer.m_20148_().equals(player.m_20148_())) {
            return;
        }
        PlayerHandler playerHandler = PlayerHandler.getFromPlayer(player);
        if (player.m_20148_().version() != 4 && !playerHandler.getHasInfo().booleanValue() && !doRefresh) {
            playerHandler.setHasInfo(true);
            Thread playerDownload = new Thread(() -> {
                UUID uuid = MinecraftApi.getUUID(player.m_6302_());
                if (uuid == null) {
                    return;
                }
                playerHandler.setPlayerUUID(uuid);
                DownloadManager.downloadProfile(playerHandler);
            });
            playerDownload.setDaemon(true);
            playerDownload.start();
        } else {
            if (playerHandler.getHasInfo().booleanValue() && !doRefresh) {
                return;
            }
            DownloadManager.downloadProfile(playerHandler);
        }
    }

    private static void downloadProfile(PlayerHandler playerHandler) {
        Thread playerDownload = new Thread(() -> {
            playerHandler.setHasInfo(true);
            try {
                MinecraftCapesConstants.LOG.debug("Getting profile for {}", (Object)playerHandler.getPlayerUUID());
                URL url = new URL("https://minecraftcapes.net/profile/" + playerHandler.getPlayerUUID().toString().replace("-", ""));
                HttpURLConnection httpurlconnection = (HttpURLConnection)url.openConnection(Minecraft.m_91087_().m_91096_());
                httpurlconnection.setDoInput(true);
                httpurlconnection.setDoOutput(false);
                httpurlconnection.connect();
                if (httpurlconnection.getResponseCode() / 100 == 2) {
                    InputStreamReader reader = new InputStreamReader(httpurlconnection.getInputStream(), StandardCharsets.UTF_8);
                    DownloadManager.readProfile(playerHandler, reader);
                    ((Reader)reader).close();
                } else {
                    DownloadManager.loadOfflineProfile(playerHandler);
                    MinecraftCapesConstants.LOG.warn("minecraftcapes.net returned a {}", (Object)httpurlconnection.getResponseCode());
                }
            }
            catch (IOException e) {
                DownloadManager.loadOfflineProfile(playerHandler);
                MinecraftCapesConstants.LOG.warn("No connection to minecraftcapes.net detected");
            }
        });
        playerDownload.setDaemon(true);
        playerDownload.start();
    }

    private static void readProfile(PlayerHandler playerHandler, Reader reader) {
        ProfileResult profileResult = (ProfileResult)new Gson().fromJson(reader, ProfileResult.class);
        playerHandler.setHasCapeGlint(profileResult.capeGlint);
        playerHandler.setUpsideDown(profileResult.upsideDown);
        if (profileResult.textures.get("cape") != null) {
            playerHandler.applyCape(profileResult.textures.get("cape"));
        }
        if (profileResult.textures.get("ears") != null) {
            playerHandler.applyEars(profileResult.textures.get("ears"));
        }
        DownloadManager.cacheProfile(playerHandler, profileResult);
    }

    private static void cacheProfile(PlayerHandler playerHandler, ProfileResult profileResult) {
        String fileName = playerHandler.getPlayerUUID().toString();
        String profileJson = new Gson().toJson((Object)profileResult);
        File profileDirectory = new File(MinecraftCapesConfig.getModDirectory() + "/profile");
        File profileFile = new File(new File(profileDirectory, fileName.length() > 2 ? fileName.substring(0, 2) : "xx"), fileName);
        try {
            FileUtils.writeStringToFile((File)profileFile, (String)profileJson, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            MinecraftCapesConstants.LOG.error("Error writing cache file");
            e.printStackTrace();
        }
    }

    private static void loadOfflineProfile(PlayerHandler playerHandler) {
        String fileName = playerHandler.getPlayerUUID().toString();
        File profileDirectory = new File(MinecraftCapesConfig.getModDirectory() + "/profile");
        File profileFile = new File(new File(profileDirectory, fileName.length() > 2 ? fileName.substring(0, 2) : "xx"), fileName);
        if (profileFile.exists()) {
            try {
                FileReader reader = new FileReader(profileFile);
                DownloadManager.readProfile(playerHandler, reader);
                ((Reader)reader).close();
            }
            catch (Exception e) {
                MinecraftCapesConstants.LOG.error("Cache corrupt for {}", (Object)fileName);
                profileFile.delete();
            }
        }
    }

    private static class ProfileResult {
        private boolean capeGlint = false;
        private boolean upsideDown = false;
        private Map<String, String> textures = null;

        private ProfileResult() {
        }
    }
}

