/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.helpers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import net.minecraftcapes.MinecraftCapesConstants;

public class MinecraftApi {
    public static UUID getUUID(String username) {
        JsonElement playerUUID;
        MinecraftCapesConstants.LOG.warn("Making an API call for {}", (Object)username);
        JsonObject playerElement = MinecraftApi.getApiData(username);
        if (playerElement != null && (playerUUID = playerElement.get("full_uuid")) != null && !playerUUID.isJsonNull()) {
            MinecraftCapesConstants.LOG.warn("{} ({}) was found", (Object)username, (Object)playerUUID);
            return UUID.fromString(playerUUID.getAsString());
        }
        MinecraftCapesConstants.LOG.warn("{} was not found", (Object)username);
        return null;
    }

    private static JsonObject getApiData(String data) {
        try {
            URL url = new URL("https://minecraftapi.net/api/v1/profile/" + data);
            HttpURLConnection httpurlconnection = (HttpURLConnection)url.openConnection();
            httpurlconnection.setDoInput(true);
            httpurlconnection.setDoOutput(false);
            httpurlconnection.connect();
            if (httpurlconnection.getResponseCode() / 100 == 2) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(httpurlconnection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                return JsonParser.parseString((String)response.toString()).getAsJsonObject();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

