/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.sound;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.sound.Sound;

public class SoundPlayer {
    private final Accessor accessor;
    private final MALogger logger;
    private final List<ScheduledSound> scheduledSounds = new LinkedList<ScheduledSound>();

    public SoundPlayer(Accessor accessor, MALogger logger) {
        this.accessor = accessor;
        this.logger = logger;
    }

    public void update() {
        long time = System.currentTimeMillis();
        Iterator<ScheduledSound> iter = this.scheduledSounds.iterator();
        while (iter.hasNext()) {
            ScheduledSound sound = iter.next();
            if (time - sound.startTime < (long)sound.delay) continue;
            this.logger.log("Play Delayed " + sound.name);
            if (sound.global) {
                this.accessor.playGlobalSound(sound.name, sound.x, sound.y, sound.z, sound.volume, sound.pitch);
            } else {
                this.accessor.playSound(sound.name, sound.x, sound.y, sound.z, sound.volume, sound.pitch);
            }
            iter.remove();
        }
    }

    public void playSound(Sound sound, double x, double y, double z, boolean global) {
        if (sound.probability() < 1.0 && Math.random() >= sound.probability()) {
            return;
        }
        float volume = sound.calculateRandomVolume();
        float pitch = sound.calculateRandomPitch();
        if (sound.delay() > 0) {
            this.scheduledSounds.add(new ScheduledSound(sound.name(), x, y, z, volume, pitch, global, sound.delay(), System.currentTimeMillis()));
        } else {
            this.logger.log("Play " + sound.name());
            if (global) {
                this.accessor.playGlobalSound(sound.name(), x, y, z, volume, pitch);
            } else {
                this.accessor.playSound(sound.name(), x, y, z, volume, pitch);
            }
        }
    }

    private record ScheduledSound(String name, double x, double y, double z, float volume, float pitch, boolean global, int delay, long startTime) {
    }
}

