/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.scan;

import java.util.HashMap;
import java.util.Map;
import me.andre111.mambience.accessor.Accessor;

public final class Variables {
    private final Accessor accessor;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final Map<String, Object> previousValues = new HashMap<String, Object>();

    public Variables(Accessor a) {
        this.accessor = a;
    }

    public void update() {
        this.put("x", this.accessor.getX());
        this.put("y", this.accessor.getY());
        this.put("z", this.accessor.getZ());
        this.put("health", this.accessor.getHealth());
        this.put("foodLevel", this.accessor.getFoodLevel());
        this.put("sneaking", this.accessor.isSneaking());
        this.put("jumping", this.accessor.isJumping());
        this.put("onGround", this.accessor.isOnGround());
        boolean exposed = Variables.fastExposedCheck(this.accessor);
        this.put("exposed", exposed);
        this.put("underground", !exposed && this.accessor.getY() < 56.0);
        this.put("submerged", this.accessor.isSubmerged());
        this.put("time", this.accessor.getDayTime());
        this.put("raining", this.accessor.isRaining());
        this.put("thundering", this.accessor.isThundering());
        this.put("temperature", this.accessor.getTemperature((int)this.accessor.getX(), (int)this.accessor.getY(), (int)this.accessor.getZ()));
        this.put("humidity", this.accessor.getHumidity((int)this.accessor.getX(), (int)this.accessor.getY(), (int)this.accessor.getZ()));
        this.put("itemMainHand", this.accessor.getHeldItem(true));
        this.put("itemOffHand", this.accessor.getHeldItem(false));
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public Object getPrevious(String key) {
        return this.previousValues.get(key);
    }

    private void put(String key, Object value) {
        this.previousValues.put(key, this.values.put(key, value));
    }

    private static boolean fastExposedCheck(Accessor accessor) {
        int x = (int)accessor.getX();
        int y = (int)accessor.getY();
        int z = (int)accessor.getZ();
        int mx = x + 1;
        int my = y + 1;
        int mz = z + 1;
        for (int cx = mx - 2; cx <= mx; ++cx) {
            for (int cy = my - 2; cy <= my; ++cy) {
                for (int cz = mz - 2; cz <= mz; ++cz) {
                    if (!accessor.getBlock(cx, cy, cz).equals("minecraft:air") || accessor.getSkyLight(cx, cy, cz) <= 4) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

