/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.data.loader;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.config.ConfigUtil;
import me.andre111.mambience.footstep.FSMaterial;
import me.andre111.mambience.sound.Sound;

public final class MaterialLoader {
    private static final Map<String, FSMaterial> MATERIALS = new HashMap<String, FSMaterial>();
    private static final FSMaterial NONE = new FSMaterial("mambience:none", new Sound[0], new Sound[0], new Sound[0], new Sound[0], new Sound[0]);

    public static void reset() {
        MATERIALS.clear();
    }

    public static void loadMaterial(String id, JsonObject obj) {
        MATERIALS.put(id, MaterialLoader.loadMaterialInternal(id, obj));
    }

    private static FSMaterial loadMaterialInternal(String id, JsonObject obj) {
        Sound[] wanderSounds = ConfigUtil.loadSounds(obj.get("wander"), Config.footsteps().getVolume());
        Sound[] walkSounds = ConfigUtil.loadSounds(obj.get("walk"), Config.footsteps().getVolume());
        Sound[] runSounds = ConfigUtil.loadSounds(obj.get("run"), Config.footsteps().getVolume());
        Sound[] jumpSounds = ConfigUtil.loadSounds(obj.get("jump"), Config.footsteps().getVolume());
        Sound[] landSounds = ConfigUtil.loadSounds(obj.get("land"), Config.footsteps().getVolume());
        return new FSMaterial(id, wanderSounds, walkSounds, runSounds, jumpSounds, landSounds);
    }

    public static FSMaterial getMaterial(String id) {
        if (!((String)id).contains(":")) {
            id = "mambience:" + (String)id;
        }
        if (MATERIALS.containsKey(id)) {
            return MATERIALS.get(id);
        }
        return NONE;
    }
}

