/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.data.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.andre111.mambience.MAmbience;
import me.andre111.mambience.data.Data;
import me.andre111.mambience.data.DataLocator;
import me.andre111.mambience.data.loader.EffectLoader;
import me.andre111.mambience.data.loader.EventLoader;
import me.andre111.mambience.data.loader.FootstepLoader;
import me.andre111.mambience.data.loader.MaterialLoader;

public class DataLoader {
    public static void reload(DataLocator locator) {
        MaterialLoader.reset();
        EffectLoader.reset();
        EventLoader.reset();
        DataLoader.loadEntries(locator, "ma_materials", MaterialLoader::loadMaterial);
        DataLoader.loadEntries(locator, "ma_sounds", EventLoader::loadEvent);
        DataLoader.loadEntries(locator, "ma_effects", EffectLoader::loadEffect);
        DataLoader.loadReplaceable(locator, "mambience:ma_footsteps.json", FootstepLoader::reset, FootstepLoader::loadFootsteps);
    }

    private static void loadEntries(DataLocator locator, String startingPath, BiConsumer<String, JsonObject> callback) {
        HashSet<String> loaded = new HashSet<String>();
        for (String id : locator.findData(startingPath, path -> path.endsWith(".json"))) {
            if (loaded.contains(id)) continue;
            loaded.add(id);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(locator.getData(id).openInputStream()));){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element instanceof JsonObject) {
                    JsonObject object = (JsonObject)element;
                    String actualID = id.substring(0, id.length() - 5).replace(startingPath + "/", "");
                    MAmbience.getLogger().log("Loading " + actualID + " - " + id);
                    callback.accept(actualID.toString(), object);
                    continue;
                }
                throw new RuntimeException("Root is not a json object");
            }
            catch (Exception e) {
                MAmbience.getLogger().error("Exception while loading json " + id.toString() + ": " + e.getMessage());
            }
        }
    }

    private static void loadReplaceable(DataLocator locator, String id, Runnable resetCallback, Consumer<JsonObject> callback) {
        try {
            resetCallback.run();
            for (Data data : locator.getAllData(id)) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(data.openInputStream()));){
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    if (element instanceof JsonObject) {
                        JsonObject object = (JsonObject)element;
                        if (object.has("replace") && object.get("replace").isJsonPrimitive() && object.get("replace").getAsBoolean()) {
                            resetCallback.run();
                        }
                        callback.accept(object);
                        continue;
                    }
                    throw new RuntimeException("Root is not a json object");
                }
                catch (Exception e) {
                    MAmbience.getLogger().error("Exception while loading json " + id.toString() + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            MAmbience.getLogger().error("Exception while loading json " + id.toString() + ": " + e.getMessage());
        }
    }
}

