/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.data.fallback;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.andre111.mambience.MAmbience;
import me.andre111.mambience.data.Data;
import me.andre111.mambience.data.DataLocator;
import me.andre111.mambience.data.fallback.ZipFileEntryData;

public class FallbackDatapackDataLocator
implements DataLocator {
    private final List<ZipFile> datapackZipFiles = new ArrayList<ZipFile>();

    public FallbackDatapackDataLocator(File datapackDirectory) {
        File[] files = datapackDirectory.listFiles();
        Arrays.sort(files, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        for (File file : datapackDirectory.listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".zip")) continue;
            try {
                this.datapackZipFiles.add(new ZipFile(file));
            }
            catch (IOException e) {
                MAmbience.getLogger().error("Skipping datapack: " + file.getName() + " - not a valid zip file?");
            }
        }
    }

    @Override
    public Collection<String> findData(String startingPath, Predicate<String> pathPredicate) {
        HashSet<String> ids = new HashSet<String>();
        for (ZipFile zipFile : this.datapackZipFiles) {
            zipFile.stream().map(entry -> entry.getName()).filter(path -> {
                path = path.replaceFirst("data/", "");
                return (path = path.substring(path.indexOf(47) + 1)).startsWith(startingPath + "/") && pathPredicate.test((String)path);
            }).forEach(path -> ids.add(this.pathToID((String)path)));
        }
        return ids;
    }

    @Override
    public Data getData(String id) throws IOException {
        String path = this.idToPath(id);
        for (ZipFile zipFile : this.datapackZipFiles) {
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) continue;
            return new ZipFileEntryData(zipFile, entry);
        }
        return null;
    }

    @Override
    public List<Data> getAllData(String id) throws IOException {
        String path = this.idToPath(id);
        ArrayList<Data> data = new ArrayList<Data>();
        for (ZipFile zipFile : this.datapackZipFiles) {
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) continue;
            data.add(0, new ZipFileEntryData(zipFile, entry));
        }
        return data;
    }

    public void close() {
        for (ZipFile zipFile : this.datapackZipFiles) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String idToPath(String id) {
        String namespace = id.substring(0, id.indexOf(58));
        String path = id.substring(id.indexOf(58) + 1);
        return "data/" + namespace + "/" + path;
    }

    private String pathToID(String path) {
        return path.replaceFirst("data/", "").replaceFirst("/", ":");
    }
}

