/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import com.google.gson.JsonObject;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.condition.ConditionBiomes;
import me.andre111.mambience.condition.ConditionBlocks;
import me.andre111.mambience.condition.ConditionDisableWind;
import me.andre111.mambience.condition.ConditionHeldItem;
import me.andre111.mambience.condition.ConditionVariable;
import me.andre111.mambience.condition.ConditionVariableChanged;
import me.andre111.mambience.config.ConfigUtil;

public final class Parser {
    private static final Condition TIME_MORNING = new ConditionVariable("time", false, 0.0, 2000.0);
    private static final Condition TIME_DAY = new ConditionVariable("time", false, 2000.0, 12000.0);
    private static final Condition TIME_EVENING = new ConditionVariable("time", false, 12000.0, 14000.0);
    private static final Condition TIME_NIGHT = new ConditionVariable("time", false, 14000.0, 24000.0);
    private static final Condition EXPOSED = new ConditionVariable("exposed", false);
    private static final Condition SUBMERGED = new ConditionVariable("submerged", false);
    private static final Condition UNDERGROUND = new ConditionVariable("underground", false);
    private static final Condition RAINING = new ConditionVariable("raining", false);
    private static final Condition THUNDERING = new ConditionVariable("thundering", false);
    private static final Condition DISABLE_WIND = new ConditionDisableWind();

    public static Condition parse(String name, JsonObject obj) {
        switch (name) {
            case "TIME": {
                return new ConditionVariable("time", false, ConfigUtil.getInt(obj, "minTime", 0), ConfigUtil.getInt(obj, "maxTime", 0));
            }
            case "TIME_MORNING": {
                return TIME_MORNING;
            }
            case "TIME_DAY": {
                return TIME_DAY;
            }
            case "TIME_EVENING": {
                return TIME_EVENING;
            }
            case "TIME_NIGHT": {
                return TIME_NIGHT;
            }
            case "BIOME": {
                return new ConditionBiomes(Parser.namespaced(ConfigUtil.getString(obj, "biomeOrTag", null)), ConfigUtil.getFloat(obj, "minPercentage", 0.001f));
            }
            case "BLOCK": {
                return new ConditionBlocks(Parser.namespaced(ConfigUtil.getString(obj, "blockOrTag", null)), ConfigUtil.getFloat(obj, "minPercentage", 0.001f));
            }
            case "HELD_ITEM": {
                return new ConditionHeldItem(Parser.namespaced(ConfigUtil.getString(obj, "itemOrTag", null)), ConfigUtil.getBoolean(obj, "mainHand", true));
            }
            case "HEIGHT": {
                return new ConditionVariable("y", false, ConfigUtil.getInt(obj, "minHeight", 0), ConfigUtil.getInt(obj, "maxHeight", 0));
            }
            case "EXPOSED": {
                return EXPOSED;
            }
            case "SUBMERGED": {
                return SUBMERGED;
            }
            case "UNDERGROUND": {
                return UNDERGROUND;
            }
            case "RAINING": {
                return RAINING;
            }
            case "THUNDERING": {
                return THUNDERING;
            }
            case "VARIABLE": {
                return new ConditionVariable(ConfigUtil.getString(obj, "variable", ""), ConfigUtil.getBoolean(obj, "previous", false), ConfigUtil.getDouble(obj, "minValue", 0.0f), ConfigUtil.getDouble(obj, "maxValue", 0.0f), ConfigUtil.getString(obj, "stringValue", ""));
            }
            case "VARIABLE_CHANGED": {
                return new ConditionVariableChanged(ConfigUtil.getString(obj, "variable", ""));
            }
            case "DISABLE_WIND": {
                return DISABLE_WIND;
            }
        }
        return null;
    }

    private static String namespaced(String name) {
        return name.contains(":") ? name : "minecraft:" + name;
    }
}

