/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import java.util.ArrayList;
import java.util.List;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;

public final class ConditionHeldItem
extends Condition {
    private final String itemOrTag;
    private final boolean mainHand;
    private List<String> cachedItems;

    public ConditionHeldItem(String itemOrTag, boolean mainHand) {
        if (itemOrTag == null) {
            throw new IllegalArgumentException("Item / Itemtag cannot be null");
        }
        this.itemOrTag = itemOrTag;
        this.mainHand = mainHand;
    }

    @Override
    public boolean matches(MAPlayer player) {
        if (this.cachedItems == null) {
            this.cachedItems = new ArrayList<String>();
            if (this.itemOrTag.startsWith("#")) {
                this.cachedItems.addAll(player.getAccessor().getItemTag(this.itemOrTag.substring(1)));
            } else {
                this.cachedItems.add(this.itemOrTag);
            }
        }
        return this.cachedItems.contains(player.getAccessor().getHeldItem(this.mainHand));
    }
}

