/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;

public final class ConditionBiomes
extends Condition {
    private final String biomeOrTag;
    private final float minPercentage;
    private List<String> cachedBiomes;

    public ConditionBiomes(String biomeOrTag, float minPercentage) {
        if (biomeOrTag == null) {
            throw new IllegalArgumentException("Biome / Biometag cannot be null");
        }
        if (minPercentage < 0.0f || minPercentage > 1.0f) {
            throw new IllegalArgumentException("Minimum percentage is outside valid range [0,1]");
        }
        this.biomeOrTag = biomeOrTag;
        this.minPercentage = minPercentage;
    }

    @Override
    public boolean matches(MAPlayer player) {
        float percentage;
        if (this.cachedBiomes == null) {
            this.cachedBiomes = new ArrayList<String>();
            if (this.biomeOrTag.startsWith("#")) {
                this.cachedBiomes.addAll(player.getAccessor().getBiomeTag(this.biomeOrTag.substring(1)));
            } else {
                this.cachedBiomes.add(this.biomeOrTag);
            }
        }
        Map<String, Integer> scanData = player.getScanner().getScanBiomeData();
        int count = 0;
        if (scanData != null) {
            for (String biome : this.cachedBiomes) {
                count += scanData.getOrDefault(biome, 0).intValue();
            }
        }
        return (percentage = (float)count / (float)player.getScanner().getScanBiomeCount()) >= this.minPercentage;
    }
}

