/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.accessor;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.andre111.mambience.accessor.Accessor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AccessorBukkit
extends Accessor {
    private Player player;

    public AccessorBukkit(UUID playerUUID) {
        super(playerUUID);
    }

    @Override
    public boolean updatePlayerInstance() {
        this.player = Bukkit.getPlayer((UUID)this.playerUUID);
        return this.player != null;
    }

    @Override
    public double getX() {
        return this.player.getLocation().getX();
    }

    @Override
    public double getY() {
        return this.player.getLocation().getY();
    }

    @Override
    public double getZ() {
        return this.player.getLocation().getZ();
    }

    @Override
    public double getRotation() {
        return Math.toRadians(this.player.getLocation().getYaw());
    }

    @Override
    public double getHealth() {
        return this.player.getHealth();
    }

    @Override
    public double getFoodLevel() {
        return this.player.getFoodLevel();
    }

    @Override
    public boolean isSubmerged() {
        return this.player.isInWater();
    }

    @Override
    public boolean isSneaking() {
        return this.player.isSneaking();
    }

    @Override
    public boolean isJumping() {
        return !this.player.isOnGround() && this.player.getVehicle() == null && !this.player.isGliding() && !this.player.isClimbing();
    }

    @Override
    public boolean isOnGround() {
        return this.player.isOnGround();
    }

    @Override
    public String getArmor(int index) {
        ItemStack itemStack = this.player.getInventory().getArmorContents()[index];
        return itemStack != null ? itemStack.getType().getKey().toString() : "";
    }

    @Override
    public String getHeldItem(boolean mainHand) {
        ItemStack itemStack = mainHand ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return itemStack != null ? itemStack.getType().getKey().toString() : "";
    }

    @Override
    public void playSound(String sound, float volume, float pitch) {
        this.player.playSound(this.player.getLocation(), sound, SoundCategory.AMBIENT, volume, pitch);
    }

    @Override
    public void playSound(String sound, double x, double y, double z, float volume, float pitch) {
        this.player.playSound(new Location(this.player.getWorld(), x, y, z), sound, SoundCategory.AMBIENT, volume, pitch);
    }

    @Override
    public void playGlobalSound(String sound, double x, double y, double z, float volume, float pitch) {
        this.player.getWorld().playSound(new Location(this.player.getWorld(), x, y, z), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    @Override
    public void stopSound(String sound) {
        this.player.stopSound(sound, SoundCategory.AMBIENT);
    }

    @Override
    public void addParticle(String type, String parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        switch (type) {
            case "minecraft:block": {
                this.player.spawnParticle(Particle.BLOCK_CRACK, x, y, z, 0, velocityX, velocityY, velocityZ, 1.0, (Object)Bukkit.createBlockData((String)parameters));
                break;
            }
            case "minecraft:item": {
                this.player.spawnParticle(Particle.ITEM_CRACK, x, y, z, 0, velocityX, velocityY, velocityZ, 1.0, (Object)new ItemStack(Bukkit.createBlockData((String)parameters).getMaterial()));
                break;
            }
            case "minecraft:flame": {
                this.player.spawnParticle(Particle.FLAME, x, y, z, 0, velocityX, velocityY, velocityZ, 1.0);
                break;
            }
            case "minecraft:lava": {
                this.player.spawnParticle(Particle.LAVA, x, y, z, 0, velocityX, velocityY, velocityZ, 1.0);
                break;
            }
            case "minecraft:smoke": {
                this.player.spawnParticle(Particle.SMOKE_NORMAL, x, y, z, 0, velocityX, velocityY, velocityZ, 1.0);
                break;
            }
            case "minecraft:end_rod": {
                this.player.spawnParticle(Particle.END_ROD, x, y, z, 0, velocityX, velocityY, velocityZ, 1.0);
                break;
            }
            default: {
                throw new RuntimeException("Particle Type not implemented: " + type);
            }
        }
    }

    @Override
    public long getDayTime() {
        return this.player.getWorld().getTime();
    }

    @Override
    public long getFullTime() {
        return this.player.getWorld().getFullTime();
    }

    @Override
    public boolean isRaining() {
        return this.player.getWorld().hasStorm();
    }

    @Override
    public boolean isThundering() {
        return this.player.getWorld().isThundering();
    }

    @Override
    public String getBlock(int x, int y, int z) {
        return this.player.getWorld().getBlockAt(x, y, z).getType().getKey().toString();
    }

    @Override
    public String getBiome(int x, int y, int z) {
        return this.player.getWorld().getBiome(x, y, z).getKey().toString();
    }

    @Override
    public String getDimension() {
        return this.player.getWorld().getName();
    }

    @Override
    public int getLight(int x, int y, int z) {
        return this.player.getWorld().getBlockAt(x, y, z).getLightLevel();
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.player.getWorld().getBlockAt(x, y, z).getLightFromBlocks();
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.player.getWorld().getBlockAt(x, y, z).getLightFromSky();
    }

    @Override
    public double getTemperature(int x, int y, int z) {
        return this.player.getWorld().getTemperature(x, y, z);
    }

    @Override
    public double getHumidity(int x, int y, int z) {
        return this.player.getWorld().getHumidity(x, y, z);
    }

    @Override
    public List<String> getBlockTag(String name) {
        Tag tag = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.fromString((String)name), Material.class);
        return tag != null ? tag.getValues().stream().map(m -> m.getKey().toString()).collect(Collectors.toList()) : List.of();
    }

    @Override
    public List<String> getBiomeTag(String name) {
        Tag tag = Bukkit.getTag((String)"biomes", (NamespacedKey)NamespacedKey.fromString((String)name), Biome.class);
        return tag != null ? tag.getValues().stream().map(m -> m.getKey().toString()).collect(Collectors.toList()) : List.of();
    }

    @Override
    public List<String> getItemTag(String name) {
        Tag tag = Bukkit.getTag((String)"items", (NamespacedKey)NamespacedKey.fromString((String)name), Material.class);
        return tag != null ? tag.getValues().stream().map(m -> m.getKey().toString()).collect(Collectors.toList()) : List.of();
    }
}

